/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.platform.scanner.dlp.service;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.platform.scanner.dlp.DataLossPreventionScanner;
import org.nuxeo.platform.scanner.dlp.service.RedactionProvider;
import org.nuxeo.platform.scanner.dlp.service.ScanConfigurationDescriptor;
import org.nuxeo.platform.scanner.dlp.service.ScanProvider;
import org.nuxeo.platform.scanner.dlp.service.ScanProviderDescriptor;
import org.nuxeo.platform.scanner.dlp.service.ScanResult;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ScanComponent
extends DefaultComponent
implements DataLossPreventionScanner {
    protected static final String CONFIG_EXT_POINT = "configuration";
    protected static final String PROVIDER_EXT_POINT = "provider";
    protected ScanConfigurationDescriptor config;
    protected Map<String, ScanProvider> providers = new HashMap<String, ScanProvider>();

    public void activate(ComponentContext context) {
        super.activate(context);
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CONFIG_EXT_POINT.equals(extensionPoint)) {
            this.config = (ScanConfigurationDescriptor)contribution;
        } else if (PROVIDER_EXT_POINT.equals(extensionPoint)) {
            ScanProviderDescriptor desc = (ScanProviderDescriptor)contribution;
            try {
                ScanProvider provider = (ScanProvider)desc.getKlass().getConstructor(new Class[0]).newInstance(new Object[0]);
                this.providers.put(desc.getProviderName(), provider);
            }
            catch (ReflectiveOperationException e) {
                throw new NuxeoException((Throwable)e);
            }
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
    }

    @Override
    public ScanResult identify(Blob blob) throws IOException {
        return this.identify(this.config.getDefaultProviderName(), blob, null, null);
    }

    @Override
    public ScanResult identify(Blob blob, List<String> features, Integer maxResults) throws IOException, IllegalStateException {
        return this.identify(this.config.getDefaultProviderName(), blob, features, maxResults);
    }

    @Override
    public List<ScanResult> identify(List<Blob> blobs, List<String> features, Integer maxResults) throws IOException, IllegalStateException {
        return this.identify(this.config.getDefaultProviderName(), blobs, features, maxResults);
    }

    @Override
    public ScanResult identify(String providerName, Blob blob, List<String> features, Integer maxResults) throws IOException {
        if (blob == null) {
            throw new IllegalArgumentException("Input Blob cannot be null");
        }
        List<ScanResult> results = this.identify(providerName, Arrays.asList(blob), features, maxResults);
        if (results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    @Override
    public List<ScanResult> identify(String providerName, List<Blob> blobs, List<String> features, Integer maxResults) throws IOException {
        ScanProvider provider = this.providers.get(providerName);
        if (provider == null) {
            throw new NuxeoException("Unknown provider: " + providerName);
        }
        if (!provider.isEnabled()) {
            return Collections.emptyList();
        }
        if (blobs == null || blobs.size() == 0) {
            throw new IllegalArgumentException("Input Blob list cannot be null or empty");
        }
        if (!provider.checkBlobs(blobs)) {
            throw new IllegalArgumentException("Too many blobs or size exceeds the API limit");
        }
        return provider.identify(blobs, features, maxResults);
    }

    @Override
    public Blob redact(Blob blob) {
        return this.redact(this.config.getDefaultProviderName(), blob, null);
    }

    @Override
    public Blob redact(Blob blob, List<String> features) {
        return this.redact(this.config.getDefaultProviderName(), blob, features);
    }

    @Override
    public List<Blob> redact(List<Blob> blobs, List<String> features) {
        return this.redact(this.config.getDefaultProviderName(), blobs, features);
    }

    @Override
    public Blob redact(String provider, Blob blob, List<String> features) {
        if (blob == null) {
            throw new IllegalArgumentException("Input Blob cannot be null");
        }
        List<Blob> results = this.redact(provider, Arrays.asList(blob), features);
        if (results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    @Override
    public List<Blob> redact(String providerName, List<Blob> blobs, List<String> features) {
        ScanProvider provider = this.providers.get(providerName);
        if (!provider.isEnabled()) {
            return Collections.emptyList();
        }
        RedactionProvider redact = null;
        if (provider.supportsRedaction()) {
            redact = (RedactionProvider)((Object)provider);
        }
        if (redact == null) {
            throw new NuxeoException("Unknown provider: " + providerName);
        }
        if (blobs == null || blobs.size() == 0) {
            throw new IllegalArgumentException("Input Blob list cannot be null or empty");
        }
        if (!provider.checkBlobs(blobs)) {
            throw new IllegalArgumentException("Too many blobs or size exceeds the API limit");
        }
        return redact.redact(blobs, features);
    }

    @Override
    public String getDefaultProvider() {
        return this.config.getDefaultProviderName();
    }

    @Override
    public ScanProvider getProvider(String name) {
        return this.providers.get(name);
    }

    @Override
    public Map<String, ScanProvider> getProviders() {
        return this.providers;
    }
}

