/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.platform.scanner.dlp.operations;

import java.io.IOException;
import java.util.List;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.platform.scanner.dlp.DataLossPreventionScanner;
import org.nuxeo.platform.scanner.dlp.service.RedactionProvider;
import org.nuxeo.platform.scanner.dlp.service.ScanProvider;

@Operation(id="Blob.RedactSensitiveData", category="Files", label="Redact Sensitive Information", description="Redact sensitive information on a piece of content.")
public class RedactSensitiveDataOperation {
    public static final String ID = "Blob.RedactSensitiveData";
    @Context
    protected DataLossPreventionScanner service;
    @Param(name="infotypes", required=false)
    protected StringList infoTypes;

    @OperationMethod
    public Blob run(DocumentModel doc) {
        ScanProvider scanner = this.service.getProvider(this.service.getDefaultProvider());
        if (scanner.supportsRedaction()) {
            RedactionProvider redact = (RedactionProvider)((Object)scanner);
            return redact.redactDocument(doc, (List<String>)this.infoTypes);
        }
        throw new NuxeoException("Redaction not supported");
    }

    @OperationMethod
    public Blob run(Blob blob) throws IOException, OperationException {
        ScanProvider scanner = this.service.getProvider(this.service.getDefaultProvider());
        if (scanner.supportsRedaction()) {
            RedactionProvider redact = (RedactionProvider)((Object)scanner);
            return redact.redactBlob(blob, (List<String>)this.infoTypes);
        }
        throw new NuxeoException("Redaction not supported");
    }
}

