/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.dlp.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InspectFindingName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/findings/{finding}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String finding;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFinding() {
        return this.finding;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private InspectFindingName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.finding = (String)Preconditions.checkNotNull((Object)builder.getFinding());
    }

    public static InspectFindingName of(String project, String location, String finding) {
        return InspectFindingName.newBuilder().setProject(project).setLocation(location).setFinding(finding).build();
    }

    public static String format(String project, String location, String finding) {
        return InspectFindingName.newBuilder().setProject(project).setLocation(location).setFinding(finding).build().toString();
    }

    public static InspectFindingName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "InspectFindingName.parse: formattedString not in valid format");
        return InspectFindingName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("finding"));
    }

    public static List<InspectFindingName> parseList(List<String> formattedStrings) {
        ArrayList<InspectFindingName> list = new ArrayList<InspectFindingName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(InspectFindingName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<InspectFindingName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (InspectFindingName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            InspectFindingName inspectFindingName = this;
            synchronized (inspectFindingName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"finding", (Object)this.finding);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "finding", this.finding});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InspectFindingName) {
            InspectFindingName that = (InspectFindingName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.finding.equals(that.finding);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.finding.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String finding;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFinding() {
            return this.finding;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setFinding(String finding) {
            this.finding = finding;
            return this;
        }

        private Builder() {
        }

        private Builder(InspectFindingName inspectFindingName) {
            this.project = inspectFindingName.project;
            this.location = inspectFindingName.location;
            this.finding = inspectFindingName.finding;
        }

        public InspectFindingName build() {
            return new InspectFindingName(this);
        }
    }
}

