/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.dlp.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.privacy.dlp.v2.StoredInfoTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OrganizationStoredInfoTypeName
extends StoredInfoTypeName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/storedInfoTypes/{stored_info_type}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String storedInfoType;

    @Override
    public String getOrganization() {
        return this.organization;
    }

    @Override
    public String getStoredInfoType() {
        return this.storedInfoType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    private OrganizationStoredInfoTypeName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.storedInfoType = (String)Preconditions.checkNotNull((Object)builder.getStoredInfoType());
    }

    public static OrganizationStoredInfoTypeName of(String organization, String storedInfoType) {
        return OrganizationStoredInfoTypeName.newBuilder().setOrganization(organization).setStoredInfoType(storedInfoType).build();
    }

    public static String format(String organization, String storedInfoType) {
        return OrganizationStoredInfoTypeName.newBuilder().setOrganization(organization).setStoredInfoType(storedInfoType).build().toString();
    }

    public static OrganizationStoredInfoTypeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "OrganizationStoredInfoTypeName.parse: formattedString not in valid format");
        return OrganizationStoredInfoTypeName.of((String)matchMap.get("organization"), (String)matchMap.get("stored_info_type"));
    }

    public static List<OrganizationStoredInfoTypeName> parseList(List<String> formattedStrings) {
        ArrayList<OrganizationStoredInfoTypeName> list = new ArrayList<OrganizationStoredInfoTypeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(OrganizationStoredInfoTypeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<OrganizationStoredInfoTypeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (OrganizationStoredInfoTypeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            OrganizationStoredInfoTypeName organizationStoredInfoTypeName = this;
            synchronized (organizationStoredInfoTypeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    fieldMapBuilder.put((Object)"storedInfoType", (Object)this.storedInfoType);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    @Override
    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"organization", this.organization, "stored_info_type", this.storedInfoType});
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof OrganizationStoredInfoTypeName) {
            OrganizationStoredInfoTypeName that = (OrganizationStoredInfoTypeName)o;
            return this.organization.equals(that.organization) && this.storedInfoType.equals(that.storedInfoType);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.organization.hashCode();
        h *= 1000003;
        return h ^= this.storedInfoType.hashCode();
    }

    public static class Builder
    extends StoredInfoTypeName.Builder {
        private String organization;
        private String storedInfoType;

        @Override
        public String getOrganization() {
            return this.organization;
        }

        @Override
        public String getStoredInfoType() {
            return this.storedInfoType;
        }

        @Override
        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        @Override
        public Builder setStoredInfoType(String storedInfoType) {
            this.storedInfoType = storedInfoType;
            return this;
        }

        private Builder() {
        }

        private Builder(OrganizationStoredInfoTypeName organizationStoredInfoTypeName) {
            this.organization = organizationStoredInfoTypeName.organization;
            this.storedInfoType = organizationStoredInfoTypeName.storedInfoType;
        }

        @Override
        public OrganizationStoredInfoTypeName build() {
            return new OrganizationStoredInfoTypeName(this);
        }
    }
}

