/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.metrics.datadog.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatadogSeries<T extends Number> {
    private String name;
    private T count;
    private Long epoch;
    private String host;
    private List<String> tags;
    private final Pattern tagPattern = Pattern.compile("([\\w\\.]+)\\[([\\w\\W]+)\\]");

    protected abstract String getType();

    public DatadogSeries(String name, T count, Long epoch, String host, List<String> additionalTags) {
        Matcher matcher = this.tagPattern.matcher(name);
        this.tags = new ArrayList<String>();
        if (matcher.find() && matcher.groupCount() == 2) {
            this.name = matcher.group(1);
            for (String t : matcher.group(2).split("\\,")) {
                this.tags.add(t);
            }
        } else {
            this.name = name;
        }
        if (additionalTags != null) {
            this.tags.addAll(additionalTags);
        }
        this.count = count;
        this.epoch = epoch;
        this.host = host;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getHost() {
        return this.host;
    }

    public String getMetric() {
        return this.name;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public List<List<Number>> getPoints() {
        ArrayList<Long> point = new ArrayList<Long>();
        point.add(this.epoch);
        point.add((Long)this.count);
        ArrayList<List<Number>> points = new ArrayList<List<Number>>();
        points.add(point);
        return points;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatadogSeries)) {
            return false;
        }
        DatadogSeries that = (DatadogSeries)o;
        if (!this.count.equals(that.count)) {
            return false;
        }
        if (!this.epoch.equals(that.epoch)) {
            return false;
        }
        if (!this.host.equals(that.host)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.tags.equals(that.tags);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.count.hashCode();
        result = 31 * result + this.epoch.hashCode();
        result = 31 * result + this.host.hashCode();
        result = 31 * result + this.tags.hashCode();
        return result;
    }

    public String toString() {
        return "DatadogSeries{name='" + this.name + '\'' + ", count=" + this.count + ", epoch=" + this.epoch + ", host='" + this.host + '\'' + ", tags=" + this.tags + '}';
    }
}

