/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.datadog.reporter;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.coursera.metrics.datadog.DatadogReporter;
import org.coursera.metrics.datadog.DefaultMetricNameFormatter;
import org.coursera.metrics.datadog.MetricNameFormatter;
import org.coursera.metrics.datadog.transport.HttpTransport;
import org.coursera.metrics.datadog.transport.Transport;
import org.nuxeo.datadog.reporter.DatadogReporterConfDescriptor;
import org.nuxeo.datadog.reporter.DatadogReporterService;
import org.nuxeo.runtime.metrics.MetricsService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class DatadogReporterServiceImpl
extends DefaultComponent
implements DatadogReporterService {
    protected final MetricRegistry metrics = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    private DatadogReporter reporter;
    private DatadogReporterConfDescriptor conf;
    private static final Log log = LogFactory.getLog(DatadogReporterService.class);

    public void start(ComponentContext context) {
        if (this.reporter != null) {
            this.startReporter();
        }
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if ("configuration".equals(extensionPoint)) {
            this.setConfiguration((DatadogReporterConfDescriptor)contribution);
        }
    }

    private void setConfiguration(DatadogReporterConfDescriptor conf) {
        if (StringUtils.isBlank((CharSequence)conf.getApiKey())) {
            log.error((Object)"Datadog reporter service is not well configured : apiKey is empty. Your metrics won't be sent.");
        } else {
            this.conf = conf;
            this.buildReporter();
        }
    }

    private void buildReporter() {
        HttpTransport httpTransport = new HttpTransport.Builder().withApiKey(this.conf.getApiKey()).build();
        this.reporter = DatadogReporter.forRegistry((MetricRegistry)this.metrics).withHost(this.conf.getHost()).withTags(this.conf.getTags()).withTransport((Transport)httpTransport).withExpansions(DatadogReporter.Expansion.ALL).withMetricNameFormatter((MetricNameFormatter)new DefaultMetricNameFormatter()).build();
    }

    @Override
    public void startReporter() {
        if (this.reporter != null) {
            log.info((Object)"Starting Datadog reporter");
            this.reporter.start(this.conf.getPollInterval(), TimeUnit.SECONDS);
        }
    }

    @Override
    public void stopReporter() {
        log.info((Object)"Stopping Datadog reporter");
        this.reporter.stop();
    }

    DatadogReporter getReporter() {
        return this.reporter;
    }

    DatadogReporterConfDescriptor getConfig() {
        return this.conf;
    }
}

