/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.metrics.datadog.transport;

import com.timgroup.statsd.NonBlockingStatsDClient;
import com.timgroup.statsd.StatsDClient;
import java.io.IOException;
import org.coursera.metrics.datadog.model.DatadogCounter;
import org.coursera.metrics.datadog.model.DatadogGauge;
import org.coursera.metrics.datadog.transport.Transport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpTransport
implements Transport {
    private static final Logger LOG = LoggerFactory.getLogger(UdpTransport.class);
    private final StatsDClient statsd;

    private UdpTransport(String prefix, String statsdHost, int port, String[] globalTags) {
        this.statsd = new NonBlockingStatsDClient(prefix, statsdHost, port, globalTags);
    }

    public void close() throws IOException {
        this.statsd.stop();
    }

    public Transport.Request prepare() throws IOException {
        return new DogstatsdRequest(this.statsd);
    }

    public static class DogstatsdRequest
    implements Transport.Request {
        private final StatsDClient statsdClient;

        public DogstatsdRequest(StatsDClient statsdClient) {
            this.statsdClient = statsdClient;
        }

        public void addGauge(DatadogGauge gauge) {
            if (gauge.getPoints().size() > 1) {
                LOG.debug("Gauge " + gauge.getMetric() + " has more than one data point, " + "will pick the first point only");
            }
            double value = gauge.getPoints().get(0).get(1).doubleValue();
            String[] tags = gauge.getTags().toArray(new String[gauge.getTags().size()]);
            this.statsdClient.gauge(gauge.getMetric(), value, tags);
        }

        public void addCounter(DatadogCounter counter) {
            if (counter.getPoints().size() > 1) {
                LOG.debug("Counter " + counter.getMetric() + " has more than one data point, " + "will pick the first point only");
            }
            int value = counter.getPoints().get(0).get(1).intValue();
            String[] tags = counter.getTags().toArray(new String[counter.getTags().size()]);
            this.statsdClient.count(counter.getMetric(), value, tags);
        }

        public void send() {
        }
    }

    public static class Builder {
        String prefix = null;
        String statsdHost = "localhost";
        int port = 8125;

        public Builder withPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder withStatsdHost(String statsdHost) {
            this.statsdHost = statsdHost;
            return this;
        }

        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        public UdpTransport build() {
            return new UdpTransport(this.prefix, this.statsdHost, this.port, new String[0]);
        }
    }
}

