/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.diff.pictures;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.diff.pictures.TempFilesHandler;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;

public class DiffPictures {
    public static final String DEFAULT_COMMAND = "diff-pictures-default";
    public static final String DEFAULT_XPATH = "file:content";
    public static final String DEFAULT_FUZZ = "0";
    public static final String DEFAULT_HIGHLIGHT_COLOR = "Red";
    public static final String DEFAULT_LOWLIGHT_COLOR = "None";
    protected static final String TEMP_DIR_PATH = System.getProperty("java.io.tmpdir");
    protected static final String TMPL_PREFIX = "{{";
    protected static final String TMPL_SUFFIX = "}}";
    protected static final String TMPL_CONTEXT_PATH = DiffPictures.buildTemplateKey("CONTEXT_PATH");
    protected static final String TMPL_ACTION = DiffPictures.buildTemplateKey("ACTION");
    protected static final String TMPL_LEFT_DOC_ID = DiffPictures.buildTemplateKey("LEFT_DOC_ID");
    protected static final String TMPL_LEFT_DOC_LABEL = DiffPictures.buildTemplateKey("LEFT_DOC_LABEL");
    protected static final String TMPL_RIGHT_DOC_ID = DiffPictures.buildTemplateKey("RIGHT_DOC_ID");
    protected static final String TMPL_RIGHT_DOC_LABEL = DiffPictures.buildTemplateKey("RIGHT_DOC_LABEL");
    protected static final String TMPL_XPATH = DiffPictures.buildTemplateKey("XPATH");
    protected static final String TMPL_TIME_STAMP = DiffPictures.buildTemplateKey("TIME_STAMP");
    Blob b1;
    Blob b2;
    String leftDocId;
    String rightDocId;
    String commandLine;
    Map<String, Serializable> clParameters;

    protected static String buildTemplateKey(String inName) {
        return TMPL_PREFIX + inName + TMPL_SUFFIX;
    }

    public DiffPictures(Blob inB1, Blob inB2) {
        this(inB1, inB2, null, null);
    }

    public DiffPictures(DocumentModel inLeft, DocumentModel inRight) {
        this(inLeft, inRight, null);
    }

    public DiffPictures(DocumentModel inLeft, DocumentModel inRight, String inXPath) {
        Blob rightB;
        Blob leftB;
        if (StringUtils.isBlank((String)inXPath) || "null".equals(inXPath)) {
            leftB = (Blob)inLeft.getPropertyValue(DEFAULT_XPATH);
            rightB = (Blob)inRight.getPropertyValue(DEFAULT_XPATH);
        } else {
            leftB = (Blob)inLeft.getPropertyValue(inXPath);
            rightB = (Blob)inRight.getPropertyValue(inXPath);
        }
        this.init(leftB, rightB, inLeft.getId(), inRight.getId());
    }

    public DiffPictures(Blob inB1, Blob inB2, String inLeftDocId, String inRightDocId) {
        this.init(inB1, inB2, inLeftDocId, inRightDocId);
    }

    private void init(Blob inB1, Blob inB2, String inLeftDocId, String inRightDocId) {
        this.b1 = inB1;
        this.b2 = inB2;
        this.leftDocId = inLeftDocId;
        this.rightDocId = inRightDocId;
    }

    public Blob compare(String inCommandLine, Map<String, Serializable> inParams) throws CommandNotAvailable, IOException {
        String destFilePath;
        FileBlob result = null;
        boolean mustTrackTempFile = false;
        this.commandLine = StringUtils.isBlank((String)inCommandLine) ? DEFAULT_COMMAND : inCommandLine;
        this.clParameters = inParams == null ? new HashMap() : inParams;
        String finalName = (String)((Object)this.clParameters.get("targetFileName"));
        if (StringUtils.isBlank((String)finalName)) {
            finalName = "comp-" + this.b1.getFilename();
        }
        CmdParameters params = new CmdParameters();
        String sourceFilePath = this.b1.getFile().getAbsolutePath();
        params.addNamedParameter("file1", sourceFilePath);
        sourceFilePath = this.b2.getFile().getAbsolutePath();
        params.addNamedParameter("file2", sourceFilePath);
        this.checkDefaultParametersValues();
        for (Map.Entry<String, Serializable> entry : this.clParameters.entrySet()) {
            params.addNamedParameter(entry.getKey(), (String)((Object)entry.getValue()));
        }
        if (StringUtils.isNotBlank((String)this.leftDocId)) {
            File tempFolder = TempFilesHandler.prepareOrGetTempFolder(this.leftDocId, this.rightDocId);
            destFilePath = tempFolder.getAbsolutePath() + "/" + System.currentTimeMillis() + "-" + finalName;
        } else {
            mustTrackTempFile = true;
            destFilePath = TEMP_DIR_PATH + "/" + System.currentTimeMillis() + "-" + finalName;
        }
        params.addNamedParameter("targetFilePath", destFilePath);
        CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class);
        ExecResult execResult = cles.execCommand(this.commandLine, params);
        File tempDestFile = new File(destFilePath);
        if (!tempDestFile.exists()) {
            throw new ClientException("Failed to execute the command <" + this.commandLine + ">. Final command [ " + execResult.getCommandLine() + " ] returned with error " + execResult.getReturnCode(), (Throwable)execResult.getError());
        }
        if (mustTrackTempFile) {
            Framework.trackFile((File)tempDestFile, (Object)this);
        }
        if ((result = new FileBlob(tempDestFile)) != null) {
            result.setFilename(finalName);
        }
        return result;
    }

    protected void checkDefaultParametersValues() {
        if (this.isDefaultValue((String)((Object)this.clParameters.get("fuzz")))) {
            this.clParameters.put("fuzz", (Serializable)((Object)DEFAULT_FUZZ));
        }
        if (this.isDefaultValue((String)((Object)this.clParameters.get("highlightColor")))) {
            this.clParameters.put("highlightColor", (Serializable)((Object)DEFAULT_HIGHLIGHT_COLOR));
        }
        if (this.isDefaultValue((String)((Object)this.clParameters.get("lowlightColor")))) {
            this.clParameters.put("lowlightColor", (Serializable)((Object)DEFAULT_LOWLIGHT_COLOR));
        }
    }

    protected boolean isDefaultValue(String inValue) {
        return StringUtils.isBlank((String)inValue) || inValue.toLowerCase().equals("default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String buildDiffHtml(DocumentModel leftDoc, DocumentModel rightDoc, String xpath) throws IOException, URISyntaxException {
        String rightLabel;
        String html = "";
        try (InputStream in = null;){
            String line;
            in = DiffPictures.class.getResourceAsStream("/files/nuxeo-diff-pictures-template.html");
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                html = html + line + "\n";
            }
        }
        String leftDocId = leftDoc.getId();
        String rightDocId = rightDoc.getId();
        String leftLabel = leftDoc.getTitle();
        if (leftLabel.equals(rightLabel = rightDoc.getTitle())) {
            if (leftDoc.isVersion()) {
                leftLabel = "Version " + leftDoc.getVersionLabel();
            }
            if (rightDoc.isVersion()) {
                rightLabel = "Version " + rightDoc.getVersionLabel();
            }
        }
        html = html.replace(TMPL_CONTEXT_PATH, VirtualHostHelper.getContextPathProperty());
        html = html.replace(TMPL_ACTION, "diff");
        html = html.replace(TMPL_LEFT_DOC_ID, leftDocId);
        html = html.replace(TMPL_LEFT_DOC_LABEL, leftLabel);
        html = html.replace(TMPL_RIGHT_DOC_ID, rightDocId);
        html = html.replace(TMPL_RIGHT_DOC_LABEL, rightLabel);
        if (StringUtils.isBlank((String)xpath) || xpath.toLowerCase().equals("default")) {
            xpath = DEFAULT_XPATH;
        }
        html = html.replace(TMPL_XPATH, xpath);
        Calendar cal = (Calendar)rightDoc.getPropertyValue("dc:modified");
        String lastModification = cal == null ? "1234567" : "" + cal.getTimeInMillis();
        html = html.replace(TMPL_TIME_STAMP, lastModification);
        return html;
    }
}

