/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.diff.service.impl;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.custommonkey.xmlunit.DetailedDiff;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.ElementNameAndAttributeQualifier;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.NodeDetail;
import org.custommonkey.xmlunit.XMLUnit;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.DocumentXMLExporter;
import org.nuxeo.ecm.diff.model.DocumentDiff;
import org.nuxeo.ecm.diff.model.impl.DocumentDiffImpl;
import org.nuxeo.ecm.diff.service.DocumentDiffService;
import org.nuxeo.ecm.diff.service.impl.FieldDiffHelper;
import org.nuxeo.ecm.diff.service.impl.IgnoreStructuralDifferenceListener;
import org.nuxeo.runtime.api.Framework;
import org.xml.sax.InputSource;

public class DocumentDiffServiceImpl
implements DocumentDiffService {
    private static final long serialVersionUID = 9023621903602108068L;
    private static final Log LOGGER = LogFactory.getLog(DocumentDiffServiceImpl.class);

    @Override
    public DocumentDiff diff(CoreSession session, DocumentModel leftDoc, DocumentModel rightDoc) throws ClientException {
        InputSource leftDocXMLInputSource = new InputSource();
        InputSource rightDocXMLInputSource = new InputSource();
        this.exportXML(session, leftDoc, rightDoc, leftDocXMLInputSource, rightDocXMLInputSource);
        DetailedDiff detailedDiff = this.diffXML(leftDocXMLInputSource, rightDocXMLInputSource);
        DocumentDiff docDiff = this.computeDocDiff(detailedDiff);
        return docDiff;
    }

    @Override
    public DocumentDiff diff(String leftXML, String rightXML) throws ClientException {
        DetailedDiff detailedDiff = this.diffXML(leftXML, rightXML);
        DocumentDiff docDiff = this.computeDocDiff(detailedDiff);
        return docDiff;
    }

    @Override
    public void configureXMLUnit() {
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreDiffBetweenTextAndCDATA((boolean)true);
        XMLUnit.setCompareUnmatched((boolean)false);
    }

    @Override
    public void configureDiff(Diff diff) {
        diff.overrideDifferenceListener((DifferenceListener)new IgnoreStructuralDifferenceListener());
        diff.overrideElementQualifier((ElementQualifier)new ElementNameAndAttributeQualifier());
    }

    protected final void exportXML(CoreSession session, DocumentModel leftDoc, DocumentModel rightDoc, InputSource leftDocXMLInputSource, InputSource rightDocXMLInputSource) throws ClientException {
        DocumentXMLExporter docXMLExporter = this.getDocumentXMLExporter();
        leftDocXMLInputSource.setByteStream(docXMLExporter.exportXML(leftDoc, session));
        rightDocXMLInputSource.setByteStream(docXMLExporter.exportXML(rightDoc, session));
    }

    protected final DocumentXMLExporter getDocumentXMLExporter() throws ClientException {
        DocumentXMLExporter docXMLExporter;
        try {
            docXMLExporter = (DocumentXMLExporter)Framework.getService(DocumentXMLExporter.class);
        }
        catch (Exception e) {
            throw ClientException.wrap((Throwable)e);
        }
        if (docXMLExporter == null) {
            throw new ClientException("DocumentXMLExporter service is null.");
        }
        return docXMLExporter;
    }

    protected final DetailedDiff diffXML(InputSource leftDocXMLInputSource, InputSource rightDocXMLInputSource) throws ClientException {
        DetailedDiff detailedDiff;
        try {
            this.configureXMLUnit();
            Diff diff = new Diff(leftDocXMLInputSource, rightDocXMLInputSource);
            this.configureDiff(diff);
            detailedDiff = new DetailedDiff(diff);
        }
        catch (Exception e) {
            throw new ClientException("Error while trying to make a detailed diff between two documents.", (Throwable)e);
        }
        return detailedDiff;
    }

    protected final DetailedDiff diffXML(String leftXML, String rightXML) throws ClientException {
        DetailedDiff detailedDiff;
        try {
            this.configureXMLUnit();
            Diff diff = new Diff(leftXML, rightXML);
            this.configureDiff(diff);
            detailedDiff = new DetailedDiff(diff);
        }
        catch (Exception e) {
            throw new ClientException("Error while trying to make a detailed diff between two XML strings.", (Throwable)e);
        }
        return detailedDiff;
    }

    protected final DocumentDiff computeDocDiff(DetailedDiff detailedDiff) throws ClientException {
        DocumentDiffImpl docDiff = new DocumentDiffImpl();
        List differences = detailedDiff.getAllDifferences();
        LOGGER.debug((Object)String.format("Found %d differences.", differences.size()));
        int fieldDifferenceCount = 0;
        for (Difference difference : differences) {
            boolean fieldDiffFound;
            NodeDetail controlNodeDetail = difference.getControlNodeDetail();
            NodeDetail testNodeDetail = difference.getTestNodeDetail();
            if (controlNodeDetail == null || testNodeDetail == null || !(fieldDiffFound = FieldDiffHelper.computeFieldDiff(docDiff, controlNodeDetail, testNodeDetail, fieldDifferenceCount, difference))) continue;
            ++fieldDifferenceCount;
        }
        LOGGER.debug((Object)String.format("Found %d field differences.", fieldDifferenceCount));
        return docDiff;
    }
}

