/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.diff.pictures;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.nuxeo.diff.pictures.DiffPictures;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.diff.content.ContentDiffException;
import org.nuxeo.ecm.diff.content.adapter.MimeTypeContentDiffer;

public class ImageMagickContentDiffer
implements MimeTypeContentDiffer {
    public List<Blob> getContentDiff(DocumentModel leftDoc, DocumentModel rightDoc, String xpath, Locale locale) throws ContentDiffException {
        try {
            ArrayList<Blob> blobResults = new ArrayList<Blob>();
            StringWriter sw = new StringWriter();
            String html = DiffPictures.buildDiffHtml(leftDoc, rightDoc, xpath);
            sw.write(html);
            String stringBlob = sw.toString();
            Blob mainBlob = Blobs.createBlob((String)stringBlob);
            sw.close();
            mainBlob.setFilename("contentDiff.html");
            mainBlob.setMimeType("text/html");
            blobResults.add(mainBlob);
            return blobResults;
        }
        catch (Exception e) {
            throw new ContentDiffException((Throwable)e);
        }
    }

    public List<Blob> getContentDiff(Blob leftBlob, Blob rightBlob, Locale locale) throws ContentDiffException {
        throw new UnsupportedOperationException("ImageMagickContentDiffer can handle only DocumentModel");
    }
}

