/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.diff.pictures;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.diff.pictures.DiffPictures;
import org.nuxeo.diff.pictures.DiffPicturesUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.BlobCollector;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;

@Operation(id="Pictures.DiffWithBlobs", category="Conversion", label="Pictures: Diff with Blobs", description="Compare input blob with blob referenced in the context variable blob2VarName, using the commandLine and its parameters (default values apply). Return the result of the diff as a picture")
public class DiffPicturesWithBlobsOp {
    public static final String ID = "Pictures.DiffWithBlobs";
    @Context
    protected CoreSession session;
    @Context
    protected OperationContext ctx;
    @Param(name="blob2VarName", required=true)
    protected String blob2VarName;
    @Param(name="commandLine", required=false, values={"diff-pictures-default"})
    protected String commandLine = "diff-pictures-default";
    @Param(name="parameters", required=false)
    protected Properties parameters;
    @Param(name="targetFileName", required=false)
    protected String targetFileName;
    @Param(name="targetFileNameSuffix", required=false)
    protected String targetFileNameSuffix = "";

    @OperationMethod(collector=BlobCollector.class)
    public Blob run(Blob inBlob) throws OperationException, CommandNotAvailable, IOException {
        Blob blob2 = (Blob)this.ctx.get((Object)this.blob2VarName);
        if (blob2 == null) {
            throw new OperationException("The blob to append from variable context: '" + this.blob2VarName + "' is null.");
        }
        HashMap<String, Serializable> serializableParameters = new HashMap<String, Serializable>();
        if (this.parameters != null && this.parameters.size() > 0) {
            Set parameterNames = this.parameters.keySet();
            for (String parameterName : parameterNames) {
                serializableParameters.put(parameterName, (Serializable)this.parameters.get((Object)parameterName));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.targetFileName) || StringUtils.isNotBlank((CharSequence)this.targetFileNameSuffix)) {
            this.targetFileName = DiffPicturesUtils.updateTargetFileName(inBlob, this.targetFileName, this.targetFileNameSuffix);
            serializableParameters.put("targetFileName", (Serializable)((Object)this.targetFileName));
        }
        DiffPictures dp = new DiffPictures(inBlob, blob2);
        return dp.compare(this.commandLine, serializableParameters);
    }
}

