/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.diff.pictures;

import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.runtime.api.Framework;

public class DiffPicturesUtils {
    public static String updateTargetFileName(Blob inBlob, String inTargetFileName, String inTargetFileSuffix) {
        String updatedName = inTargetFileName == null || inTargetFileName.isEmpty() ? inBlob.getFilename() : inTargetFileName;
        if (inTargetFileSuffix != null && !inTargetFileSuffix.isEmpty()) {
            updatedName = DiffPicturesUtils.addSuffixToFileName(updatedName, inTargetFileSuffix);
        }
        return updatedName;
    }

    public static String addSuffixToFileName(String inFileName, String inSuffix) {
        if (inFileName == null || inFileName.isEmpty() || inSuffix == null || inSuffix.isEmpty()) {
            return inFileName;
        }
        int dotIndex = inFileName.lastIndexOf(46);
        if (dotIndex < 0) {
            return inFileName + inSuffix;
        }
        return inFileName.substring(0, dotIndex) + inSuffix + inFileName.substring(dotIndex);
    }

    public static boolean sameFormatAndDimensions(Blob inB1, Blob inB2) {
        String mt2;
        boolean result = true;
        String mt1 = inB1.getMimeType().toLowerCase();
        if (!StringUtils.equals((CharSequence)mt1, (CharSequence)(mt2 = inB2.getMimeType().toLowerCase()))) {
            result = false;
        } else {
            ImagingService imagingService = (ImagingService)Framework.getService(ImagingService.class);
            ImageInfo info1 = imagingService.getImageInfo(inB1);
            ImageInfo info2 = imagingService.getImageInfo(inB2);
            if (info1.getWidth() != info2.getWidth() || info1.getHeight() != info2.getHeight()) {
                result = false;
            }
        }
        return result;
    }

    public static Blob getDocumentBlob(DocumentModel inDoc, String inXPath) {
        Blob b = StringUtils.isBlank((CharSequence)inXPath) || "null".equals(inXPath) || "default".equals(inXPath) ? (Blob)inDoc.getPropertyValue("file:content") : (Blob)inDoc.getPropertyValue(inXPath);
        return b;
    }
}

