/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound.transactionlog;

import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.geronimo.transaction.manager.NamedXAResource;

public class LogXAResource
implements NamedXAResource {
    final String name;
    final LocalTransaction localTransaction;
    private Xid xid;

    public LogXAResource(LocalTransaction localTransaction, String name) {
        this.localTransaction = localTransaction;
        this.name = name;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
    }

    public void end(Xid xid, int flags) throws XAException {
    }

    public void forget(Xid xid) throws XAException {
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean isSameRM(XAResource xaResource) throws XAException {
        return this == xaResource;
    }

    public int prepare(Xid xid) throws XAException {
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        return new Xid[0];
    }

    public void rollback(Xid xid) throws XAException {
        if (this.xid == null || !this.xid.equals(xid)) {
            throw new XAException("Invalid Xid");
        }
        try {
            this.localTransaction.rollback();
        }
        catch (ResourceException e) {
            throw (XAException)new XAException().initCause(e);
        }
        finally {
            this.xid = null;
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    public void start(Xid xid, int flag) throws XAException {
        if (flag == 0) {
            if (this.xid != null) {
                throw new XAException("already enlisted");
            }
            this.xid = xid;
            try {
                this.localTransaction.begin();
            }
            catch (ResourceException e) {
                throw (XAException)new XAException("could not start local tx").initCause(e);
            }
        } else if (flag == 0x8000000) {
            if (xid != this.xid) {
                throw new XAException("attempting to resume in different transaction");
            }
        } else {
            throw new XAException("unknown state");
        }
    }

    public String getName() {
        return this.name;
    }
}

