/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSFunction;
import org.richfaces.component.AbstractCollapsibleSubTable;
import org.richfaces.component.AbstractColumn;
import org.richfaces.component.AbstractDataTable;
import org.richfaces.component.Row;
import org.richfaces.component.UIDataAdaptor;
import org.richfaces.component.UIDataTableBase;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.renderkit.AbstractTableRenderer;
import org.richfaces.renderkit.AjaxOptions;
import org.richfaces.renderkit.EncodeStrategy;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.RowHolder;
import org.richfaces.renderkit.RowHolderBase;
import org.richfaces.renderkit.util.AjaxRendererUtils;

@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(library="org.richfaces", name="jquery.js"), @ResourceDependency(library="org.richfaces", name="richfaces.js"), @ResourceDependency(library="org.richfaces", name="richfaces-base-component.js"), @ResourceDependency(library="org.richfaces", name="datatable.js"), @ResourceDependency(library="org.richfaces", name="datatable.ecss")})
public class DataTableRenderer
extends AbstractTableRenderer {
    private static final String BEHAVIOR_EVENT_NAME = "javax.faces.behavior.event";
    private static final String ROW = "row";

    @Override
    protected void doDecode(FacesContext context, final UIComponent component) {
        super.doDecode(context, component);
        if (null == context || null == component) {
            throw new NullPointerException();
        }
        if (component instanceof ClientBehaviorHolder) {
            final Map behaviors = ((ClientBehaviorHolder)component).getClientBehaviors();
            if (behaviors == null || behaviors.isEmpty()) {
                return;
            }
            Map parametersMap = context.getExternalContext().getRequestParameterMap();
            final String behaviorEvent = (String)parametersMap.get(BEHAVIOR_EVENT_NAME);
            if (behaviorEvent == null || !behaviorEvent.startsWith(ROW)) {
                return;
            }
            String behaviorSourceId = RenderKitUtils.getBehaviorSourceId((FacesContext)context);
            ((UIDataAdaptor)component).invokeOnRow(context, behaviorSourceId, new ContextCallback(){

                public void invokeContextCallback(FacesContext context, UIComponent target) {
                    List behaviorsForEvent;
                    if (target.equals(component) && (behaviorsForEvent = (List)behaviors.get(behaviorEvent)) != null && !behaviorsForEvent.isEmpty()) {
                        for (ClientBehavior behavior : behaviorsForEvent) {
                            behavior.decode(context, component);
                        }
                    }
                }
            });
        }
    }

    @Override
    public void encodeTableStructure(ResponseWriter writer, FacesContext context, UIDataTableBase dataTable) throws IOException {
        if (dataTable instanceof AbstractDataTable) {
            this.encodeStyle(writer, context, (UIComponent)dataTable, null);
            this.encodeCaption(writer, context, (AbstractDataTable)dataTable);
            writer.startElement("colgroup", (UIComponent)dataTable);
            int columns = this.getColumnsCount(dataTable.columns());
            writer.writeAttribute("span", (Object)String.valueOf(columns), null);
            String columnsWidth = (String)dataTable.getAttributes().get("columnsWidth");
            if (columnsWidth != null) {
                String[] widths = columnsWidth.split(",");
                for (int i = 0; i < widths.length; ++i) {
                    writer.startElement("col", (UIComponent)dataTable);
                    writer.writeAttribute("width", (Object)widths[i], null);
                    writer.endElement("col");
                }
            }
            writer.endElement("colgroup");
        }
    }

    @Override
    public void encodeBeforeRows(ResponseWriter writer, FacesContext facesContext, UIDataTableBase dataTableBase, boolean encodeParentTBody, boolean partialUpdate) throws IOException {
        if (encodeParentTBody) {
            if (partialUpdate) {
                this.partialStart(facesContext, dataTableBase.getContainerClientId(facesContext) + ":tb");
            }
            this.encodeTableBodyStart(writer, facesContext, dataTableBase);
        }
    }

    @Override
    public void encodeAfterRows(ResponseWriter writer, FacesContext facesContext, UIDataTableBase dataTableBase, boolean encodeParentTBody, boolean partialUpdate) throws IOException {
        if (encodeParentTBody) {
            this.encodeTableBodyEnd(writer);
            if (partialUpdate) {
                this.partialEnd(facesContext);
            }
        }
    }

    @Override
    public void encodeRow(ResponseWriter writer, FacesContext facesContext, RowHolderBase holder) throws IOException {
        boolean parentTbodyStart;
        RowHolder rowHolder = (RowHolder)holder;
        Row row = rowHolder.getRow();
        AbstractDataTable dataTable = (AbstractDataTable)row;
        this.putRowStylesIntoContext(facesContext, rowHolder);
        boolean partialUpdate = rowHolder.isUpdatePartial();
        boolean tbodyStart = parentTbodyStart = rowHolder.isEncodeParentTBody();
        rowHolder.setRowStart(true);
        Iterator<UIComponent> components = row.columns();
        int columnNumber = 0;
        boolean rowBegun = false;
        while (components.hasNext()) {
            UIComponent child = components.next();
            if (child.isRendered()) {
                rowBegun = true;
                if (child instanceof Row) {
                    boolean isSubtable = child instanceof AbstractCollapsibleSubTable;
                    if (rowHolder.getProcessCell() != 0) {
                        this.encodeRowEnd(writer);
                        if (isSubtable) {
                            this.encodeTableBodyEnd(writer);
                            tbodyStart = false;
                            if (partialUpdate) {
                                this.partialEnd(facesContext);
                            }
                        }
                    }
                    rowHolder.nextCell();
                    if (isSubtable && partialUpdate) {
                        String id = dataTable.getRelativeClientId(facesContext) + ":" + child.getId() + ":c";
                        this.partialStart(facesContext, id);
                    }
                    if (!(isSubtable || parentTbodyStart || tbodyStart)) {
                        this.encodeTableBodyStart(writer, facesContext, dataTable);
                        rowHolder.setRowStart(true);
                        tbodyStart = true;
                    }
                    child.encodeAll(facesContext);
                    if (!isSubtable) {
                        this.encodeRowEnd(writer);
                        if (!components.hasNext() && !parentTbodyStart && tbodyStart) {
                            this.encodeTableBodyEnd(writer);
                            tbodyStart = false;
                        }
                        rowHolder.setRowStart(true);
                        rowHolder.resetProcessCell();
                    }
                    if (!isSubtable || !partialUpdate) continue;
                    this.partialEnd(facesContext);
                    continue;
                }
                if (!(child instanceof UIColumn)) continue;
                if (!parentTbodyStart && !tbodyStart) {
                    if (partialUpdate) {
                        this.partialStart(facesContext, dataTable.getRelativeClientId(facesContext) + ":tb");
                    }
                    this.encodeTableBodyStart(writer, facesContext, dataTable);
                    rowHolder.setRowStart(true);
                    tbodyStart = true;
                }
                child.getAttributes().put("userColumnClass", this.getColumnClass(rowHolder, columnNumber));
                this.encodeColumn(facesContext, writer, (UIColumn)child, rowHolder);
                ++columnNumber;
                if (components.hasNext()) continue;
                this.encodeRowEnd(writer);
                if (parentTbodyStart || !tbodyStart) continue;
                this.encodeTableBodyEnd(writer);
                tbodyStart = false;
                if (!partialUpdate) continue;
                this.partialEnd(facesContext);
                continue;
            }
            if (components.hasNext() || !rowBegun) continue;
            this.encodeRowEnd(writer);
            if (parentTbodyStart || !tbodyStart) continue;
            this.encodeTableBodyEnd(writer);
            tbodyStart = false;
            if (!partialUpdate) continue;
            this.partialEnd(facesContext);
        }
    }

    @Override
    public boolean encodeParentTBody(UIDataTableBase dataTableBase) {
        Iterator<UIComponent> iterator = dataTableBase.columns();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof Row)) continue;
            return false;
        }
        return true;
    }

    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        UIDataTableBase dataTable = (UIDataTableBase)component;
        this.encodeTableStart(writer, context, dataTable);
        this.encodeTableFacets(writer, context, dataTable);
    }

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        this.encodeTableEnd(writer);
    }

    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractDataTable.class;
    }

    public void encodeCaption(ResponseWriter writer, FacesContext context, AbstractDataTable dataTable) throws IOException {
        UIComponent caption = dataTable.getCaption();
        if (caption == null) {
            return;
        }
        if (!caption.isRendered()) {
            return;
        }
        writer.startElement("caption", (UIComponent)dataTable);
        String captionClass = (String)dataTable.getAttributes().get("captionClass");
        String captionSkinClass = this.getCaptionSkinClass();
        captionClass = HtmlUtil.concatClasses((Object[])new Object[]{captionClass, captionSkinClass});
        writer.writeAttribute("class", (Object)captionClass, "captionClass");
        String captionStyle = (String)dataTable.getAttributes().get("captionStyle");
        if (captionStyle != null && captionStyle.trim().length() != 0) {
            writer.writeAttribute("style", (Object)captionStyle, "captionStyle");
        }
        caption.encodeAll(context);
        writer.endElement("caption");
    }

    @Override
    public EncodeStrategy getHeaderEncodeStrategy(UIComponent column, String facetName) {
        return column instanceof AbstractColumn && "header".equals(facetName) ? new RichHeaderEncodeStrategy() : new AbstractTableRenderer.SimpleHeaderEncodeStrategy();
    }

    @Override
    public boolean containsThead() {
        return true;
    }

    @Override
    public void encodeClientScript(ResponseWriter writer, FacesContext facesContext, UIDataTableBase dataTableBase) throws IOException {
        AbstractDataTable dataTable = (AbstractDataTable)dataTableBase;
        writer.startElement("script", (UIComponent)dataTable);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        JSFunction function = new JSFunction("new RichFaces.ui.DataTable", new Object[0]);
        function.addParameter((Object)dataTable.getClientId(facesContext));
        AjaxOptions ajaxOptions = AjaxRendererUtils.buildEventOptions((FacesContext)facesContext, (UIComponent)dataTable);
        HashMap<String, Map> options = new HashMap<String, Map>();
        options.put("ajaxEventOptions", ajaxOptions.getParameters());
        function.addParameter(options);
        writer.writeText((Object)function.toScript(), null);
        writer.endElement("script");
    }

    @Override
    public void encodeHiddenInput(ResponseWriter writer, FacesContext context, UIDataTableBase component) throws IOException {
    }

    @Override
    public String getTableSkinClass() {
        return "rf-dt";
    }

    public String getCaptionSkinClass() {
        return "rf-dt-cap";
    }

    @Override
    public String getRowSkinClass() {
        return "rf-dt-r";
    }

    @Override
    public String getFirstRowSkinClass() {
        return "rf-dt-fst-r";
    }

    @Override
    public String getCellSkinClass() {
        return "rf-dt-c";
    }

    @Override
    public String getHeaderSkinClass() {
        return "rf-dt-hdr";
    }

    @Override
    public String getHeaderFirstSkinClass() {
        return "rf-dt-hdr-fst";
    }

    @Override
    public String getHeaderCellSkinClass() {
        return "rf-dt-hdr-c";
    }

    @Override
    public String getColumnHeaderSkinClass() {
        return "rf-dt-shdr";
    }

    @Override
    public String getColumnHeaderFirstSkinClass() {
        return "rf-dt-shdr-fst";
    }

    @Override
    public String getColumnHeaderCellSkinClass() {
        return "rf-dt-shdr-c";
    }

    @Override
    public String getColumnFooterSkinClass() {
        return "rf-dt-sftr";
    }

    @Override
    public String getColumnFooterFirstSkinClass() {
        return "rf-dt-sftr-fst";
    }

    @Override
    public String getColumnFooterCellSkinClass() {
        return "rf-dt-sftr-c";
    }

    @Override
    public String getFooterSkinClass() {
        return "rf-dt-ftr";
    }

    @Override
    public String getFooterFirstSkinClass() {
        return "rf-dt-ftr-fst";
    }

    @Override
    public String getFooterCellSkinClass() {
        return "rf-dt-ftr-c";
    }

    @Override
    public String getNoDataClass() {
        return "rf-dt-nd";
    }

    @Override
    public String getNoDataCellClass() {
        return "rf-dt-nd-c";
    }

    @Override
    public String getTableBodySkinClass() {
        return "rf-dt-b";
    }

    @Override
    public EncodeStrategy getHiddenContainerStrategy(UIDataTableBase dataTableBase) {
        return new DataTableHiddenEncodeStrategy();
    }

    private class RichHeaderEncodeStrategy
    implements EncodeStrategy {
        private RichHeaderEncodeStrategy() {
        }

        @Override
        public void begin(ResponseWriter writer, FacesContext context, UIComponent component, Object[] params) throws IOException {
            AbstractColumn column = (AbstractColumn)component;
            writer.writeAttribute("id", (Object)column.getClientId(context), null);
        }

        @Override
        public void end(ResponseWriter writer, FacesContext context, UIComponent component, Object[] params) throws IOException {
        }
    }

    private class DataTableHiddenEncodeStrategy
    implements EncodeStrategy {
        private DataTableHiddenEncodeStrategy() {
        }

        @Override
        public void begin(ResponseWriter writer, FacesContext context, UIComponent component, Object[] params) throws IOException {
            AbstractDataTable dataTable = (AbstractDataTable)component;
            writer.startElement("tbody", (UIComponent)dataTable);
            writer.writeAttribute("id", (Object)(dataTable.getContainerClientId(context) + ":sc"), null);
            writer.startElement("tr", (UIComponent)dataTable);
            writer.startElement("td", (UIComponent)dataTable);
            writer.writeAttribute("style", (Object)"display: none", null);
        }

        @Override
        public void end(ResponseWriter writer, FacesContext context, UIComponent component, Object[] params) throws IOException {
            writer.endElement("td");
            writer.endElement("tr");
            writer.endElement("tbody");
        }
    }
}

