/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets.plugins;

import com.sun.faces.facelets.tag.ui.InsertHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.CompositeFaceletHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributes;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.ValidatorHandler;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.validation.DocumentValidationService;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;
import org.nuxeo.ecm.platform.forms.layout.api.exceptions.WidgetException;
import org.nuxeo.ecm.platform.forms.layout.facelets.FaceletHandlerHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.RenderVariables;
import org.nuxeo.ecm.platform.forms.layout.facelets.WidgetTypeHandler;
import org.nuxeo.ecm.platform.forms.layout.facelets.dev.WidgetTypeDevTagHandler;
import org.nuxeo.ecm.platform.ui.web.tag.handler.LeafFaceletHandler;
import org.nuxeo.ecm.platform.ui.web.tag.handler.TagConfigFactory;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractWidgetTypeHandler
extends WidgetTypeHandler {
    public static final String DEV_TEMPLATE_PROPERTY_NAME = "dev_template";
    public static final String DISABLE_DEV_PROPERTY_NAME = "disable_dev";
    protected final TagConfig tagConfig;
    protected Map<String, String> properties;
    protected Widget widget;
    protected final TagAttribute widgetAttr;

    public AbstractWidgetTypeHandler(TagConfig config) {
        super(config);
        this.tagConfig = config;
        this.widgetAttr = this.getAttribute("widget");
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        if (this.widget == null) {
            Widget wi = (Widget)this.widgetAttr.getObject(ctx, Widget.class);
            if (wi != null) {
                this.apply(ctx, parent, wi);
            }
        } else {
            this.apply(ctx, parent, this.widget);
        }
    }

    @Override
    public abstract void apply(FaceletContext var1, UIComponent var2, Widget var3) throws WidgetException, IOException;

    @Override
    public FaceletHandler getDevFaceletHandler(TagConfig tagConfig, Widget widget) throws WidgetException {
        if (Boolean.parseBoolean(this.getProperty(DISABLE_DEV_PROPERTY_NAME)) || Boolean.parseBoolean((String)((Object)widget.getProperty(DISABLE_DEV_PROPERTY_NAME)))) {
            return null;
        }
        String template = (String)((Object)widget.getProperty(DEV_TEMPLATE_PROPERTY_NAME));
        if (StringUtils.isBlank((String)template)) {
            template = this.getProperty(DEV_TEMPLATE_PROPERTY_NAME);
        }
        FaceletHandlerHelper helper = new FaceletHandlerHelper(tagConfig);
        TagAttribute widgetAttr = helper.createAttribute("widget", "#{" + RenderVariables.widgetVariables.widget.name() + "}");
        TagAttributes devWidgetAttributes = StringUtils.isBlank((String)template) ? FaceletHandlerHelper.getTagAttributes(widgetAttr) : FaceletHandlerHelper.getTagAttributes(widgetAttr, helper.createAttribute("template", template));
        TagConfig devWidgetConfig = TagConfigFactory.createTagConfig((TagConfig)tagConfig, (String)widget.getTagConfigId(), (TagAttributes)devWidgetAttributes, (FaceletHandler)new LeafFaceletHandler());
        return new WidgetTypeDevTagHandler(devWidgetConfig);
    }

    @Override
    public String getProperty(String name) {
        if (this.properties != null) {
            return this.properties.get(name);
        }
        return null;
    }

    public String getRequiredProperty(String name) throws WidgetException {
        String value = this.getProperty(name);
        if (value == null) {
            throw new WidgetException("Required property '" + name + "' is missing on widget type configuration");
        }
        return value;
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public void setWidget(Widget widget) {
        this.widget = widget;
    }

    protected FaceletHandler getNextHandler(FaceletContext ctx, TagConfig tagConfig, Widget widget, FaceletHandler[] subHandlers, FaceletHandlerHelper helper) {
        boolean isEdit = "edit".equals(widget.getMode());
        return this.getNextHandler(ctx, tagConfig, widget, subHandlers, helper, isEdit, isEdit);
    }

    protected FaceletHandler getNextHandler(FaceletContext ctx, TagConfig tagConfig, Widget widget, FaceletHandler[] subHandlers, FaceletHandlerHelper helper, boolean addInputSlot, boolean addDocumentConstraintValidator) {
        FaceletHandler v;
        FaceletHandler slot;
        ArrayList<FaceletHandler> handlers = new ArrayList<FaceletHandler>();
        if (this.nextHandler != null && !(this.nextHandler instanceof LeafFaceletHandler)) {
            handlers.add(this.nextHandler);
        }
        if (subHandlers != null && subHandlers.length > 0) {
            for (FaceletHandler fh : subHandlers) {
                if (fh == null || fh instanceof LeafFaceletHandler) continue;
                handlers.add(fh);
            }
        }
        if (addInputSlot && (slot = this.getInputSlotHandler(ctx, tagConfig, widget, subHandlers, helper)) != null) {
            handlers.add(slot);
        }
        DocumentValidationService validationService = (DocumentValidationService)Framework.getService(DocumentValidationService.class);
        if (addDocumentConstraintValidator && validationService.isActivated("jsfValidator", null) && (v = this.getDocumentConstraintValidatorHandler(ctx, tagConfig, widget, subHandlers, helper)) != null) {
            handlers.add(v);
        }
        Object leaf = handlers.size() == 0 ? new LeafFaceletHandler() : new CompositeFaceletHandler(handlers.toArray(new FaceletHandler[0]));
        return leaf;
    }

    protected FaceletHandler getInputSlotHandler(FaceletContext ctx, TagConfig tagConfig, Widget widget, FaceletHandler[] subHandlers, FaceletHandlerHelper helper) {
        TagConfig config = TagConfigFactory.createTagConfig((TagConfig)tagConfig, (String)tagConfig.getTagId(), (TagAttributes)FaceletHandlerHelper.getTagAttributes(helper.createAttribute("name", RenderVariables.widgetTemplatingZones.inside_input_widget.name())), (FaceletHandler)new LeafFaceletHandler());
        return new InsertHandler(config);
    }

    protected FaceletHandler getDocumentConstraintValidatorHandler(FaceletContext ctx, TagConfig tagConfig, Widget widget, FaceletHandler[] subHandlers, FaceletHandlerHelper helper) {
        ValidatorHandler validator = helper.getValidateHandler(tagConfig.getTagId(), FaceletHandlerHelper.getTagAttributes(new TagAttribute[0]), (FaceletHandler)new LeafFaceletHandler(), "DocumentConstraintValidator");
        return validator;
    }
}

