/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.local;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.restlet.Directory;
import org.restlet.Uniform;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Method;
import org.restlet.data.Preference;
import org.restlet.data.Reference;
import org.restlet.data.ReferenceList;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Representation;
import org.restlet.resource.Resource;
import org.restlet.resource.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryResource
extends Resource {
    private Directory directory;
    private String relativePart;
    private String targetUri;
    private boolean targetDirectory;
    private boolean targetFile;
    private boolean targetIndex;
    private String directoryUri;
    private String baseName;
    private Set<String> baseExtensions;
    private Reference uniqueReference;
    private ReferenceList directoryContent;
    private Representation fileContent;
    private boolean directoryRedirection;

    public DirectoryResource(Directory directory, Request request, Response response) throws IOException {
        super(directory.getContext(), request, response);
        int firstDotIndex;
        Response contextResponse;
        this.directory = directory;
        this.relativePart = request.getResourceRef().getRemainingPart();
        if (this.relativePart.startsWith("/")) {
            this.relativePart = this.relativePart.substring(1);
        }
        this.targetUri = new Reference(directory.getRootRef().toString() + this.relativePart).normalize().toString(false, false);
        if (!this.targetUri.startsWith(directory.getRootRef().toString())) {
            this.targetUri = directory.getRootRef().toString();
        }
        if ((contextResponse = this.getDispatcher().get(this.targetUri)).getEntity() != null) {
            if (MediaType.TEXT_URI_LIST.equals((Object)contextResponse.getEntity().getMediaType())) {
                this.targetDirectory = true;
                this.targetFile = false;
                this.directoryContent = new ReferenceList(contextResponse.getEntity());
                if (!request.getResourceRef().getIdentifier().endsWith("/")) {
                    this.directoryRedirection = true;
                }
                if (!this.targetUri.endsWith("/")) {
                    this.targetUri = this.targetUri + "/";
                    this.relativePart = this.relativePart + "/";
                }
                if (this.getDirectory().getIndexName() != null && this.getDirectory().getIndexName().length() > 0) {
                    this.directoryUri = this.targetUri;
                    this.baseName = this.getDirectory().getIndexName();
                    this.targetUri = this.directoryUri + this.baseName;
                    this.targetIndex = true;
                } else {
                    this.directoryUri = this.targetUri;
                    this.baseName = null;
                }
            } else {
                this.targetDirectory = false;
                this.targetFile = true;
                this.fileContent = contextResponse.getEntity();
            }
        } else {
            this.targetDirectory = false;
            this.targetFile = false;
            if (this.targetUri.endsWith("/")) {
                if (this.getDirectory().getIndexName() != null && this.getDirectory().getIndexName().length() > 0) {
                    this.directoryUri = this.targetUri;
                    this.baseName = this.getDirectory().getIndexName();
                    this.targetUri = this.directoryUri + this.baseName;
                    contextResponse = this.getDispatcher().get(this.targetUri);
                    if (contextResponse.getEntity() != null) {
                        this.targetDirectory = true;
                        this.directoryContent = new ReferenceList();
                        this.directoryContent.add((Object)new Reference(this.targetUri));
                        this.targetIndex = true;
                    }
                }
            } else if (this.getDirectory().getIndexName() != null && this.getDirectory().getIndexName().length() > 0 && (contextResponse = this.getDispatcher().get(this.targetUri + "/" + this.getDirectory().getIndexName())).getEntity() != null) {
                this.directoryUri = this.targetUri + "/";
                this.baseName = this.getDirectory().getIndexName();
                this.targetUri = this.directoryUri + this.baseName;
                this.targetDirectory = true;
                this.directoryRedirection = true;
                this.directoryContent = new ReferenceList();
                this.directoryContent.add((Object)new Reference(this.targetUri));
                this.targetIndex = true;
            }
        }
        if (!this.targetDirectory) {
            int lastSlashIndex = this.targetUri.lastIndexOf(47);
            if (lastSlashIndex == -1) {
                this.directoryUri = "";
                this.baseName = this.targetUri;
            } else {
                this.directoryUri = this.targetUri.substring(0, lastSlashIndex + 1);
                this.baseName = this.targetUri.substring(lastSlashIndex + 1);
            }
            contextResponse = this.getDispatcher().get(this.directoryUri);
            if (contextResponse.getEntity() != null && MediaType.TEXT_URI_LIST.equals((Object)contextResponse.getEntity().getMediaType())) {
                this.directoryContent = new ReferenceList(contextResponse.getEntity());
            }
        }
        if (this.baseName != null && (firstDotIndex = this.baseName.indexOf(46)) != -1) {
            this.baseExtensions = DirectoryResource.getExtensions(this.baseName);
            this.baseName = this.baseName.substring(0, firstDotIndex);
        }
        this.getLogger().info("Converted base path: " + this.targetUri);
        this.getLogger().info("Converted base name: " + this.baseName);
    }

    public boolean allowDelete() {
        return this.getDirectory().isModifiable();
    }

    public boolean allowPut() {
        return this.getDirectory().isModifiable();
    }

    public void handleGet() {
        if (this.directoryRedirection) {
            this.getResponse().redirectPermanent(this.getRequest().getResourceRef().getIdentifier() + "/");
        } else {
            super.handleGet();
        }
    }

    public void delete() {
        if (this.directoryRedirection && !this.targetIndex) {
            this.getResponse().setStatus(Status.REDIRECTION_SEE_OTHER);
            this.getResponse().setRedirectRef(this.targetUri);
        } else {
            Status status;
            if (!this.getDirectory().isModifiable()) {
                status = new Status(Status.CLIENT_ERROR_FORBIDDEN, "No modification allowed.");
            } else {
                Request contextRequest = new Request(Method.DELETE, this.targetUri);
                Response contextResponse = new Response(contextRequest);
                if (this.targetDirectory && !this.targetIndex) {
                    contextRequest.setResourceRef(this.targetUri);
                    this.getDispatcher().handle(contextRequest, contextResponse);
                } else {
                    ReferenceList references = this.getVariantsReferences();
                    if (!references.isEmpty()) {
                        if (this.uniqueReference != null) {
                            contextRequest.setResourceRef(this.uniqueReference);
                            this.getDispatcher().handle(contextRequest, contextResponse);
                        } else {
                            contextResponse.setStatus(new Status(Status.CLIENT_ERROR_NOT_ACCEPTABLE, "Unable to process properly the request. Several variants exist but none of them suits precisely. "));
                        }
                    } else {
                        contextResponse.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                    }
                }
                status = contextResponse.getStatus();
            }
            this.getResponse().setStatus(status);
        }
    }

    public void put(Representation variant) {
        Status status;
        if (this.directoryRedirection && !this.targetIndex) {
            this.getResponse().setStatus(Status.REDIRECTION_SEE_OTHER);
            this.getResponse().setRedirectRef(this.targetUri);
        }
        if (!this.getDirectory().isModifiable()) {
            status = new Status(Status.CLIENT_ERROR_FORBIDDEN, "No modification allowed.");
        } else {
            Request contextRequest = new Request(Method.PUT, this.targetUri);
            contextRequest.setEntity(variant);
            Response contextResponse = new Response(contextRequest);
            contextRequest.setResourceRef(this.targetUri);
            this.getDispatcher().handle(contextRequest, contextResponse);
            status = contextResponse.getStatus();
        }
        this.getResponse().setStatus(status);
    }

    public String getBaseName() {
        return this.baseName;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public String getDirectoryUri() {
        return this.directoryUri;
    }

    private Uniform getDispatcher() {
        return this.getDirectory().getContext().getDispatcher();
    }

    public String getTargetUri() {
        return this.targetUri;
    }

    public List<Variant> getVariants() {
        List results = super.getVariants();
        this.getLogger().info("Getting variants for : " + this.getTargetUri());
        if (this.directoryContent != null && this.getRequest().getResourceRef() != null && this.getRequest().getResourceRef().getBaseRef() != null) {
            int lastIndex;
            TreeSet<Representation> resultSet = new TreeSet<Representation>(this.getRepresentationsComparator());
            String baseRef = this.getRequest().getResourceRef().getBaseRef().toString(false, false);
            if (!baseRef.endsWith("/")) {
                baseRef = baseRef + "/";
            }
            if ((lastIndex = this.relativePart.lastIndexOf("/")) != -1) {
                baseRef = baseRef + this.relativePart.substring(0, lastIndex);
            }
            int rootLength = this.getDirectoryUri().length();
            if (this.baseName != null) {
                for (Reference ref : this.getVariantsReferences()) {
                    Response contextResponse = this.getDispatcher().get(ref.toString());
                    if (!contextResponse.getStatus().isSuccess() || contextResponse.getEntity() == null) continue;
                    String filePath = ref.toString(false, false).substring(rootLength);
                    Representation rep = contextResponse.getEntity();
                    rep.setIdentifier(baseRef + filePath);
                    resultSet.add(rep);
                }
            }
            results.addAll(resultSet);
            if (resultSet.isEmpty() && this.targetDirectory && this.getDirectory().isListingAllowed()) {
                ReferenceList userList = new ReferenceList(this.directoryContent.size());
                userList.setIdentifier(baseRef);
                TreeSet<Reference> sortedSet = new TreeSet<Reference>(this.getReferencesComparator());
                sortedSet.addAll((Collection<Reference>)this.directoryContent);
                for (Reference ref : sortedSet) {
                    String filePart = ref.toString(false, false).substring(rootLength);
                    StringBuilder filePath = new StringBuilder();
                    if (!baseRef.endsWith("/") && !filePart.startsWith("/")) {
                        filePath.append('/');
                    }
                    filePath.append(filePart);
                    userList.add(baseRef + filePath);
                }
                List list = this.getDirectory().getIndexVariants(userList);
                for (Variant variant : list) {
                    results.add(this.getDirectory().getIndexRepresentation(variant, userList));
                }
            }
        } else if (this.targetFile && this.fileContent != null) {
            results.add(this.fileContent);
        }
        return results;
    }

    private Comparator<Representation> getRepresentationsComparator() {
        Comparator<Representation> identifiersComparator = new Comparator<Representation>(){

            @Override
            public int compare(Representation rep0, Representation rep1) {
                boolean bRep1Null;
                boolean bRep0Null = rep0.getIdentifier() == null;
                boolean bl = bRep1Null = rep1.getIdentifier() == null;
                if (bRep0Null && bRep1Null) {
                    return 0;
                }
                if (bRep0Null) {
                    return -1;
                }
                if (bRep1Null) {
                    return 1;
                }
                return rep0.getIdentifier().getLastSegment().compareTo(rep1.getIdentifier().getLastSegment());
            }
        };
        return identifiersComparator;
    }

    private Comparator<Reference> getReferencesComparator() {
        Comparator<Reference> identifiersComparator = new Comparator<Reference>(){

            @Override
            public int compare(Reference rep0, Reference rep1) {
                boolean bRep1Null;
                boolean bRep0Null = rep0.getIdentifier() == null;
                boolean bl = bRep1Null = rep1.getIdentifier() == null;
                if (bRep0Null && bRep1Null) {
                    return 0;
                }
                if (bRep0Null) {
                    return -1;
                }
                if (bRep1Null) {
                    return 1;
                }
                return rep0.toString(false, false).compareTo(rep1.toString(false, false));
            }
        };
        return identifiersComparator;
    }

    private ReferenceList getVariantsReferences() {
        this.uniqueReference = null;
        ReferenceList result = new ReferenceList(0);
        try {
            Request contextCall = new Request(Method.GET, this.targetUri);
            contextCall.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_URI_LIST));
            Response contextResponse = this.getDispatcher().handle(contextCall);
            if (contextResponse.getEntity() != null) {
                if (MediaType.TEXT_URI_LIST.equals((Object)contextResponse.getEntity().getMediaType())) {
                    ReferenceList listVariants = new ReferenceList(contextResponse.getEntity());
                    Set<String> extensions = null;
                    for (Reference ref : listVariants) {
                        String fullEntryName;
                        String entryUri = ref.toString();
                        int lastSlashIndex = entryUri.lastIndexOf(47);
                        String baseEntryName = fullEntryName = lastSlashIndex == -1 ? entryUri : entryUri.substring(lastSlashIndex + 1);
                        int firstDotIndex = fullEntryName.indexOf(46);
                        if (firstDotIndex != -1) {
                            baseEntryName = fullEntryName.substring(0, firstDotIndex);
                        }
                        if (!baseEntryName.equals(this.baseName)) continue;
                        boolean validVariant = true;
                        extensions = DirectoryResource.getExtensions(fullEntryName);
                        boolean bl = validVariant = extensions == null && this.baseExtensions == null || this.baseExtensions == null || extensions.containsAll(this.baseExtensions);
                        if (validVariant && this.baseExtensions != null && this.baseExtensions.containsAll(extensions)) {
                            this.uniqueReference = ref;
                        }
                        if (!validVariant) continue;
                        result.add((Object)ref);
                    }
                } else {
                    result.add((Object)contextResponse.getEntity().getIdentifier());
                }
            }
        }
        catch (IOException ioe) {
            this.getLogger().log(Level.WARNING, "Unable to get resource variants", ioe);
        }
        return result;
    }

    public static Set<String> getExtensions(String entryName) {
        TreeSet<String> result = new TreeSet<String>();
        String[] tokens = entryName.split("\\.");
        for (int i = 1; i < tokens.length; ++i) {
            result.add(tokens[i].toLowerCase());
        }
        return result;
    }

    public void setTargetUri(String targetUri) {
        this.targetUri = targetUri;
    }
}

