/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.web.resources.jsf;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.web.resources.api.Resource;
import org.nuxeo.ecm.web.resources.api.ResourceContext;
import org.nuxeo.ecm.web.resources.api.ResourceContextImpl;
import org.nuxeo.ecm.web.resources.api.ResourceType;
import org.nuxeo.ecm.web.resources.api.service.WebResourceManager;
import org.nuxeo.ecm.web.resources.jsf.AbstractResourceRenderer;
import org.nuxeo.runtime.api.Framework;

public class ResourceBundleRenderer
extends AbstractResourceRenderer {
    public static final String RENDERER_TYPE = "org.nuxeo.ecm.web.resources.jsf.ResourceBundle";
    private static final Log log = LogFactory.getLog(ResourceBundleRenderer.class);

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Map attributes = component.getAttributes();
        String name = (String)attributes.get("name");
        String type = (String)attributes.get("type");
        WebResourceManager wrm = (WebResourceManager)Framework.getService(WebResourceManager.class);
        if (StringUtils.isBlank((String)type)) {
            log.error((Object)("Cannot encode bundle with empty type at %s" + component.getClientId()));
            return;
        }
        if (!(ResourceType.css.equals(type) || ResourceType.js.equals(type) || ResourceType.html.equals(type))) {
            log.error((Object)("Unsupported type '" + type + "' to encode page '" + name + "' at " + component.getClientId()));
            return;
        }
        List rs = wrm.getResources((ResourceContext)new ResourceContextImpl(), name, type);
        if (rs != null && !rs.isEmpty()) {
            if (ResourceType.css.equals(type)) {
                this.encodeEnd(context, component, ResourceType.css, "/wro/api/v1/resource/bundle/" + name + ".css");
            } else if (ResourceType.js.equals(type)) {
                this.encodeEnd(context, component, ResourceType.js, "/wro/api/v1/resource/bundle/" + name + ".js");
            } else if (ResourceType.html.equals(type)) {
                for (Resource r : rs) {
                    this.encodeEnd(context, component, ResourceType.html, "/bower_components/" + r.getPath());
                }
            }
        }
        super.encodeEnd(context, component);
    }

    protected void encodeEnd(FacesContext context, UIComponent component, ResourceType type, String base) throws IOException {
        String url = this.resolveNuxeoResourceUrl(context, component, base);
        ResponseWriter writer = context.getResponseWriter();
        if (ResourceType.css.equals((Object)type)) {
            writer.startElement("link", component);
            writer.writeAttribute("type", (Object)"text/css", "type");
            writer.writeAttribute("rel", (Object)"stylesheet", "rel");
            writer.writeURIAttribute("href", (Object)url, "href");
            writer.endElement("link");
        } else if (ResourceType.js.equals((Object)type)) {
            writer.startElement("script", component);
            writer.writeAttribute("type", (Object)"text/javascript", "type");
            writer.writeURIAttribute("src", (Object)url, "src");
            writer.endElement("script");
        } else if (ResourceType.html.equals((Object)type)) {
            writer.startElement("link", component);
            writer.writeAttribute("rel", (Object)"import", "rel");
            writer.writeURIAttribute("href", (Object)url, "href");
            writer.endElement("link");
        }
    }

    @Override
    protected void startElement(ResponseWriter writer, UIComponent component) throws IOException {
    }

    @Override
    protected void endElement(ResponseWriter writer) throws IOException {
    }
}

