/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.diff.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.FieldImpl;
import org.nuxeo.ecm.core.schema.types.QName;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.diff.content.ContentDiffHelper;
import org.nuxeo.ecm.diff.model.DiffBlockDefinition;
import org.nuxeo.ecm.diff.model.DiffComplexFieldDefinition;
import org.nuxeo.ecm.diff.model.DiffDisplayBlock;
import org.nuxeo.ecm.diff.model.DiffFieldDefinition;
import org.nuxeo.ecm.diff.model.DiffFieldItemDefinition;
import org.nuxeo.ecm.diff.model.DifferenceType;
import org.nuxeo.ecm.diff.model.DocumentDiff;
import org.nuxeo.ecm.diff.model.PropertyDiff;
import org.nuxeo.ecm.diff.model.PropertyDiffDisplay;
import org.nuxeo.ecm.diff.model.PropertyType;
import org.nuxeo.ecm.diff.model.SchemaDiff;
import org.nuxeo.ecm.diff.model.impl.ComplexPropertyDiff;
import org.nuxeo.ecm.diff.model.impl.ContentDiffDisplayImpl;
import org.nuxeo.ecm.diff.model.impl.ContentProperty;
import org.nuxeo.ecm.diff.model.impl.ContentPropertyDiff;
import org.nuxeo.ecm.diff.model.impl.DiffBlockDefinitionImpl;
import org.nuxeo.ecm.diff.model.impl.DiffDisplayBlockImpl;
import org.nuxeo.ecm.diff.model.impl.DiffFieldDefinitionImpl;
import org.nuxeo.ecm.diff.model.impl.DiffFieldItemDefinitionImpl;
import org.nuxeo.ecm.diff.model.impl.ListPropertyDiff;
import org.nuxeo.ecm.diff.model.impl.PropertyDiffDisplayImpl;
import org.nuxeo.ecm.diff.model.impl.SimplePropertyDiff;
import org.nuxeo.ecm.diff.service.ComplexPropertyHelper;
import org.nuxeo.ecm.diff.service.DiffDisplayService;
import org.nuxeo.ecm.diff.service.impl.DiffBlockDescriptor;
import org.nuxeo.ecm.diff.service.impl.DiffBlockReferenceDescriptor;
import org.nuxeo.ecm.diff.service.impl.DiffComplexFieldDescriptor;
import org.nuxeo.ecm.diff.service.impl.DiffDisplayDescriptor;
import org.nuxeo.ecm.diff.service.impl.DiffExcludedFieldsDescriptor;
import org.nuxeo.ecm.diff.service.impl.DiffFieldDescriptor;
import org.nuxeo.ecm.diff.service.impl.DiffFieldItemDescriptor;
import org.nuxeo.ecm.platform.forms.layout.api.FieldDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.impl.FieldDefinitionImpl;
import org.nuxeo.ecm.platform.forms.layout.api.impl.LayoutDefinitionImpl;
import org.nuxeo.ecm.platform.forms.layout.api.impl.LayoutRowDefinitionImpl;
import org.nuxeo.ecm.platform.forms.layout.api.impl.WidgetDefinitionImpl;
import org.nuxeo.ecm.platform.forms.layout.api.impl.WidgetReferenceImpl;
import org.nuxeo.ecm.platform.forms.layout.api.service.LayoutStore;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class DiffDisplayServiceImpl
extends DefaultComponent
implements DiffDisplayService {
    private static final long serialVersionUID = 6608445970773402827L;
    private static final Log LOGGER = LogFactory.getLog(DiffDisplayServiceImpl.class);
    protected static final String DIFF_DISPLAY_EXTENSION_POINT = "diffDisplay";
    protected static final String DIFF_DEFAULT_DISPLAY_EXTENSION_POINT = "diffDefaultDisplay";
    protected static final String DIFF_BLOCK_EXTENSION_POINT = "diffBlock";
    protected static final String DIFF_WIDGET_CATEGORY = "diff";
    protected static final String DIFF_BLOCK_DEFAULT_TEMPLATE_PATH = "/layouts/layout_diff_template.xhtml";
    protected static final String DIFF_BLOCK_LABEL_PROPERTY_NAME = "label";
    protected static final String DIFF_BLOCK_DEFAULT_LABEL_PREFIX = "label.diffBlock.";
    protected static final String DIFF_WIDGET_LABEL_PREFIX = "label.";
    protected static final String CONTENT_DIFF_LINKS_WIDGET_NAME = "contentDiffLinks";
    protected static final String CONTENT_DIFF_LINKS_WIDGET_NAME_SUFFIX = "_contentDiffLinks";
    protected static final String DIFF_WIDGET_FIELD_DEFINITION_VALUE = "value";
    protected static final String DIFF_WIDGET_FIELD_DEFINITION_DIFFERENCE_TYPE = "differenceType";
    protected static final String DIFF_WIDGET_FIELD_DEFINITION_STYLE_CLASS = "styleClass";
    protected static final String DIFF_WIDGET_FIELD_DEFINITION_FILENAME = "filename";
    protected static final String DIFF_WIDGET_FIELD_DEFINITION_DISPLAY_HTML_CONVERSION = "displayHtmlConversion";
    protected static final String DIFF_WIDGET_FIELD_DEFINITION_DISPLAY_TEXT_CONVERSION = "displayTextConversion";
    protected static final String DIFF_WIDGET_PROPERTY_DISPLAY_ALL_ITEMS = "displayAllItems";
    protected static final String DIFF_WIDGET_PROPERTY_DISPLAY_ITEM_INDEXES = "displayItemIndexes";
    protected static final String DIFF_LIST_WIDGET_INDEX_SUBWIDGET_FIELD = "index";
    protected static final String DIFF_LIST_WIDGET_INDEX_SUBWIDGET_TYPE = "int";
    protected static final String DIFF_LIST_WIDGET_INDEX_SUBWIDGET_LABEL = "label.list.index";
    protected static final String DIFF_LIST_WIDGET_VALUE_SUBWIDGET_FIELD = "value";
    protected Map<String, List<String>> diffExcludedFieldsContribs = new HashMap<String, List<String>>();
    protected Map<String, Map<String, DiffComplexFieldDefinition>> diffComplexFieldsContribs = new HashMap<String, Map<String, DiffComplexFieldDefinition>>();
    protected Map<String, List<String>> diffDisplayContribs = new HashMap<String, List<String>>();
    protected Map<String, DiffBlockDefinition> diffBlockContribs = new HashMap<String, DiffBlockDefinition>();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (DIFF_DEFAULT_DISPLAY_EXTENSION_POINT.equals(extensionPoint)) {
            if (contribution instanceof DiffExcludedFieldsDescriptor) {
                this.registerDiffExcludedFields((DiffExcludedFieldsDescriptor)contribution);
            } else if (contribution instanceof DiffComplexFieldDescriptor) {
                this.registerDiffComplexField((DiffComplexFieldDescriptor)contribution);
            }
        } else if (DIFF_DISPLAY_EXTENSION_POINT.equals(extensionPoint)) {
            if (contribution instanceof DiffDisplayDescriptor) {
                this.registerDiffDisplay((DiffDisplayDescriptor)contribution);
            }
        } else if (DIFF_BLOCK_EXTENSION_POINT.equals(extensionPoint) && contribution instanceof DiffBlockDescriptor) {
            this.registerDiffBlock((DiffBlockDescriptor)contribution);
        }
        super.registerContribution(contribution, extensionPoint, contributor);
    }

    @Override
    public Map<String, List<String>> getDiffExcludedSchemas() {
        return this.diffExcludedFieldsContribs;
    }

    @Override
    public List<String> getDiffExcludedFields(String schemaName) {
        return this.diffExcludedFieldsContribs.get(schemaName);
    }

    @Override
    public List<DiffComplexFieldDefinition> getDiffComplexFields() {
        ArrayList<DiffComplexFieldDefinition> diffComplexFields = new ArrayList<DiffComplexFieldDefinition>();
        for (Map<String, DiffComplexFieldDefinition> diffComplexFieldsBySchema : this.diffComplexFieldsContribs.values()) {
            for (DiffComplexFieldDefinition diffComplexField : diffComplexFieldsBySchema.values()) {
                diffComplexFields.add(diffComplexField);
            }
        }
        return diffComplexFields;
    }

    @Override
    public DiffComplexFieldDefinition getDiffComplexField(String schemaName, String fieldName) {
        Map<String, DiffComplexFieldDefinition> diffComplexFieldsBySchema = this.diffComplexFieldsContribs.get(schemaName);
        if (diffComplexFieldsBySchema != null) {
            return diffComplexFieldsBySchema.get(fieldName);
        }
        return null;
    }

    @Override
    public Map<String, List<String>> getDiffDisplays() {
        return this.diffDisplayContribs;
    }

    @Override
    public List<String> getDiffDisplay(String docType) {
        return this.diffDisplayContribs.get(docType);
    }

    @Override
    public Map<String, DiffBlockDefinition> getDiffBlockDefinitions() {
        return this.diffBlockContribs;
    }

    @Override
    public DiffBlockDefinition getDiffBlockDefinition(String name) {
        return this.diffBlockContribs.get(name);
    }

    @Override
    public List<DiffDisplayBlock> getDiffDisplayBlocks(DocumentDiff docDiff, DocumentModel leftDoc, DocumentModel rightDoc) {
        String rightDocType;
        String leftDocType = leftDoc.getType();
        if (leftDocType.equals(rightDocType = rightDoc.getType())) {
            LOGGER.info((Object)String.format("The 2 documents have the same type '%s' => looking for a diffDisplay contribution defined for this type or the nearest super type.", leftDocType));
            List<String> diffBlockRefs = this.getNearestSuperTypeDiffDisplay(leftDocType);
            if (diffBlockRefs != null) {
                LOGGER.info((Object)String.format("Found a diffDisplay contribution defined for the type '%s' or one of its super type => using it to display the diff.", leftDocType));
                return this.getDiffDisplayBlocks(this.getDiffBlockDefinitions(diffBlockRefs), docDiff, leftDoc, rightDoc);
            }
            LOGGER.info((Object)String.format("No diffDisplay contribution was defined for the type '%s' or one of its super type => using default diff display.", leftDocType));
        } else {
            LOGGER.info((Object)String.format("The 2 documents don't have the same type: '%s'/'%s' => looking for a diffDisplay contribution defined for the nearest common super type.", leftDocType, rightDocType));
            List<String> diffBlockRefs = this.getNearestSuperTypeDiffDisplay(leftDocType, rightDocType);
            if (diffBlockRefs != null) {
                LOGGER.info((Object)String.format("Found a diffDisplay contribution defined for a common super type of the types '%s'/'%s' => using it to display the diff.", leftDocType, rightDocType));
                return this.getDiffDisplayBlocks(this.getDiffBlockDefinitions(diffBlockRefs), docDiff, leftDoc, rightDoc);
            }
            LOGGER.info((Object)String.format("No diffDisplay contribution was defined for any of the common super types of the types '%s'/'%s' => using default diff display.", leftDocType, rightDocType));
        }
        return this.getDefaultDiffDisplayBlocks(docDiff, leftDoc, rightDoc);
    }

    public List<DiffDisplayBlock> getDefaultDiffDisplayBlocks(DocumentDiff docDiff, DocumentModel leftDoc, DocumentModel rightDoc) {
        return this.getDiffDisplayBlocks(this.getDefaultDiffBlockDefinitions(docDiff), docDiff, leftDoc, rightDoc);
    }

    protected List<String> getNearestSuperTypeDiffDisplay(String docTypeName) {
        List<String> diffDisplay = this.getDiffDisplay(docTypeName);
        DocumentType docType = this.getSchemaManager().getDocumentType(docTypeName);
        while (diffDisplay == null && docType != null) {
            Type superType = docType.getSuperType();
            if (superType != null) {
                diffDisplay = this.getDiffDisplay(superType.getName());
            }
            docType = superType;
        }
        return diffDisplay;
    }

    protected List<String> getNearestSuperTypeDiffDisplay(String leftDocTypeName, String rightDocTypeName) {
        List<String> diffDisplay = null;
        ArrayList<String> leftDocSuperTypeNames = new ArrayList<String>();
        ArrayList<String> rightDocSuperTypeNames = new ArrayList<String>();
        leftDocSuperTypeNames.add(leftDocTypeName);
        rightDocSuperTypeNames.add(rightDocTypeName);
        DocumentType leftDocType = this.getSchemaManager().getDocumentType(leftDocTypeName);
        DocumentType rightDocType = this.getSchemaManager().getDocumentType(rightDocTypeName);
        if (leftDocType != null && rightDocType != null) {
            Type[] rightDocTypeHierarchy;
            Type[] leftDocTypeHierarchy;
            for (Type type : leftDocTypeHierarchy = leftDocType.getTypeHierarchy()) {
                leftDocSuperTypeNames.add(type.getName());
            }
            for (Type type : rightDocTypeHierarchy = rightDocType.getTypeHierarchy()) {
                rightDocSuperTypeNames.add(type.getName());
            }
        }
        for (String superTypeName : leftDocSuperTypeNames) {
            if (!rightDocSuperTypeNames.contains(superTypeName)) continue;
            return this.getNearestSuperTypeDiffDisplay(superTypeName);
        }
        return diffDisplay;
    }

    protected final void registerDiffExcludedFields(DiffExcludedFieldsDescriptor descriptor) {
        String schemaName = descriptor.getSchema();
        if (!StringUtils.isEmpty((String)schemaName)) {
            boolean enabled = descriptor.isEnabled();
            List<String> diffExcludedFields = this.diffExcludedFieldsContribs.get(schemaName);
            if (diffExcludedFields != null) {
                if (!enabled) {
                    this.diffExcludedFieldsContribs.remove(schemaName);
                } else {
                    this.diffExcludedFieldsContribs.put(schemaName, this.getDiffExcludedFieldRefs(descriptor.getFields()));
                }
            } else if (enabled) {
                this.diffExcludedFieldsContribs.put(schemaName, this.getDiffExcludedFieldRefs(descriptor.getFields()));
            }
        }
    }

    protected final void registerDiffComplexField(DiffComplexFieldDescriptor descriptor) {
        String schemaName = descriptor.getSchema();
        String fieldName = descriptor.getName();
        if (!StringUtils.isEmpty((String)schemaName) && !StringUtils.isEmpty((String)fieldName)) {
            DiffComplexFieldDefinition diffComplexField = this.getDiffComplexField(schemaName, fieldName);
            if (diffComplexField != null) {
                this.diffComplexFieldsContribs.get(schemaName).put(fieldName, descriptor.getDiffComplexFieldDefinition());
            } else {
                Map<String, DiffComplexFieldDefinition> diffComplexFieldsBySchema = this.diffComplexFieldsContribs.get(schemaName);
                if (diffComplexFieldsBySchema == null) {
                    diffComplexFieldsBySchema = new HashMap<String, DiffComplexFieldDefinition>();
                    this.diffComplexFieldsContribs.put(schemaName, diffComplexFieldsBySchema);
                }
                diffComplexFieldsBySchema.put(fieldName, descriptor.getDiffComplexFieldDefinition());
            }
        }
    }

    protected final void registerDiffDisplay(DiffDisplayDescriptor descriptor) {
        String docType = descriptor.getType();
        if (!StringUtils.isEmpty((String)docType)) {
            boolean enabled = descriptor.isEnabled();
            List<String> diffDisplay = this.diffDisplayContribs.get(docType);
            if (diffDisplay != null) {
                if (!enabled) {
                    this.diffDisplayContribs.remove(docType);
                } else {
                    this.diffDisplayContribs.put(docType, this.getDiffBlockRefs(descriptor.getDiffBlocks()));
                }
            } else if (enabled) {
                this.diffDisplayContribs.put(docType, this.getDiffBlockRefs(descriptor.getDiffBlocks()));
            }
        }
    }

    protected final List<String> getDiffBlockRefs(List<DiffBlockReferenceDescriptor> diffBlocks) {
        ArrayList<String> diffBlockRefs = new ArrayList<String>();
        for (DiffBlockReferenceDescriptor diffBlockRef : diffBlocks) {
            diffBlockRefs.add(diffBlockRef.getName());
        }
        return diffBlockRefs;
    }

    protected final List<String> getDiffExcludedFieldRefs(List<DiffFieldDescriptor> diffExcludedFields) {
        ArrayList<String> diffExcludedFieldRefs = new ArrayList<String>();
        for (DiffFieldDescriptor diffExcludedFieldRef : diffExcludedFields) {
            diffExcludedFieldRefs.add(diffExcludedFieldRef.getName());
        }
        return diffExcludedFieldRefs;
    }

    protected final void registerDiffBlock(DiffBlockDescriptor descriptor) {
        String diffBlockName = descriptor.getName();
        if (!StringUtils.isEmpty((String)diffBlockName)) {
            List<DiffFieldDescriptor> fieldDescriptors = descriptor.getFields();
            if (fieldDescriptors == null || fieldDescriptors.isEmpty()) {
                LOGGER.warn((Object)String.format("The diffBlock contribution named '%s' has no fields, it won't be taken into account.", diffBlockName));
            } else {
                ArrayList<DiffFieldDefinition> fields = new ArrayList<DiffFieldDefinition>();
                for (DiffFieldDescriptor fieldDescriptor : fieldDescriptors) {
                    String category = fieldDescriptor.getCategory();
                    String schema = fieldDescriptor.getSchema();
                    String name = fieldDescriptor.getName();
                    boolean displayContentDiffLinks = fieldDescriptor.isDisplayContentDiffLinks();
                    List<DiffFieldItemDescriptor> fieldItemDescriptors = fieldDescriptor.getItems();
                    if (StringUtils.isEmpty((String)schema) || StringUtils.isEmpty((String)name)) continue;
                    ArrayList<DiffFieldItemDefinition> items = new ArrayList<DiffFieldItemDefinition>();
                    for (DiffFieldItemDescriptor fieldItemDescriptor : fieldItemDescriptors) {
                        items.add(new DiffFieldItemDefinitionImpl(fieldItemDescriptor.getName(), fieldItemDescriptor.isDisplayContentDiffLinks()));
                    }
                    fields.add(new DiffFieldDefinitionImpl(category, schema, name, displayContentDiffLinks, items));
                }
                this.diffBlockContribs.put(diffBlockName, new DiffBlockDefinitionImpl(diffBlockName, descriptor.getTemplates(), fields, descriptor.getProperties()));
            }
        }
    }

    protected final List<DiffBlockDefinition> getDefaultDiffBlockDefinitions(DocumentDiff docDiff) {
        ArrayList<DiffBlockDefinition> diffBlockDefs = new ArrayList<DiffBlockDefinition>();
        for (String schemaName : docDiff.getSchemaNames()) {
            List<String> diffExcludedFields = this.getDiffExcludedFields(schemaName);
            if (diffExcludedFields != null && diffExcludedFields.size() <= 0) continue;
            SchemaDiff schemaDiff = docDiff.getSchemaDiff(schemaName);
            ArrayList<DiffFieldDefinition> fieldDefs = new ArrayList<DiffFieldDefinition>();
            for (String fieldName : schemaDiff.getFieldNames()) {
                if (diffExcludedFields != null && diffExcludedFields.contains(fieldName)) continue;
                ArrayList<DiffFieldItemDefinition> fieldItems = new ArrayList<DiffFieldItemDefinition>();
                DiffComplexFieldDefinition complexFieldDef = this.getDiffComplexField(schemaName, fieldName);
                if (complexFieldDef != null) {
                    List<DiffFieldItemDefinition> includedItems = complexFieldDef.getIncludedItems();
                    List<DiffFieldItemDefinition> excludedItems = complexFieldDef.getExcludedItems();
                    if (!CollectionUtils.isEmpty(includedItems)) {
                        fieldItems.addAll(includedItems);
                    } else if (!CollectionUtils.isEmpty(excludedItems)) {
                        Field complexField = ComplexPropertyHelper.getField(schemaName, fieldName);
                        if (complexField.getType().isListType()) {
                            complexField = ComplexPropertyHelper.getListFieldItem(complexField);
                        }
                        if (!complexField.getType().isComplexType()) {
                            throw new NuxeoException(String.format("Cannot compute field items for [%s:%s] since it is not a complex nor a complex list property.", schemaName, fieldName));
                        }
                        List<Field> complexFieldItems = ComplexPropertyHelper.getComplexFieldItems(complexField);
                        for (Field complexFieldItem : complexFieldItems) {
                            String complexFieldItemName = complexFieldItem.getName().getLocalName();
                            boolean isFieldItem = true;
                            for (DiffFieldItemDefinition fieldItemDef : excludedItems) {
                                if (!fieldItemDef.getName().equals(complexFieldItemName)) continue;
                                isFieldItem = false;
                                break;
                            }
                            if (!isFieldItem) continue;
                            fieldItems.add(new DiffFieldItemDefinitionImpl(complexFieldItemName));
                        }
                    }
                }
                fieldDefs.add(new DiffFieldDefinitionImpl(DIFF_WIDGET_CATEGORY, schemaName, fieldName, fieldItems));
            }
            HashMap<String, String> defaultDiffBlockTemplates = new HashMap<String, String>();
            defaultDiffBlockTemplates.put("any", DIFF_BLOCK_DEFAULT_TEMPLATE_PATH);
            HashMap<String, Map<String, Serializable>> defaultDiffBlockProperties = new HashMap<String, Map<String, Serializable>>();
            HashMap<String, String> labelProperty = new HashMap<String, String>();
            labelProperty.put(DIFF_BLOCK_LABEL_PROPERTY_NAME, DIFF_BLOCK_DEFAULT_LABEL_PREFIX + schemaName);
            defaultDiffBlockProperties.put("any", labelProperty);
            diffBlockDefs.add(new DiffBlockDefinitionImpl(schemaName, defaultDiffBlockTemplates, fieldDefs, defaultDiffBlockProperties));
        }
        return diffBlockDefs;
    }

    protected final List<DiffBlockDefinition> getDiffBlockDefinitions(List<String> diffBlockRefs) {
        ArrayList<DiffBlockDefinition> diffBlockDefinitions = new ArrayList<DiffBlockDefinition>();
        for (String diffBlockRef : diffBlockRefs) {
            diffBlockDefinitions.add(this.getDiffBlockDefinition(diffBlockRef));
        }
        return diffBlockDefinitions;
    }

    protected final List<DiffDisplayBlock> getDiffDisplayBlocks(List<DiffBlockDefinition> diffBlockDefinitions, DocumentDiff docDiff, DocumentModel leftDoc, DocumentModel rightDoc) {
        ArrayList<DiffDisplayBlock> diffDisplayBlocks = new ArrayList<DiffDisplayBlock>();
        for (DiffBlockDefinition diffBlockDef : diffBlockDefinitions) {
            DiffDisplayBlock diffDisplayBlock;
            if (diffBlockDef == null || (diffDisplayBlock = this.getDiffDisplayBlock(diffBlockDef, docDiff, leftDoc, rightDoc)).isEmpty()) continue;
            diffDisplayBlocks.add(diffDisplayBlock);
        }
        return diffDisplayBlocks;
    }

    protected final DiffDisplayBlock getDiffDisplayBlock(DiffBlockDefinition diffBlockDefinition, DocumentDiff docDiff, DocumentModel leftDoc, DocumentModel rightDoc) {
        HashMap<String, Map<String, PropertyDiffDisplay>> leftValue = new HashMap<String, Map<String, PropertyDiffDisplay>>();
        HashMap<String, Map<String, PropertyDiffDisplay>> rightValue = new HashMap<String, Map<String, PropertyDiffDisplay>>();
        HashMap<String, Map<String, PropertyDiffDisplay>> contentDiffValue = new HashMap<String, Map<String, PropertyDiffDisplay>>();
        ArrayList<LayoutRowDefinitionImpl> layoutRowDefinitions = new ArrayList<LayoutRowDefinitionImpl>();
        ArrayList<WidgetDefinition> widgetDefinitions = new ArrayList<WidgetDefinition>();
        List<DiffFieldDefinition> fieldDefinitions = diffBlockDefinition.getFields();
        for (DiffFieldDefinition fieldDefinition : fieldDefinitions) {
            Serializable rightProperty;
            Serializable leftProperty;
            PropertyDiff fieldDiff;
            String category = fieldDefinition.getCategory();
            if (StringUtils.isEmpty((String)category)) {
                category = DIFF_WIDGET_CATEGORY;
            }
            String schemaName = fieldDefinition.getSchema();
            String fieldName = fieldDefinition.getName();
            boolean displayContentDiffLinks = fieldDefinition.isDisplayContentDiffLinks();
            List<DiffFieldItemDefinition> fieldItemDefs = fieldDefinition.getItems();
            SchemaDiff schemaDiff = docDiff.getSchemaDiff(schemaName);
            if (schemaDiff == null || (fieldDiff = schemaDiff.getFieldDiff(fieldName)) == null || !this.isFieldDiffSignificant(leftProperty = (Serializable)leftDoc.getProperty(schemaName, fieldName), rightProperty = (Serializable)rightDoc.getProperty(schemaName, fieldName))) continue;
            String propertyName = this.getPropertyName(schemaName, fieldName);
            ArrayList<WidgetReferenceImpl> widgetReferences = new ArrayList<WidgetReferenceImpl>();
            WidgetDefinition propertyWidgetDefinition = this.getWidgetDefinition(category, propertyName, fieldDiff.getPropertyType(), null, fieldItemDefs, false);
            widgetDefinitions.add(propertyWidgetDefinition);
            WidgetReferenceImpl propertyWidgetRef = new WidgetReferenceImpl(category, propertyName);
            widgetReferences.add(propertyWidgetRef);
            if (!displayContentDiffLinks) {
                for (DiffFieldItemDefinition fieldItemDef : fieldItemDefs) {
                    if (!fieldItemDef.isDisplayContentDiffLinks()) continue;
                    displayContentDiffLinks = true;
                    break;
                }
            }
            if (displayContentDiffLinks) {
                WidgetDefinition contentDiffLinksWidgetDefinition = this.getWidgetDefinition(category, propertyName, fieldDiff.getPropertyType(), null, fieldItemDefs, true);
                widgetDefinitions.add(contentDiffLinksWidgetDefinition);
                WidgetReferenceImpl contentDiffLinksWidgetRef = new WidgetReferenceImpl(category, propertyName + CONTENT_DIFF_LINKS_WIDGET_NAME_SUFFIX);
                widgetReferences.add(contentDiffLinksWidgetRef);
            }
            LayoutRowDefinitionImpl layoutRowDefinition = new LayoutRowDefinitionImpl(propertyName, null, widgetReferences, false, true);
            layoutRowDefinitions.add(layoutRowDefinition);
            boolean isDisplayAllItems = this.isDisplayAllItems(propertyWidgetDefinition);
            boolean isDisplayItemIndexes = this.isDisplayItemIndexes(propertyWidgetDefinition);
            this.setFieldDiffDisplay(leftProperty, fieldDiff, isDisplayAllItems, isDisplayItemIndexes, leftValue, schemaName, fieldName, leftDoc, "redBackgroundColor");
            this.setFieldDiffDisplay(rightProperty, fieldDiff, isDisplayAllItems, isDisplayItemIndexes, rightValue, schemaName, fieldName, rightDoc, "greenBackgroundColor");
            if (!displayContentDiffLinks) continue;
            PropertyDiffDisplay contentDiffDisplay = this.getFieldXPaths(propertyName, fieldDiff, leftProperty, rightProperty, isDisplayAllItems, isDisplayItemIndexes, fieldItemDefs);
            HashMap<String, PropertyDiffDisplay> contentDiffSchemaMap = (HashMap<String, PropertyDiffDisplay>)contentDiffValue.get(schemaName);
            if (contentDiffSchemaMap == null) {
                contentDiffSchemaMap = new HashMap<String, PropertyDiffDisplay>();
                contentDiffValue.put(schemaName, contentDiffSchemaMap);
            }
            contentDiffSchemaMap.put(fieldName, contentDiffDisplay);
        }
        LayoutDefinitionImpl layoutDefinition = new LayoutDefinitionImpl(diffBlockDefinition.getName(), diffBlockDefinition.getProperties(), diffBlockDefinition.getTemplates(), layoutRowDefinitions, widgetDefinitions);
        Map<String, Serializable> diffBlockProperties = diffBlockDefinition.getProperties("any");
        DiffDisplayBlockImpl diffDisplayBlock = new DiffDisplayBlockImpl((String)((Object)diffBlockProperties.get(DIFF_BLOCK_LABEL_PROPERTY_NAME)), leftValue, rightValue, contentDiffValue, (LayoutDefinition)layoutDefinition);
        return diffDisplayBlock;
    }

    protected boolean isFieldDiffSignificant(Serializable leftProperty, Serializable rightProperty) {
        if (leftProperty instanceof Calendar && rightProperty instanceof Calendar) {
            Calendar leftDate = (Calendar)leftProperty;
            Calendar rightDate = (Calendar)rightProperty;
            if (Math.abs(leftDate.getTimeInMillis() - rightDate.getTimeInMillis()) <= 60000L) {
                return false;
            }
        }
        return true;
    }

    protected final boolean isDisplayAllItems(WidgetDefinition wDef) {
        return this.getBooleanProperty(wDef, "any", DIFF_WIDGET_PROPERTY_DISPLAY_ALL_ITEMS);
    }

    protected final boolean isDisplayItemIndexes(WidgetDefinition wDef) {
        return this.getBooleanProperty(wDef, "any", DIFF_WIDGET_PROPERTY_DISPLAY_ITEM_INDEXES);
    }

    protected final boolean getBooleanProperty(WidgetDefinition wDef, String mode, String property) {
        Serializable propertyValue;
        Map modeProps;
        Map props = wDef.getProperties();
        if (props != null && (modeProps = (Map)props.get(mode)) != null && (propertyValue = (Serializable)modeProps.get(property)) instanceof String) {
            return Boolean.parseBoolean((String)((Object)propertyValue));
        }
        return false;
    }

    protected void setFieldDiffDisplay(Serializable property, PropertyDiff fieldDiff, boolean isDisplayAllItems, boolean isDisplayItemIndexes, Map<String, Map<String, PropertyDiffDisplay>> value, String schemaName, String fieldName, DocumentModel doc, String styleClass) {
        PropertyDiffDisplay fieldDiffDisplay = this.getFieldDiffDisplay(property, fieldDiff, isDisplayAllItems, isDisplayItemIndexes, false, styleClass);
        Map<String, PropertyDiffDisplay> schemaMap = value.get(schemaName);
        if (schemaMap == null) {
            schemaMap = new HashMap<String, PropertyDiffDisplay>();
            value.put(schemaName, schemaMap);
        }
        schemaMap.put(fieldName, fieldDiffDisplay);
        this.putMimeTypeDiffDisplay(schemaName, fieldName, schemaMap, doc);
    }

    protected final void putMimeTypeDiffDisplay(String schemaName, String fieldName, Map<String, PropertyDiffDisplay> schemaMap, DocumentModel doc) {
        if ("note".equals(schemaName) && "note".equals(fieldName) && !schemaMap.containsKey("mime_type")) {
            schemaMap.put("mime_type", new PropertyDiffDisplayImpl((Serializable)doc.getProperty("note", "mime_type")));
        }
    }

    protected final PropertyDiffDisplay getFieldDiffDisplay(Serializable property, PropertyDiff propertyDiff, boolean isDisplayAllItems, boolean isDisplayItemIndexes, boolean mustApplyStyleClass, String styleClass) {
        if (property == null) {
            String fieldDiffDisplayStyleClass = "noBackgroundColor";
            if (mustApplyStyleClass && propertyDiff != null) {
                fieldDiffDisplayStyleClass = styleClass;
            }
            return new PropertyDiffDisplayImpl(null, fieldDiffDisplayStyleClass);
        }
        if (this.isListType(property)) {
            List<Serializable> listProperty = this.getListProperty(property);
            return this.getListFieldDiffDisplay(listProperty, (ListPropertyDiff)propertyDiff, isDisplayAllItems, isDisplayItemIndexes, styleClass);
        }
        return this.getFinalFieldDiffDisplay(property, propertyDiff, mustApplyStyleClass, styleClass);
    }

    protected final PropertyDiffDisplay getFinalFieldDiffDisplay(Serializable fieldDiffDisplay, PropertyDiff propertyDiff, boolean mustApplyStyleClass, String styleClass) {
        PropertyDiffDisplayImpl finalFieldDiffDisplay;
        String finalFieldDiffDisplayStyleClass = "noBackgroundColor";
        if (mustApplyStyleClass && propertyDiff != null) {
            finalFieldDiffDisplayStyleClass = styleClass;
        }
        if (this.isComplexType(fieldDiffDisplay)) {
            ComplexPropertyDiff complexPropertyDiff = null;
            if (propertyDiff != null) {
                if (!propertyDiff.isComplexType()) {
                    throw new NuxeoException("'fieldDiffDisplay' is of complex type whereas 'propertyDiff' is not, this is inconsistent");
                }
                complexPropertyDiff = (ComplexPropertyDiff)propertyDiff;
            }
            Map<String, Serializable> complexFieldDiffDisplay = this.getComplexProperty(fieldDiffDisplay);
            for (String complexItemName : complexFieldDiffDisplay.keySet()) {
                PropertyDiff complexItemPropertyDiff = null;
                if (complexPropertyDiff != null) {
                    complexItemPropertyDiff = complexPropertyDiff.getDiff(complexItemName);
                }
                complexFieldDiffDisplay.put(complexItemName, this.getFinalFieldDiffDisplay(complexFieldDiffDisplay.get(complexItemName), complexItemPropertyDiff, true, styleClass));
            }
            finalFieldDiffDisplay = new PropertyDiffDisplayImpl((Serializable)((Object)complexFieldDiffDisplay));
        } else {
            finalFieldDiffDisplay = fieldDiffDisplay instanceof Calendar ? new PropertyDiffDisplayImpl((Serializable)((Calendar)fieldDiffDisplay).getTime(), finalFieldDiffDisplayStyleClass) : new PropertyDiffDisplayImpl(fieldDiffDisplay, finalFieldDiffDisplayStyleClass);
        }
        return finalFieldDiffDisplay;
    }

    protected final PropertyDiffDisplay getListFieldDiffDisplay(List<Serializable> listProperty, ListPropertyDiff listPropertyDiff, boolean isDisplayAllItems, boolean isDisplayItemIndexes, String styleClass) {
        List<Integer> listPropertyIndexes = new ArrayList();
        if (isDisplayAllItems) {
            for (int index = 0; index < listProperty.size(); ++index) {
                listPropertyIndexes.add(index);
            }
        } else if (listPropertyDiff != null) {
            listPropertyIndexes = listPropertyDiff.getDiffIndexes();
        }
        return this.getComplexListFieldDiffDisplay(listProperty, listPropertyIndexes, listPropertyDiff, isDisplayAllItems, isDisplayItemIndexes, styleClass);
    }

    protected final PropertyDiffDisplay getComplexListFieldDiffDisplay(List<Serializable> listProperty, List<Integer> listPropertyIndexes, ListPropertyDiff listPropertyDiff, boolean isDisplayAllItems, boolean isDisplayItemIndexes, String styleClass) {
        boolean isComplexListWidget;
        if (listPropertyIndexes.isEmpty()) {
            return new PropertyDiffDisplayImpl(new ArrayList());
        }
        boolean bl = isComplexListWidget = isDisplayItemIndexes || listPropertyDiff != null && listPropertyDiff.isComplexListType();
        if (isComplexListWidget) {
            ArrayList listFieldDiffDisplay = new ArrayList();
            Set<String> complexPropertyItemNames = null;
            for (int index : listPropertyIndexes) {
                HashMap<String, Serializable> listItemDiffDisplay = new HashMap<String, Serializable>();
                if (isDisplayItemIndexes) {
                    listItemDiffDisplay.put(DIFF_LIST_WIDGET_INDEX_SUBWIDGET_FIELD, Integer.valueOf(index + 1));
                }
                if (index < listProperty.size()) {
                    Serializable listPropertyItem = listProperty.get(index);
                    PropertyDiff listItemPropertyDiff = null;
                    if (listPropertyDiff != null) {
                        listItemPropertyDiff = listPropertyDiff.getDiff(index);
                    }
                    if (this.isComplexType(listPropertyItem)) {
                        ComplexPropertyDiff complexPropertyDiff = null;
                        if (listItemPropertyDiff != null && listItemPropertyDiff.isComplexType()) {
                            complexPropertyDiff = (ComplexPropertyDiff)listItemPropertyDiff;
                        }
                        Map<String, Serializable> complexProperty = this.getComplexProperty(listPropertyItem);
                        complexPropertyItemNames = complexProperty.keySet();
                        for (String complexPropertyItemName : complexPropertyItemNames) {
                            Serializable complexPropertyItem = complexProperty.get(complexPropertyItemName);
                            PropertyDiff complexItemPropertyDiff = null;
                            if (complexPropertyDiff != null) {
                                complexItemPropertyDiff = complexPropertyDiff.getDiff(complexPropertyItemName);
                            }
                            listItemDiffDisplay.put(complexPropertyItemName, this.getFieldDiffDisplay(complexPropertyItem, complexItemPropertyDiff, isDisplayAllItems, isDisplayItemIndexes, true, styleClass));
                        }
                    } else {
                        listItemDiffDisplay.put("value", this.getFinalFieldDiffDisplay(listPropertyItem, listItemPropertyDiff, isDisplayAllItems, styleClass));
                    }
                } else if (complexPropertyItemNames != null) {
                    for (String complexPropertyItemName : complexPropertyItemNames) {
                        listItemDiffDisplay.put(complexPropertyItemName, new PropertyDiffDisplayImpl(null, styleClass));
                    }
                } else {
                    listItemDiffDisplay.put("value", new PropertyDiffDisplayImpl(null, isDisplayAllItems ? styleClass : "noBackgroundColor"));
                }
                listFieldDiffDisplay.add(listItemDiffDisplay);
            }
            return new PropertyDiffDisplayImpl(listFieldDiffDisplay);
        }
        ArrayList<PropertyDiffDisplay> listFieldDiffDisplay = new ArrayList<PropertyDiffDisplay>();
        for (int index : listPropertyIndexes) {
            if (index < listProperty.size()) {
                PropertyDiff listItemPropertyDiff = null;
                if (listPropertyDiff != null) {
                    listItemPropertyDiff = listPropertyDiff.getDiff(index);
                }
                listFieldDiffDisplay.add(this.getFinalFieldDiffDisplay(listProperty.get(index), listItemPropertyDiff, isDisplayAllItems, styleClass));
                continue;
            }
            listFieldDiffDisplay.add(new PropertyDiffDisplayImpl(null, isDisplayAllItems ? styleClass : "noBackgroundColor"));
        }
        return new PropertyDiffDisplayImpl(listFieldDiffDisplay);
    }

    protected final PropertyDiffDisplay getFieldXPaths(String propertyName, PropertyDiff propertyDiff, Serializable leftProperty, Serializable rightProperty, boolean isDisplayAllItems, boolean isDisplayItemIndexes, List<DiffFieldItemDefinition> complexFieldItemDefs) {
        boolean isDisplayTextConversion;
        PropertyDiffDisplay fieldXPaths = null;
        if (propertyDiff == null) {
            throw new NuxeoException("The 'propertyDiff' parameter cannot be null.");
        }
        boolean isDisplayHtmlConversion = ContentDiffHelper.isDisplayHtmlConversion((Serializable)leftProperty) && ContentDiffHelper.isDisplayHtmlConversion((Serializable)rightProperty);
        boolean bl = isDisplayTextConversion = ContentDiffHelper.isDisplayTextConversion((Serializable)leftProperty) && ContentDiffHelper.isDisplayTextConversion((Serializable)rightProperty);
        if (propertyDiff.isSimpleType()) {
            SimplePropertyDiff simplePropertyDiff = (SimplePropertyDiff)propertyDiff;
            if (!StringUtils.isEmpty((String)simplePropertyDiff.getLeftValue()) && !StringUtils.isEmpty((String)simplePropertyDiff.getRightValue())) {
                fieldXPaths = new ContentDiffDisplayImpl((Serializable)((Object)propertyName), simplePropertyDiff.getDifferenceType(), isDisplayHtmlConversion, isDisplayTextConversion);
            }
        } else if (propertyDiff.isContentType()) {
            ContentPropertyDiff contentPropertyDiff = (ContentPropertyDiff)propertyDiff;
            ContentProperty leftContent = contentPropertyDiff.getLeftContent();
            ContentProperty rightContent = contentPropertyDiff.getRightContent();
            if (leftContent != null && rightContent != null && !StringUtils.isEmpty((String)leftContent.getFilename()) && !StringUtils.isEmpty((String)rightContent.getFilename()) || !StringUtils.isEmpty((String)leftContent.getDigest()) && !StringUtils.isEmpty((String)rightContent.getDigest())) {
                fieldXPaths = new ContentDiffDisplayImpl((Serializable)((Object)propertyName), contentPropertyDiff.getDifferenceType(), isDisplayHtmlConversion, isDisplayTextConversion);
            }
        } else if (propertyDiff.isComplexType()) {
            Map<String, Serializable> leftComplexProperty = this.getComplexPropertyIfNotNull(leftProperty);
            Map<String, Serializable> rightComplexProperty = this.getComplexPropertyIfNotNull(rightProperty);
            Map complexPropertyDiffMap = ((ComplexPropertyDiff)propertyDiff).getDiffMap();
            HashMap<String, Serializable> complexPropertyXPaths = new HashMap<String, Serializable>();
            if (CollectionUtils.isEmpty(complexFieldItemDefs)) {
                for (String complexFieldItemName : complexPropertyDiffMap.keySet()) {
                    this.setComplexPropertyXPaths(complexPropertyXPaths, complexFieldItemName, this.getSubPropertyFullName(propertyName, complexFieldItemName), complexPropertyDiffMap, leftComplexProperty, rightComplexProperty, isDisplayAllItems, isDisplayItemIndexes);
                }
            } else {
                for (DiffFieldItemDefinition complexFieldItemDef : complexFieldItemDefs) {
                    String complexFieldItemName;
                    if (!complexFieldItemDef.isDisplayContentDiffLinks() || !complexPropertyDiffMap.containsKey(complexFieldItemName = complexFieldItemDef.getName())) continue;
                    this.setComplexPropertyXPaths(complexPropertyXPaths, complexFieldItemName, this.getSubPropertyFullName(propertyName, complexFieldItemName), complexPropertyDiffMap, leftComplexProperty, rightComplexProperty, isDisplayAllItems, isDisplayItemIndexes);
                }
            }
            fieldXPaths = new ContentDiffDisplayImpl(complexPropertyXPaths);
        } else {
            List<Serializable> leftListProperty = this.getListPropertyIfNotNull(leftProperty);
            List<Serializable> rightListProperty = this.getListPropertyIfNotNull(rightProperty);
            ListPropertyDiff listPropertyDiff = (ListPropertyDiff)propertyDiff;
            ArrayList<Integer> listPropertyIndexes = new ArrayList();
            if (isDisplayAllItems) {
                int listPropertySize = Math.min(leftListProperty.size(), rightListProperty.size());
                for (int index = 0; index < listPropertySize; ++index) {
                    listPropertyIndexes.add(index);
                }
            } else {
                listPropertyIndexes = listPropertyDiff.getDiffIndexes();
            }
            fieldXPaths = this.getComplexListXPaths(propertyName, listPropertyIndexes, listPropertyDiff, leftListProperty, rightListProperty, isDisplayAllItems, isDisplayItemIndexes);
        }
        return fieldXPaths;
    }

    protected final PropertyDiffDisplay getComplexListXPaths(String propertyName, List<Integer> listPropertyIndexes, ListPropertyDiff listPropertyDiff, List<Serializable> leftListProperty, List<Serializable> rightListProperty, boolean isDisplayAllItems, boolean isDisplayItemIndexes) {
        boolean isComplexListWidget;
        if (listPropertyIndexes.isEmpty()) {
            return new ContentDiffDisplayImpl(new ArrayList());
        }
        boolean bl = isComplexListWidget = isDisplayItemIndexes || listPropertyDiff != null && listPropertyDiff.isComplexListType();
        if (isComplexListWidget) {
            ArrayList<HashMap<String, Serializable>> listFieldXPaths = new ArrayList<HashMap<String, Serializable>>();
            for (int index : listPropertyIndexes) {
                PropertyDiff listItemPropertyDiff;
                HashMap<String, Serializable> listItemXPaths = new HashMap<String, Serializable>();
                if (isDisplayItemIndexes) {
                    listItemXPaths.put(DIFF_LIST_WIDGET_INDEX_SUBWIDGET_FIELD, Integer.valueOf(index + 1));
                }
                if ((listItemPropertyDiff = listPropertyDiff.getDiff(index)) != null) {
                    Serializable leftListPropertyItem = null;
                    Serializable rightListPropertyItem = null;
                    if (index < leftListProperty.size()) {
                        leftListPropertyItem = leftListProperty.get(index);
                    }
                    if (index < rightListProperty.size()) {
                        rightListPropertyItem = rightListProperty.get(index);
                    }
                    Map<String, Serializable> leftComplexProperty = null;
                    Map<String, Serializable> rightComplexProperty = null;
                    if (this.isComplexType(leftListPropertyItem)) {
                        leftComplexProperty = this.getComplexProperty(leftListPropertyItem);
                    }
                    if (this.isComplexType(rightListPropertyItem)) {
                        rightComplexProperty = this.getComplexProperty(rightListPropertyItem);
                    }
                    if (listItemPropertyDiff.isComplexType()) {
                        Map complexPropertyDiffMap = ((ComplexPropertyDiff)listItemPropertyDiff).getDiffMap();
                        for (String complexPropertyItemName : complexPropertyDiffMap.keySet()) {
                            this.setComplexPropertyXPaths(listItemXPaths, complexPropertyItemName, this.getSubPropertyFullName(propertyName, this.getSubPropertyFullName(String.valueOf(index), complexPropertyItemName)), complexPropertyDiffMap, leftComplexProperty, rightComplexProperty, isDisplayAllItems, isDisplayItemIndexes);
                        }
                    } else {
                        String listItemXPath = null;
                        if (leftListPropertyItem != null && rightListPropertyItem != null) {
                            listItemXPath = this.getSubPropertyFullName(propertyName, String.valueOf(index));
                        }
                        boolean isDisplayHtmlConversion = ContentDiffHelper.isDisplayHtmlConversion((Serializable)leftListPropertyItem) && ContentDiffHelper.isDisplayHtmlConversion((Serializable)rightListPropertyItem);
                        boolean isDisplayTextConversion = ContentDiffHelper.isDisplayTextConversion((Serializable)leftListPropertyItem) && ContentDiffHelper.isDisplayTextConversion((Serializable)rightListPropertyItem);
                        listItemXPaths.put("value", new ContentDiffDisplayImpl((Serializable)((Object)listItemXPath), listItemPropertyDiff.getDifferenceType(), isDisplayHtmlConversion, isDisplayTextConversion));
                    }
                }
                listFieldXPaths.add(listItemXPaths);
            }
            return new ContentDiffDisplayImpl(listFieldXPaths);
        }
        ArrayList<ContentDiffDisplayImpl> listFieldXPaths = new ArrayList<ContentDiffDisplayImpl>();
        for (int index : listPropertyIndexes) {
            ContentDiffDisplayImpl listItemXPath = null;
            if (index < leftListProperty.size() && index < rightListProperty.size()) {
                PropertyDiff listItemPropertyDiff = null;
                if (listPropertyDiff != null) {
                    listItemPropertyDiff = listPropertyDiff.getDiff(index);
                }
                DifferenceType differenceType = DifferenceType.different;
                if (listItemPropertyDiff != null) {
                    differenceType = listItemPropertyDiff.getDifferenceType();
                }
                Serializable leftListPropertyItem = leftListProperty.get(index);
                Serializable rightListPropertyItem = rightListProperty.get(index);
                boolean isDisplayHtmlConversion = ContentDiffHelper.isDisplayHtmlConversion((Serializable)leftListPropertyItem) && ContentDiffHelper.isDisplayHtmlConversion((Serializable)rightListPropertyItem);
                boolean isDisplayTextConversion = ContentDiffHelper.isDisplayTextConversion((Serializable)leftListPropertyItem) && ContentDiffHelper.isDisplayTextConversion((Serializable)rightListPropertyItem);
                listItemXPath = new ContentDiffDisplayImpl((Serializable)((Object)this.getSubPropertyFullName(propertyName, String.valueOf(index))), differenceType, isDisplayHtmlConversion, isDisplayTextConversion);
            }
            listFieldXPaths.add(listItemXPath);
        }
        return new ContentDiffDisplayImpl(listFieldXPaths);
    }

    protected void setComplexPropertyXPaths(Map<String, Serializable> complexPropertyXPaths, String complexFieldItemName, String subPropertyFullName, Map<String, PropertyDiff> complexPropertyDiffMap, Map<String, Serializable> leftComplexProperty, Map<String, Serializable> rightComplexProperty, boolean isDisplayAllItems, boolean isDisplayItemIndexes) {
        Serializable leftComplexPropertyItemValue = null;
        Serializable rightComplexPropertyItemValue = null;
        if (leftComplexProperty != null) {
            leftComplexPropertyItemValue = leftComplexProperty.get(complexFieldItemName);
        }
        if (rightComplexProperty != null) {
            rightComplexPropertyItemValue = rightComplexProperty.get(complexFieldItemName);
        }
        complexPropertyXPaths.put(complexFieldItemName, this.getFieldXPaths(subPropertyFullName, complexPropertyDiffMap.get(complexFieldItemName), leftComplexPropertyItemValue, rightComplexPropertyItemValue, isDisplayAllItems, isDisplayItemIndexes, null));
    }

    protected boolean isListType(Serializable property) {
        return property instanceof List || property instanceof Serializable[];
    }

    protected boolean isComplexType(Serializable property) {
        return property instanceof Map;
    }

    protected List<Serializable> getListProperty(Serializable property) {
        List<Serializable> listProperty = property instanceof List ? (List<Serializable>)((Object)property) : Arrays.asList((Serializable[])property);
        return listProperty;
    }

    protected List<Serializable> getListPropertyIfNotNull(Serializable property) {
        if (property != null) {
            if (!this.isListType(property)) {
                throw new NuxeoException("Tryed to get a list property from a Serializable property that is not a list, this is inconsistent.");
            }
            return this.getListProperty(property);
        }
        return null;
    }

    protected Map<String, Serializable> getComplexProperty(Serializable property) {
        return (Map)((Object)property);
    }

    protected Map<String, Serializable> getComplexPropertyIfNotNull(Serializable property) {
        if (property != null) {
            if (!this.isComplexType(property)) {
                throw new NuxeoException("Tryed to get a complex property from a Serializable property that is not a map, this is inconsistent.");
            }
            return this.getComplexProperty(property);
        }
        return null;
    }

    protected final WidgetDefinition getWidgetDefinition(String category, String propertyName, String propertyType, Field field, List<DiffFieldItemDefinition> complexFieldItemDefs, boolean isContentDiffLinksWidget) {
        boolean isGeneric = false;
        boolean isCloned = false;
        WidgetDefinition wDef = null;
        if (!isContentDiffLinksWidget) {
            wDef = this.getLayoutStore().getWidgetDefinition(category, propertyName);
            if (wDef == null) {
                isGeneric = true;
                wDef = this.getLayoutStore().getWidgetDefinition(category, propertyType);
                if (wDef == null) {
                    throw new NuxeoException(String.format("Could not find any specific widget named '%s', nor any generic widget named '%s'. Please make sure at least a generic widget is defined for this type.", propertyName, propertyType));
                }
            }
        } else {
            isGeneric = true;
            if (PropertyType.isSimpleType((String)propertyType) || PropertyType.isContentType((String)propertyType)) {
                wDef = this.getLayoutStore().getWidgetDefinition(category, CONTENT_DIFF_LINKS_WIDGET_NAME);
                if (wDef == null) {
                    throw new NuxeoException(String.format("Could not find any generic widget named '%s'. Please make sure a generic widget is defined with this name.", CONTENT_DIFF_LINKS_WIDGET_NAME));
                }
            } else {
                wDef = this.getLayoutStore().getWidgetDefinition(category, propertyType);
                if (wDef == null) {
                    throw new NuxeoException(String.format("Could not find any generic widget named '%s'. Please make sure a generic widget is defined for this type.", propertyType));
                }
            }
        }
        if (isGeneric) {
            wDef = wDef.clone();
            isCloned = true;
            String widgetName = propertyName;
            if (isContentDiffLinksWidget) {
                widgetName = widgetName + CONTENT_DIFF_LINKS_WIDGET_NAME_SUFFIX;
            }
            wDef.setName(widgetName);
            HashMap<String, String> labels = new HashMap<String, String>();
            labels.put("any", DIFF_WIDGET_LABEL_PREFIX + this.getPropertyLabel(propertyName));
            wDef.setLabels(labels);
            wDef.setTranslated(true);
        }
        if (isGeneric || !this.isFieldDefinitions(wDef)) {
            FieldDefinition[] fieldDefinitions;
            String fieldName = propertyName;
            if (field != null) {
                fieldName = field.getName().getLocalName();
            }
            if (isContentDiffLinksWidget) {
                fieldDefinitions = new FieldDefinition[]{new FieldDefinitionImpl(null, this.getFieldDefinition(fieldName, "value")), new FieldDefinitionImpl(null, this.getFieldDefinition(fieldName, DIFF_WIDGET_FIELD_DEFINITION_DIFFERENCE_TYPE)), new FieldDefinitionImpl(null, this.getFieldDefinition(fieldName, DIFF_WIDGET_FIELD_DEFINITION_DISPLAY_HTML_CONVERSION)), new FieldDefinitionImpl(null, this.getFieldDefinition(fieldName, DIFF_WIDGET_FIELD_DEFINITION_DISPLAY_TEXT_CONVERSION))};
            } else {
                int fieldCount = 2;
                if (PropertyType.isContentType((String)propertyType) || "note:note".equals(propertyName)) {
                    fieldCount = 3;
                }
                fieldDefinitions = new FieldDefinition[fieldCount];
                fieldDefinitions[0] = new FieldDefinitionImpl(null, this.getFieldDefinition(fieldName, "value"));
                FieldDefinitionImpl styleClassFieldDef = new FieldDefinitionImpl(null, this.getFieldDefinition(fieldName, DIFF_WIDGET_FIELD_DEFINITION_STYLE_CLASS));
                if (PropertyType.isContentType((String)propertyType)) {
                    fieldDefinitions[1] = new FieldDefinitionImpl(null, this.getFieldDefinition(this.getFieldDefinition(fieldName, "value"), DIFF_WIDGET_FIELD_DEFINITION_FILENAME));
                    fieldDefinitions[2] = styleClassFieldDef;
                } else if ("note:note".equals(propertyName)) {
                    fieldDefinitions[1] = new FieldDefinitionImpl(null, this.getFieldDefinition("note:mime_type", "value"));
                    fieldDefinitions[2] = styleClassFieldDef;
                } else {
                    fieldDefinitions[1] = styleClassFieldDef;
                }
            }
            if (!isCloned) {
                wDef = wDef.clone();
                isCloned = true;
            }
            wDef.setFieldDefinitions(fieldDefinitions);
        }
        if (!this.isSubWidgets(wDef) && (PropertyType.isListType((String)propertyType) || PropertyType.isComplexType((String)propertyType))) {
            Field declaringField = field;
            if (declaringField == null) {
                declaringField = ComplexPropertyHelper.getField(this.getPropertySchema(propertyName), this.getPropertyField(propertyName));
            }
            if (!isCloned) {
                wDef = wDef.clone();
                isCloned = true;
            }
            wDef.setSubWidgetDefinitions(this.getSubWidgetDefinitions(category, propertyName, propertyType, declaringField, complexFieldItemDefs, this.isDisplayItemIndexes(wDef), isContentDiffLinksWidget));
        }
        return wDef;
    }

    protected final boolean isSubWidgets(WidgetDefinition wDef) {
        WidgetDefinition[] subWidgetDefs = wDef.getSubWidgetDefinitions();
        return subWidgetDefs != null && subWidgetDefs.length > 0;
    }

    protected final boolean isFieldDefinitions(WidgetDefinition wDef) {
        FieldDefinition[] fieldDefs = wDef.getFieldDefinitions();
        return fieldDefs != null && fieldDefs.length > 0;
    }

    protected final String getFieldDefinition(String fieldName, String subPropertyName) {
        return fieldName + "/" + subPropertyName;
    }

    protected final WidgetDefinition[] getSubWidgetDefinitions(String category, String propertyName, String propertyType, Field field, List<DiffFieldItemDefinition> complexFieldItemDefs, boolean isDisplayItemIndexes, boolean isContentDiffLinks) {
        WidgetDefinition[] subWidgetDefs = null;
        if (PropertyType.isComplexType((String)propertyType)) {
            subWidgetDefs = this.getComplexSubWidgetDefinitions(category, propertyName, field, complexFieldItemDefs, false, isContentDiffLinks);
        } else if (PropertyType.isScalarListType((String)propertyType) || PropertyType.isContentListType((String)propertyType)) {
            Field listFieldItem = ComplexPropertyHelper.getListFieldItem(field);
            subWidgetDefs = this.initSubWidgetDefinitions(isDisplayItemIndexes, 1);
            subWidgetDefs[subWidgetDefs.length - 1] = this.getWidgetDefinition(category, this.getSubPropertyFullName(propertyName, listFieldItem.getName().getLocalName()), ComplexPropertyHelper.getFieldType(listFieldItem), (Field)new FieldImpl(new QName("value"), field.getType(), listFieldItem.getType()), null, isContentDiffLinks);
        } else if (PropertyType.isComplexListType((String)propertyType)) {
            Field listFieldItem = ComplexPropertyHelper.getListFieldItem(field);
            subWidgetDefs = this.getComplexSubWidgetDefinitions(category, propertyName, listFieldItem, complexFieldItemDefs, isDisplayItemIndexes, isContentDiffLinks);
        }
        return subWidgetDefs;
    }

    protected final WidgetDefinition[] getComplexSubWidgetDefinitions(String category, String propertyName, Field field, List<DiffFieldItemDefinition> complexFieldItemDefs, boolean isDisplayItemIndexes, boolean isContentDiffLinks) {
        WidgetDefinition[] subWidgetDefs;
        int subWidgetIndex;
        int n = subWidgetIndex = isDisplayItemIndexes ? 1 : 0;
        if (CollectionUtils.isEmpty(complexFieldItemDefs)) {
            List<Field> complexFieldItems = ComplexPropertyHelper.getComplexFieldItems(field);
            subWidgetDefs = this.initSubWidgetDefinitions(isDisplayItemIndexes, complexFieldItems.size());
            for (Field complexFieldItem : complexFieldItems) {
                subWidgetDefs[subWidgetIndex] = this.getWidgetDefinition(category, this.getSubPropertyFullName(propertyName, complexFieldItem.getName().getLocalName()), ComplexPropertyHelper.getFieldType(complexFieldItem), complexFieldItem, null, isContentDiffLinks);
                ++subWidgetIndex;
            }
        } else {
            int subWidgetCount = complexFieldItemDefs.size();
            if (isContentDiffLinks) {
                subWidgetCount = 0;
                for (DiffFieldItemDefinition complexFieldItemDef : complexFieldItemDefs) {
                    if (!complexFieldItemDef.isDisplayContentDiffLinks()) continue;
                    ++subWidgetCount;
                }
            }
            subWidgetDefs = this.initSubWidgetDefinitions(isDisplayItemIndexes, subWidgetCount);
            for (DiffFieldItemDefinition complexFieldItemDef : complexFieldItemDefs) {
                String complexFieldItemName;
                Field complexFieldItem;
                if (isContentDiffLinks && !complexFieldItemDef.isDisplayContentDiffLinks() || (complexFieldItem = ComplexPropertyHelper.getComplexFieldItem(field, complexFieldItemName = complexFieldItemDef.getName())) == null) continue;
                subWidgetDefs[subWidgetIndex] = this.getWidgetDefinition(category, this.getSubPropertyFullName(propertyName, complexFieldItemName), ComplexPropertyHelper.getFieldType(complexFieldItem), complexFieldItem, null, isContentDiffLinks);
                ++subWidgetIndex;
            }
        }
        return subWidgetDefs;
    }

    protected final WidgetDefinition[] initSubWidgetDefinitions(boolean isDisplayItemIndexes, int subWidgetCount) {
        WidgetDefinition[] subWidgetDefs;
        if (isDisplayItemIndexes) {
            subWidgetDefs = new WidgetDefinition[subWidgetCount + 1];
            subWidgetDefs[0] = this.getIndexSubwidgetDefinition();
        } else {
            subWidgetDefs = new WidgetDefinition[subWidgetCount];
        }
        return subWidgetDefs;
    }

    protected final WidgetDefinition getIndexSubwidgetDefinition() {
        FieldDefinition[] fieldDefinitions = new FieldDefinition[]{new FieldDefinitionImpl(null, DIFF_LIST_WIDGET_INDEX_SUBWIDGET_FIELD)};
        return new WidgetDefinitionImpl(DIFF_LIST_WIDGET_INDEX_SUBWIDGET_FIELD, DIFF_LIST_WIDGET_INDEX_SUBWIDGET_TYPE, DIFF_LIST_WIDGET_INDEX_SUBWIDGET_LABEL, null, true, null, Arrays.asList(fieldDefinitions), null, null);
    }

    protected final String getPropertyName(String schema, String field) {
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty((String)schema)) {
            sb.append(schema);
            sb.append(":");
        }
        sb.append(field);
        return sb.toString();
    }

    protected final String getSubPropertyFullName(String basePropertyName, String subPropertyName) {
        if (StringUtils.isEmpty((String)subPropertyName)) {
            return basePropertyName;
        }
        StringBuilder sb = new StringBuilder(basePropertyName);
        sb.append("/");
        sb.append(subPropertyName);
        return sb.toString();
    }

    protected final String getPropertySchema(String propertyName) {
        int indexOfColon = propertyName.indexOf(58);
        if (indexOfColon > -1) {
            return propertyName.substring(0, indexOfColon);
        }
        return null;
    }

    protected final String getPropertyField(String propertyName) {
        int indexOfColon = propertyName.indexOf(58);
        if (indexOfColon > -1 && indexOfColon < propertyName.length() - 1) {
            return propertyName.substring(indexOfColon + 1);
        }
        return propertyName;
    }

    protected final String getPropertyLabel(String propertyName) {
        return propertyName.replaceAll(":", ".").replaceAll("/", ".");
    }

    protected final SchemaManager getSchemaManager() {
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        if (schemaManager == null) {
            throw new NuxeoException("SchemaManager service is null.");
        }
        return schemaManager;
    }

    protected final LayoutStore getLayoutStore() {
        LayoutStore layoutStore = (LayoutStore)Framework.getService(LayoutStore.class);
        if (layoutStore == null) {
            throw new NuxeoException("LayoutStore service is null.");
        }
        return layoutStore;
    }
}

