/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets.plugins;

import com.sun.faces.facelets.tag.TagAttributesImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.CompositeFaceletHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributes;
import javax.faces.view.facelets.TagConfig;
import org.nuxeo.ecm.platform.forms.layout.api.BuiltinWidgetModes;
import org.nuxeo.ecm.platform.forms.layout.api.FieldDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;
import org.nuxeo.ecm.platform.forms.layout.api.exceptions.WidgetException;
import org.nuxeo.ecm.platform.forms.layout.facelets.FaceletHandlerHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.ValueExpressionHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.plugins.AbstractWidgetTypeHandler;
import org.nuxeo.ecm.platform.ui.web.component.seam.UIHtmlText;

public class CheckboxWidgetTypeHandler
extends AbstractWidgetTypeHandler {
    public CheckboxWidgetTypeHandler(TagConfig config) {
        super(config);
    }

    @Override
    public void apply(FaceletContext ctx, UIComponent parent, Widget widget) throws WidgetException, IOException {
        FaceletHandlerHelper helper = new FaceletHandlerHelper(this.tagConfig);
        String mode = widget.getMode();
        String widgetId = widget.getId();
        String widgetName = widget.getName();
        String widgetTagConfigId = widget.getTagConfigId();
        FaceletHandler leaf = this.getNextHandler(ctx, this.tagConfig, widget, null, helper);
        if ("edit".equals(mode)) {
            TagAttributes attributes = helper.getTagAttributes(widgetId, widget);
            ComponentHandler input = helper.getHtmlComponentHandler(widgetTagConfigId, attributes, leaf, "javax.faces.HtmlSelectBooleanCheckbox", "javax.faces.NXCheckbox");
            String msgId = FaceletHandlerHelper.generateMessageId(ctx, widgetName);
            ComponentHandler message = helper.getMessageComponentHandler(widgetTagConfigId, msgId, widgetId, null);
            FaceletHandler[] handlers = new FaceletHandler[]{input, message};
            CompositeFaceletHandler h = new CompositeFaceletHandler(handlers);
            h.apply(ctx, parent);
        } else {
            TagAttributes attributes = this.getViewTagAttributes(ctx, helper, widgetId, widget, !BuiltinWidgetModes.isLikePlainMode((String)mode));
            ComponentHandler output = helper.getHtmlComponentHandler(widgetTagConfigId, attributes, leaf, "javax.faces.HtmlOutputText", null);
            if ("pdf".equals(mode)) {
                ComponentHandler h = helper.getHtmlComponentHandler(widgetTagConfigId, (TagAttributes)new TagAttributesImpl(new TagAttribute[0]), (FaceletHandler)output, UIHtmlText.class.getName(), null);
                h.apply(ctx, parent);
            } else {
                output.apply(ctx, parent);
            }
        }
    }

    protected TagAttributes getViewTagAttributes(FaceletContext ctx, FaceletHandlerHelper helper, String id, Widget widget, boolean addId) {
        List<TagAttribute> propertyAttrs;
        ArrayList<TagAttribute> attrs = new ArrayList<TagAttribute>();
        FieldDefinition[] fields = widget.getFieldDefinitions();
        if (fields != null && fields.length > 0) {
            FieldDefinition field = fields[0];
            String bareExpression = ValueExpressionHelper.createBareExpressionString(widget.getValueName(), field);
            String bundleName = ctx.getFacesContext().getApplication().getMessageBundle();
            String messageYes = bundleName + "['label.yes']";
            String messageNo = bundleName + "['label.no']";
            String expression = "#{" + bareExpression + " ? " + messageYes + " : " + messageNo + "}";
            TagAttribute valueAttr = helper.createAttribute("value", expression);
            attrs.add(valueAttr);
        }
        if ((propertyAttrs = helper.getTagAttributes(widget.getProperties(), null, true, widget.getType(), widget.getTypeCategory(), widget.getMode())) != null) {
            attrs.addAll(propertyAttrs);
        }
        TagAttributes widgetAttrs = FaceletHandlerHelper.getTagAttributes(attrs);
        if (!addId) {
            return widgetAttrs;
        }
        return FaceletHandlerHelper.addTagAttribute(widgetAttrs, helper.createAttribute("id", id));
    }
}

