/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.web.resources.jsf.component;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.theme.styling.service.descriptors.IconDescriptor;

public class UIFavicon
extends UIComponentBase {
    public static final String COMPONENT_TYPE = UIFavicon.class.getName();
    protected static Map<String, String> iconsMime = new HashMap<String, String>();

    public String getFamily() {
        return "javax.faces.Output";
    }

    public IconDescriptor getValue() {
        return (IconDescriptor)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.value));
    }

    public void setValue(IconDescriptor value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.value), (Object)value);
    }

    public String getName() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.name));
    }

    public void setName(String name) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.name), (Object)name);
    }

    public String getSrc() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.src));
    }

    public void setSrc(String src) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.src), (Object)src);
    }

    public String getMimetype() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.mimetype));
    }

    public void setMimetype(String mimetype) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.mimetype), (Object)mimetype);
    }

    public String getSizes() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sizes));
    }

    public void setSizes(String sizes) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sizes), (Object)sizes);
    }

    public String getRendererType() {
        return null;
    }

    public void encodeEnd(FacesContext context) throws IOException {
        String sizes;
        String name;
        String src;
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            this.popComponentFromEL(context);
            return;
        }
        String mt = null;
        IconDescriptor icon = this.getValue();
        if (icon != null) {
            src = icon.getValue();
            name = icon.getName();
            sizes = icon.getSizes();
        } else {
            src = this.getSrc();
            mt = this.getMimetype();
            name = this.getName();
            sizes = this.getSizes();
        }
        if (StringUtils.isBlank((String)mt)) {
            mt = UIFavicon.getMimetype(src);
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("link", (UIComponent)this);
        writer.writeAttribute("rel", (Object)name, "rel");
        writer.writeAttribute("type", (Object)mt, "rel");
        String encodedSrc = context.getApplication().getViewHandler().getResourceURL(context, src);
        writer.writeURIAttribute("href", (Object)encodedSrc, "href");
        if (StringUtils.isBlank((String)sizes)) {
            writer.writeAttribute("sizes", (Object)sizes, "sizes");
        }
        writer.endElement("link");
        this.popComponentFromEL(context);
    }

    protected static String getMimetype(String ico) {
        String mt = null;
        if (iconsMime.containsKey(ico)) {
            mt = iconsMime.get(ico);
        } else {
            mt = UIFavicon.resolveMimetype(ico);
            if (!Framework.isDevModeSet()) {
                iconsMime.put(ico, mt);
            }
        }
        return mt;
    }

    protected static String resolveMimetype(String ico) {
        int index = ico.lastIndexOf(".");
        if (index > 0) {
            String ext;
            switch (ext = ico.substring(1 + index)) {
                case "gif": {
                    return "image/gif";
                }
                case "png": {
                    return "image/png";
                }
            }
        }
        return "image/x-icon";
    }

    public static enum PropertyKeys {
        value,
        name,
        src,
        mimetype,
        sizes;

    }
}

