/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.context;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;

@Name(value="transientStateCleaner")
@Scope(value=ScopeType.EVENT)
@Install(precedence=10)
public class TransientStateCleaner
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true, required=false)
    protected transient NavigationContext navigationContext;
    protected static final Log log = LogFactory.getLog(TransientStateCleaner.class);

    @Observer(value={"currentTabChanged"}, create=true)
    public void flushTransientStateIfNeeded() {
        CoreSession documentManager;
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument != null && currentDocument.isDirty() && (documentManager = (CoreSession)Component.getInstance((String)"documentManager", (boolean)false)) != null) {
            try {
                currentDocument = documentManager.getDocument(currentDocument.getRef());
                this.navigationContext.setCurrentDocument(null);
                this.navigationContext.setCurrentDocument(currentDocument);
            }
            catch (DocumentNotFoundException e) {
                log.error((Object)"Error during reset of transient state", (Throwable)e);
            }
        }
    }
}

