/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.tag.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.binding.BlockingVariableMapper;
import org.nuxeo.ecm.platform.ui.web.binding.MetaValueExpression;
import org.nuxeo.ecm.platform.ui.web.binding.alias.AliasTagHandler;
import org.nuxeo.ecm.platform.ui.web.binding.alias.AliasVariableMapper;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;
import org.nuxeo.ecm.platform.ui.web.util.FaceletDebugTracer;

public class SetTagHandler
extends AliasTagHandler {
    private static final Log log = LogFactory.getLog(SetTagHandler.class);
    protected final TagAttribute var = this.getRequiredAttribute("var");
    protected final TagAttribute value = this.getAttribute("value");
    protected final TagAttribute resolveTwice = this.getAttribute("resolveTwice");
    protected final TagAttribute blockPatterns = this.getAttribute("blockPatterns");
    protected final TagAttribute blockMerge = this.getAttribute("blockMerge");
    protected final TagAttribute local = this.getAttribute("local");
    protected final TagAttribute useAlias = this.getAttribute("useAlias");

    public SetTagHandler(ComponentConfig config) {
        super(config, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        block10: {
            long start = FaceletDebugTracer.start();
            String varStr = null;
            try {
                if (parent == null) {
                    throw new TagException(this.tag, "Parent UIComponent was null");
                }
                boolean useAliasBool = false;
                if (this.useAlias != null) {
                    useAliasBool = this.useAlias.getBoolean(ctx);
                }
                if (!useAliasBool && this.isOptimizedAgain()) {
                    FaceletHandler next;
                    BlockingVariableMapper vm;
                    varStr = this.var.getValue(ctx);
                    VariableMapper orig = ctx.getVariableMapper();
                    boolean done = false;
                    if (orig instanceof BlockingVariableMapper && this.isAcceptingMerge(ctx, vm = (BlockingVariableMapper)orig, varStr)) {
                        next = this.applyOptimized(ctx, parent, vm, varStr);
                        next.apply(ctx, parent);
                        done = true;
                    }
                    if (done) break block10;
                    try {
                        vm = new BlockingVariableMapper(orig);
                        ctx.setVariableMapper((VariableMapper)vm);
                        next = this.applyOptimized(ctx, parent, vm, varStr);
                        next.apply(ctx, parent);
                        break block10;
                    }
                    finally {
                        ctx.setVariableMapper(orig);
                    }
                }
                this.applyAlias(ctx, parent);
            }
            finally {
                FaceletDebugTracer.trace(start, this.getTag(), this.var.getValue());
            }
        }
    }

    public FaceletHandler getNextHandler() {
        return this.nextHandler;
    }

    public boolean isAcceptingMerge(FaceletContext ctx, BlockingVariableMapper vm, String var) {
        if (vm.hasVariable(var)) {
            return false;
        }
        return this.isAcceptingMerge(ctx);
    }

    public boolean isAcceptingMerge(FaceletContext ctx) {
        String blocked;
        if (this.useAlias != null && this.useAlias.getBoolean(ctx)) {
            return false;
        }
        if (this.blockMerge != null && this.blockMerge.getBoolean(ctx)) {
            return false;
        }
        return this.blockPatterns == null || StringUtils.isEmpty((String)(blocked = this.blockPatterns.getValue(ctx)));
    }

    public FaceletHandler applyOptimized(FaceletContext ctx, UIComponent parent, BlockingVariableMapper vm) throws IOException {
        String varStr = this.var.getValue(ctx);
        return this.applyOptimized(ctx, parent, vm, varStr);
    }

    public FaceletHandler applyOptimized(FaceletContext ctx, UIComponent parent, BlockingVariableMapper vm, String varStr) throws IOException {
        SetTagHandler next;
        FaceletHandler nextHandler;
        String blockedValue;
        ValueExpression ve;
        boolean cacheValue = false;
        if (this.cache != null) {
            cacheValue = this.cache.getBoolean(ctx);
        }
        boolean resolveTwiceBool = false;
        if (this.resolveTwice != null) {
            resolveTwiceBool = this.resolveTwice.getBoolean(ctx);
        }
        if (cacheValue) {
            Object res = this.value.getObject(ctx);
            if (resolveTwiceBool && res instanceof String && ComponentTagUtils.isValueReference((String)res)) {
                ve = ctx.getExpressionFactory().createValueExpression((ELContext)ctx, (String)res, Object.class);
                res = ve.getValue((ELContext)ctx);
            }
            ve = ctx.getExpressionFactory().createValueExpression(res, Object.class);
        } else {
            ve = this.value.getValueExpression(ctx, Object.class);
            if (resolveTwiceBool) {
                boolean localBool = false;
                if (this.local != null) {
                    localBool = this.local.getBoolean(ctx);
                }
                ve = localBool ? new MetaValueExpression(ve) : new MetaValueExpression(ve, ctx.getFunctionMapper(), vm);
            }
        }
        vm.setVariable(varStr, ve);
        if (this.blockPatterns != null && !StringUtils.isEmpty((String)(blockedValue = this.blockPatterns.getValue(ctx)))) {
            vm.setBlockedPatterns(this.resolveBlockPatterns(blockedValue));
        }
        if ((nextHandler = this.nextHandler) instanceof SetTagHandler && (next = (SetTagHandler)nextHandler).isAcceptingMerge(ctx)) {
            nextHandler = next.applyOptimized(ctx, parent, vm);
        }
        return nextHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyAlias(FaceletContext ctx, UIComponent parent) throws IOException {
        FaceletHandler nextHandler = this.nextHandler;
        VariableMapper orig = ctx.getVariableMapper();
        AliasVariableMapper target = new AliasVariableMapper();
        target.setId(ctx.generateUniqueId(this.tagId));
        VariableMapper vm = target.getVariableMapperForBuild(orig);
        ctx.setVariableMapper(vm);
        try {
            nextHandler = this.getAliasVariableMapper(ctx, target);
        }
        finally {
            ctx.setVariableMapper(orig);
        }
        this.applyAliasHandler(ctx, parent, target, nextHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FaceletHandler getAliasVariableMapper(FaceletContext ctx, AliasVariableMapper target) {
        SetTagHandler next;
        FaceletHandler nextHandler;
        String blockedValue;
        ValueExpression ve;
        String varStr = this.var.getValue(ctx);
        if (target.hasVariables(varStr)) {
            return this.nextHandler;
        }
        boolean cacheValue = false;
        if (this.cache != null) {
            cacheValue = this.cache.getBoolean(ctx);
        }
        boolean resolveTwiceBool = false;
        if (this.resolveTwice != null) {
            resolveTwiceBool = this.resolveTwice.getBoolean(ctx);
        }
        if (cacheValue) {
            Object res = this.value.getObject(ctx);
            if (resolveTwiceBool && res instanceof String && ComponentTagUtils.isValueReference((String)res)) {
                ve = ctx.getExpressionFactory().createValueExpression((ELContext)ctx, (String)res, Object.class);
                res = ve.getValue((ELContext)ctx);
            }
            ve = ctx.getExpressionFactory().createValueExpression(res, Object.class);
        } else {
            ve = this.value.getValueExpression(ctx, Object.class);
            if (resolveTwiceBool) {
                boolean localBool = false;
                if (this.local != null) {
                    localBool = this.local.getBoolean(ctx);
                }
                ve = localBool ? new MetaValueExpression(ve) : new MetaValueExpression(ve, ctx.getFunctionMapper(), ctx.getVariableMapper());
            }
        }
        target.setVariable(varStr, ve);
        if (this.blockPatterns != null && !StringUtils.isEmpty((String)(blockedValue = this.blockPatterns.getValue(ctx)))) {
            target.setBlockedPatterns(this.resolveBlockPatterns(blockedValue));
        }
        if ((nextHandler = this.nextHandler) instanceof SetTagHandler && (next = (SetTagHandler)nextHandler).isAcceptingMerge(ctx)) {
            ctx.getVariableMapper().setVariable(varStr, ve);
            try {
                AliasVariableMapper.exposeAliasesToRequest(ctx.getFacesContext(), target);
                nextHandler = next.getAliasVariableMapper(ctx, target);
            }
            finally {
                AliasVariableMapper.removeAliasesExposedToRequest(ctx.getFacesContext(), target.getId());
            }
        }
        return nextHandler;
    }

    protected List<String> resolveBlockPatterns(String value) {
        String[] split;
        ArrayList<String> res = new ArrayList<String>();
        if (value != null && (split = StringUtils.split((String)value, (char)',')) != null) {
            for (String item : split) {
                res.add(item.trim());
            }
        }
        return res;
    }
}

