/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.forms.layout.facelets.FaceletHandlerHelper;

public class NuxeoLayoutIdManagerBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "nuxeoLayoutIdManager";
    private static final Log log = LogFactory.getLog(NuxeoLayoutIdManagerBean.class);
    protected Map<String, State> ids;

    public String generateUniqueId(String base) {
        String res;
        String bareBase = FaceletHandlerHelper.stripUniqueIdBase(FaceletHandlerHelper.generateValidIdString(base));
        Integer count = 0;
        if (this.ids != null && this.ids.containsKey(bareBase)) {
            State state = this.ids.get(bareBase);
            count = state.getCounter() + 1;
            this.setCounter(bareBase, count);
            res = bareBase + "_" + count;
        } else {
            res = bareBase;
            this.setCounter(bareBase, count);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Computed id='%s' for base='%s'", res, bareBase));
        }
        return res;
    }

    public Map<String, State> getIds() {
        return Collections.unmodifiableMap(this.ids);
    }

    public void resetIds() {
        this.ids = null;
    }

    protected void setCounter(String id, Integer count) {
        State state;
        if (this.ids == null) {
            this.ids = new HashMap<String, State>();
        }
        if (this.ids.containsKey(id)) {
            state = this.ids.get(id);
        } else {
            state = new State();
            this.ids.put(id, state);
        }
        state.setCounter(count);
    }

    private static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected Integer counter;

        private State() {
        }

        public Integer getCounter() {
            return this.counter;
        }

        public void setCounter(Integer counter) {
            this.counter = counter;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("State");
            buf.append(" {");
            buf.append(" counter=");
            buf.append(this.counter);
            buf.append('}');
            return buf.toString();
        }
    }
}

