/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.widgets;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;

@Name(value="dateRangeValidator")
@Scope(value=ScopeType.CONVERSATION)
public class DateRangeValidator
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true)
    protected Map<String, String> messages;
    private static final Log log = LogFactory.getLog(DateRangeValidator.class);

    public void validateDateRange(FacesContext context, UIComponent component, Object value) {
        Map attributes = component.getAttributes();
        String startDateComponentId = (String)attributes.get("startDateComponentId");
        String endDateComponentId = (String)attributes.get("endDateComponentId");
        if (startDateComponentId == null || endDateComponentId == null) {
            return;
        }
        UIInput startDateComp = (UIInput)component.findComponent(startDateComponentId);
        UIInput endDateComp = (UIInput)component.findComponent(endDateComponentId);
        if (startDateComp == null) {
            log.error((Object)("Can not find component with id " + startDateComponentId));
            return;
        }
        if (endDateComp == null) {
            log.error((Object)("Can not find component with id " + endDateComponentId));
            return;
        }
        Date stratDate = (Date)startDateComp.getLocalValue();
        Date endDate = (Date)endDateComp.getLocalValue();
        if (stratDate != null && endDate != null && endDate.compareTo(stratDate) < 0) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, String.format(this.messages.get("error.dateRangeValidator.invalidDateRange"), stratDate, endDate), null);
            throw new ValidatorException(message);
        }
    }
}

