/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model;

import java.io.IOException;
import org.richfaces.json.JSONArray;
import org.richfaces.json.JSONObject;
import org.richfaces.model.ChartDataModel;
import org.richfaces.model.ChartStrategy;
import org.richfaces.renderkit.ChartRendererBase;

public class BarStrategy
implements ChartStrategy {
    @Override
    public Object export(ChartDataModel model) throws IOException {
        JSONObject obj = model.defaultExport();
        JSONObject bars = new JSONObject();
        ChartRendererBase.addAttribute(bars, "show", true);
        ChartRendererBase.addAttribute(bars, "barWidth", this.calculateBarWidth(obj));
        ChartRendererBase.addAttribute(obj, "bars", bars);
        return obj;
    }

    private double calculateBarWidth(JSONObject o) {
        JSONArray last;
        JSONArray data = o.optJSONArray("data");
        if (data != null && (last = data.optJSONArray(data.length() - 1)) != null) {
            return 1.0 / ((double)data.length() / last.optDouble(0) + 1.0);
        }
        return 1.0;
    }
}

