/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.directory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.platform.ui.web.directory.ChainSelect;
import org.nuxeo.ecm.platform.ui.web.directory.DirectoryHelper;
import org.nuxeo.ecm.platform.ui.web.directory.DirectorySelectItem;
import org.nuxeo.ecm.platform.ui.web.directory.Selection;

public class ChainSelectOutputComponent
extends UIOutput {
    public static final String COMPONENT_TYPE = "nxdirectory.ChainSelectOutput";
    public static final String COMPONENT_FAMILY = "nxdirectory.ChainSelectOutput";
    private static final Log log = LogFactory.getLog(ChainSelect.class);
    private static final String DISPLAY_ID_AND_LABEL_SEPARATOR = " ";
    private static final String DEFAULT_ENTRY_SEPARATOR = ", ";
    protected Boolean displayIdAndLabel;
    protected Boolean localize;
    protected String display;
    protected String directoryNameList;
    protected Boolean displayObsoleteEntries;
    protected String keySeparator;
    protected String displayKeySeparator;
    protected Boolean qualifiedParentKeys;
    protected Boolean handleMultipleValues = false;
    private String entrySeparator;
    private String cssStyle;
    private String cssStyleClass;

    public ChainSelectOutputComponent() {
        this.setRendererType("nxdirectory.ChainSelectOutput");
    }

    public String getFamily() {
        return "nxdirectory.ChainSelectOutput";
    }

    public String getKeySeparator() {
        String ret = null;
        ValueBinding vb = this.getValueBinding("keySeparator");
        ret = vb != null ? (String)vb.getValue(this.getFacesContext()) : this.keySeparator;
        if (ret == null) {
            ret = "/";
        }
        return ret;
    }

    public void setDisplayKeySeparator(String keySeparator) {
        this.displayKeySeparator = keySeparator;
    }

    public String getDisplayKeySeparator() {
        String ret = null;
        ValueBinding vb = this.getValueBinding("displayKeySeparator");
        ret = vb != null ? (String)vb.getValue(this.getFacesContext()) : this.displayKeySeparator;
        if (ret == null) {
            ret = this.getKeySeparator();
        }
        return ret;
    }

    public void setKeySeparator(String keySeparator) {
        this.keySeparator = keySeparator;
    }

    public boolean getQualifiedParentKeys() {
        Boolean ret = null;
        ValueBinding vb = this.getValueBinding("qualifiedParentKeys");
        ret = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : this.qualifiedParentKeys;
        return Boolean.TRUE.equals(ret);
    }

    public boolean getHandleMultipleValues() {
        Boolean ret = null;
        ValueBinding vb = this.getValueBinding("handleMultipleValues");
        ret = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : this.handleMultipleValues;
        return Boolean.TRUE.equals(ret);
    }

    public void setHandleMultipleValues(boolean handleMultipleValues) {
        this.handleMultipleValues = handleMultipleValues;
    }

    public void setQualifiedParentKeys(boolean qualifiedParentKeys) {
        this.qualifiedParentKeys = qualifiedParentKeys;
    }

    @Deprecated
    public boolean getDisplayIdAndLabel() {
        ValueBinding vb = this.getValueBinding("displayIdAndLabel");
        Boolean ret = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : this.displayIdAndLabel;
        return Boolean.TRUE.equals(ret);
    }

    public void setDisplayIdAndLabel(boolean displayIdAndLabel) {
        this.displayIdAndLabel = displayIdAndLabel;
    }

    public boolean getLocalize() {
        return Boolean.TRUE.equals(this.localize);
    }

    public void setLocalize(boolean localize) {
        this.localize = localize;
    }

    public String getDisplay() {
        ValueBinding vb = this.getValueBinding("display");
        String ret = vb != null ? (String)vb.getValue(this.getFacesContext()) : this.display;
        if (ret == null) {
            boolean displayIdAndLabel = this.getDisplayIdAndLabel();
            ret = displayIdAndLabel ? "idAndLabel" : "label";
        }
        return ret;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.displayIdAndLabel, this.localize, this.display, this.displayObsoleteEntries, this.directoryNameList, this.qualifiedParentKeys, this.keySeparator, this.cssStyle, this.cssStyleClass, this.entrySeparator, this.handleMultipleValues};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.displayIdAndLabel = (Boolean)values[1];
        this.localize = (Boolean)values[2];
        this.display = (String)values[3];
        this.displayObsoleteEntries = (Boolean)values[4];
        this.directoryNameList = (String)values[5];
        this.qualifiedParentKeys = (Boolean)values[6];
        this.keySeparator = (String)values[7];
        this.cssStyle = (String)values[8];
        this.cssStyleClass = (String)values[9];
        this.entrySeparator = (String)values[10];
        this.handleMultipleValues = (Boolean)values[11];
    }

    public boolean getDisplayObsoleteEntries() {
        return Boolean.TRUE.equals(this.displayObsoleteEntries);
    }

    public Selection createSelection(String keyEnum) {
        int i;
        String keySeparator = this.getKeySeparator();
        String[] columns = StringUtils.split((String)keyEnum, (String)keySeparator);
        ArrayList<String> keyList = new ArrayList<String>();
        ArrayList<DirectorySelectItem> itemList = new ArrayList<DirectorySelectItem>();
        String directoryNameList = this.getDirectoryNameList();
        String[] directoryNames = StringUtils.split((String)directoryNameList, (String)",");
        boolean qualifiedParentKeys = this.getQualifiedParentKeys();
        boolean displayObsoleteEntries = this.getDisplayObsoleteEntries();
        String display = this.getDisplay();
        for (i = 0; i < directoryNames.length; ++i) {
            directoryNames[i] = directoryNames[i].trim();
        }
        for (i = 0; i < columns.length; ++i) {
            DirectorySelectItem item;
            String id = columns[i];
            String directoryName = directoryNames[i];
            HashMap<String, Serializable> filter = new HashMap<String, Serializable>();
            filter.put("id", (Serializable)((Object)id));
            if (i == 0) {
                if (DirectoryHelper.instance().hasParentColumn(directoryName)) {
                    filter.put("parent", null);
                }
            } else {
                String parentId = qualifiedParentKeys ? StringUtils.join(keyList.iterator(), (String)keySeparator) : columns[i - 1];
                filter.put("parent", (Serializable)((Object)parentId));
            }
            keyList.add(id);
            if (!displayObsoleteEntries) {
                filter.put("obsolete", Integer.valueOf(0));
            }
            if ((item = DirectoryHelper.instance().getSelectItem(directoryName, filter)) == null) {
                item = new DirectorySelectItem(id, id);
            }
            String itemId = (String)item.getValue();
            String label = item.getLabel();
            if (this.getLocalize()) {
                label = ChainSelectOutputComponent.translate(this.getFacesContext(), label);
            }
            if ("id".equals(display)) {
                label = id;
            } else if ("idAndLabel".equals(display)) {
                label = itemId + DISPLAY_ID_AND_LABEL_SEPARATOR + label;
            }
            item.setLabel(label);
            itemList.add(item);
        }
        return new Selection(itemList.toArray(new DirectorySelectItem[columns.length]));
    }

    protected static String translate(FacesContext context, String label) {
        String bundleName = context.getApplication().getMessageBundle();
        Locale locale = context.getViewRoot().getLocale();
        label = I18NUtils.getMessageString((String)bundleName, (String)label, null, (Locale)locale);
        return label;
    }

    public String getEntrySeparator() {
        String ret = null;
        ValueBinding vb = this.getValueBinding("entrySeparator");
        ret = vb != null ? (String)vb.getValue(this.getFacesContext()) : this.entrySeparator;
        return this.entrySeparator == null ? DEFAULT_ENTRY_SEPARATOR : this.entrySeparator;
    }

    public void setEntrySeparator(String entrySeparator) {
        this.entrySeparator = entrySeparator;
    }

    public String getCssStyle() {
        return this.cssStyle;
    }

    public void setCssStyle(String cssStyle) {
        this.cssStyle = cssStyle;
    }

    public String getCssStyleClass() {
        return this.cssStyleClass;
    }

    public void setCssStyleClass(String cssStyleClass) {
        this.cssStyleClass = cssStyleClass;
    }

    public void setDisplayObsoleteEntries(Boolean displayObsoleteEntries) {
        this.displayObsoleteEntries = displayObsoleteEntries;
    }

    public void setDisplayObsoleteEntries(boolean displayObsoleteEntries) {
        this.displayObsoleteEntries = displayObsoleteEntries;
    }

    public void setQualifiedParentKeys(Boolean qualifiedParentKeys) {
        this.qualifiedParentKeys = qualifiedParentKeys;
    }

    public String getDirectoryNameList() {
        ValueBinding vb = this.getValueBinding("directoryNameList");
        String ret = vb != null ? (String)vb.getValue(this.getFacesContext()) : this.directoryNameList;
        return ret;
    }

    public void setDirectoryNameList(String directoryNameList) {
        this.directoryNameList = directoryNameList;
    }
}

