/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.contentbrowser;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.remoting.WebRemote;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.core.Events;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.core.api.validation.DocumentValidationException;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.blob.apps.AppLink;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.ui.web.api.UserAction;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.ui.web.tag.fn.Functions;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.codec.DocumentFileCodec;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.nuxeo.ecm.webapp.action.ActionContextProvider;
import org.nuxeo.ecm.webapp.action.DeleteActions;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.contentbrowser.DocumentActions;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.ecm.webapp.helpers.EventManager;
import org.nuxeo.runtime.api.Framework;

@Name(value="documentActions")
@Scope(value=ScopeType.CONVERSATION)
public class DocumentActionsBean
extends InputController
implements DocumentActions,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DocumentActionsBean.class);
    public static final String LIFE_CYCLE_TRANSITION_KEY = "lifeCycleTransition";
    public static final String BLOB_ACTIONS_CATEGORY = "BLOB_ACTIONS";
    @RequestParameter
    protected String fileFieldFullName;
    @RequestParameter
    protected String filenameFieldFullName;
    @RequestParameter
    protected String filename;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(required=false, create=true)
    protected transient DocumentsListsManager documentsListsManager;
    @In(create=true)
    protected transient DeleteActions deleteActions;
    @In(create=true, required=false)
    protected transient ActionContextProvider actionContextProvider;
    @RequestParameter
    protected Boolean restoreCurrentTabs;
    @In(create=true)
    protected transient WebActions webActions;
    protected String comment;
    @In(create=true)
    protected Map<String, String> messages;
    @RequestParameter
    protected String parentDocumentPath;

    @Factory(autoCreate=true, value="currentDocumentType", scope=ScopeType.EVENT)
    public Type getCurrentType() {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        if (doc == null) {
            return null;
        }
        return this.typeManager.getType(doc.getType());
    }

    public Type getChangeableDocumentType() {
        DocumentModel changeableDocument = this.navigationContext.getChangeableDocument();
        if (changeableDocument == null) {
            this.navigationContext.setChangeableDocument(this.navigationContext.getCurrentDocument());
            changeableDocument = this.navigationContext.getChangeableDocument();
        }
        if (changeableDocument == null) {
            return null;
        }
        return this.typeManager.getType(changeableDocument.getType());
    }

    public String getFileName(DocumentModel doc) {
        String name = null;
        if (this.filename != null && !"".equals(this.filename)) {
            name = this.filename;
        } else {
            if (this.filenameFieldFullName != null) {
                String[] s = this.filenameFieldFullName.split(":");
                try {
                    name = (String)doc.getProperty(s[0], s[1]);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            if (name == null || "".equals(name)) {
                name = (String)doc.getProperty("dublincore", "title");
            }
        }
        return name;
    }

    public void download(DocumentView docView) {
        DocumentModel doc;
        if (docView == null) {
            return;
        }
        DocumentLocation docLoc = docView.getDocumentLocation();
        if (this.documentManager == null) {
            RepositoryLocation loc = new RepositoryLocation(docLoc.getServerName());
            this.navigationContext.setCurrentServerLocation(loc);
            this.documentManager = this.navigationContext.getOrCreateDocumentManager();
        }
        if ((doc = this.documentManager.getDocument(docLoc.getDocRef())) == null) {
            return;
        }
        String xpath = docView.getParameter("FILE_PROPERTY_PATH");
        DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
        Blob blob = downloadService.resolveBlob(doc, xpath);
        if (blob == null) {
            log.warn((Object)("No blob for docView: " + docView));
            return;
        }
        String filename = DocumentFileCodec.getFilename((DocumentModel)doc, (DocumentView)docView);
        if (blob.getLength() > Functions.getBigFileSizeLimit()) {
            FacesContext context = FacesContext.getCurrentInstance();
            String bigDownloadURL = BaseURL.getBaseURL() + "/" + downloadService.getDownloadUrl(doc, xpath, filename);
            try {
                context.getExternalContext().redirect(bigDownloadURL);
            }
            catch (IOException e) {
                log.error((Object)"Error while redirecting for big file downloader", (Throwable)e);
            }
        } else {
            ComponentUtils.download((DocumentModel)doc, (String)xpath, (Blob)blob, (String)filename, (String)"download");
        }
    }

    public String updateDocument(DocumentModel doc, Boolean restoreCurrentTabs) {
        String tabId = null;
        String subTabId = null;
        boolean restoreTabs = Boolean.TRUE.equals(restoreCurrentTabs);
        if (restoreTabs) {
            tabId = this.webActions.getCurrentTabId();
            subTabId = this.webActions.getCurrentSubTabId();
        }
        Events.instance().raiseEvent("beforeDocumentChanged", new Object[]{doc});
        try {
            doc = this.documentManager.saveDocument(doc);
        }
        catch (DocumentValidationException e) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("label.schema.constraint.violation.documentValidation"), new Object[]{e.getMessage()});
            return null;
        }
        this.throwUpdateComments(doc);
        this.documentManager.save();
        this.navigationContext.invalidateCurrentDocument();
        this.facesMessages.add(StatusMessage.Severity.INFO, this.messages.get("document_modified"), new Object[]{this.messages.get(doc.getType())});
        EventManager.raiseEventsOnDocumentChange((DocumentModel)doc);
        String res = this.navigationContext.navigateToDocument(doc, "after-edit");
        if (restoreTabs) {
            this.webActions.setCurrentTabId(tabId);
            this.webActions.setCurrentSubTabId(subTabId);
        }
        return res;
    }

    protected String updateDocument(DocumentModel doc) {
        return this.updateDocument(doc, this.restoreCurrentTabs);
    }

    public String updateCurrentDocument() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return this.updateDocument(currentDocument);
    }

    public String createDocument() {
        Type docType = this.typesTool.getSelectedType();
        return this.createDocument(docType.getId());
    }

    public String createDocument(String typeName) {
        Type docType = this.typeManager.getType(typeName);
        this.typesTool.setSelectedType(docType);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("parentPath", this.navigationContext.getCurrentDocument().getPathAsString());
        DocumentModel changeableDocument = this.documentManager.createDocumentModel(typeName, context);
        this.navigationContext.setChangeableDocument(changeableDocument);
        return this.navigationContext.getActionResult(changeableDocument, UserAction.CREATE);
    }

    public String saveDocument() {
        DocumentModel changeableDocument = this.navigationContext.getChangeableDocument();
        return this.saveDocument(changeableDocument);
    }

    public String saveDocument(DocumentModel newDocument) {
        if (newDocument.getId() != null) {
            log.debug((Object)("Document " + newDocument.getName() + " already created"));
            return this.navigationContext.navigateToDocument(newDocument, "after-create");
        }
        PathSegmentService pss = (PathSegmentService)Framework.getService(PathSegmentService.class);
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (this.parentDocumentPath == null) {
            this.parentDocumentPath = currentDocument == null ? this.documentManager.getRootDocument().getPathAsString() : this.navigationContext.getCurrentDocument().getPathAsString();
        }
        newDocument.setPathInfo(this.parentDocumentPath, pss.generatePathSegment(newDocument));
        try {
            newDocument = this.documentManager.createDocument(newDocument);
        }
        catch (DocumentValidationException e) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("label.schema.constraint.violation.documentValidation"), new Object[]{e.getMessage()});
            return null;
        }
        this.documentManager.save();
        this.logDocumentWithTitle("Created the document: ", newDocument);
        this.facesMessages.add(StatusMessage.Severity.INFO, this.messages.get("document_saved"), new Object[]{this.messages.get(newDocument.getType())});
        Events.instance().raiseEvent("documentChildrenChanged", new Object[]{currentDocument});
        return this.navigationContext.navigateToDocument(newDocument, "after-create");
    }

    public boolean getWriteRight() {
        return this.documentManager.hasPermission(this.navigationContext.getCurrentDocument().getRef(), "Write");
    }

    private void throwUpdateComments(DocumentModel changeableDocument) {
        if (this.comment != null && !"".equals(this.comment)) {
            changeableDocument.putContextData("comment", (Serializable)((Object)this.comment));
        }
    }

    public boolean getCanUnpublish() {
        List docList = this.documentsListsManager.getWorkingList("CURRENT_SELECTION_SECTIONS");
        if (docList != null && !docList.isEmpty() && this.deleteActions.checkDeletePermOnParents(docList)) {
            for (DocumentModel document : docList) {
                if (!document.hasFacet("PublishSpace") && !document.hasFacet("MasterPublishSpace")) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Observer(value={"beforeDocumentChanged"})
    public void followTransition(DocumentModel changedDocument) {
        String transitionToFollow = (String)((Object)changedDocument.getContextData(LIFE_CYCLE_TRANSITION_KEY));
        if (transitionToFollow != null) {
            this.documentManager.followTransition(changedDocument.getRef(), transitionToFollow);
            this.documentManager.save();
        }
    }

    public List<Action> getBlobActions(DocumentModel doc, String blobXPath, Blob blob) {
        ActionContext ctx = this.actionContextProvider.createActionContext();
        ctx.putLocalVariable("document", (Object)doc);
        ctx.putLocalVariable("blob", (Object)blob);
        ctx.putLocalVariable("blobXPath", (Object)blobXPath);
        return this.webActions.getActionsList(BLOB_ACTIONS_CATEGORY, ctx, true);
    }

    @WebRemote
    public List<AppLink> getAppLinks(String docId, String blobXPath) {
        IdRef docRef = new IdRef(docId);
        DocumentModel doc = this.documentManager.getDocument((DocumentRef)docRef);
        Serializable value = doc.getPropertyValue(blobXPath);
        if (value == null || !(value instanceof ManagedBlob)) {
            return null;
        }
        ManagedBlob managedBlob = (ManagedBlob)value;
        BlobManager blobManager = (BlobManager)Framework.getService(BlobManager.class);
        BlobProvider blobProvider = blobManager.getBlobProvider(managedBlob.getProviderId());
        if (blobProvider == null) {
            log.error((Object)("No registered blob provider for key: " + managedBlob.getKey()));
            return null;
        }
        String user = this.documentManager.getPrincipal().getName();
        try {
            return blobProvider.getAppLinks(user, managedBlob);
        }
        catch (IOException e) {
            log.error((Object)"Failed to retrieve application links", (Throwable)e);
            return null;
        }
    }

    public boolean getCanUpdateMainBlob() {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        if (doc == null) {
            return false;
        }
        BlobHolder blobHolder = (BlobHolder)doc.getAdapter(BlobHolder.class);
        if (blobHolder == null) {
            return false;
        }
        Blob blob = blobHolder.getBlob();
        if (blob == null) {
            return true;
        }
        BlobProvider blobProvider = ((BlobManager)Framework.getService(BlobManager.class)).getBlobProvider(blob);
        if (blobProvider == null) {
            return true;
        }
        return blobProvider.supportsUserUpdate();
    }
}

