/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.tag.handler;

import com.sun.faces.facelets.tag.TagAttributeImpl;
import com.sun.faces.facelets.tag.TagAttributesImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.MetaTagHandler;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributes;
import javax.faces.view.facelets.TagConfig;
import org.nuxeo.ecm.platform.ui.web.tag.handler.TagConfigFactory;

public class FormTagHandler
extends MetaTagHandler {
    protected final TagConfig config;
    protected final TagAttribute id;
    protected final TagAttribute skip;
    protected final TagAttribute disableDoubleClickShield;
    protected final TagAttribute useAjaxForm;
    protected final TagAttribute disableMultipartForm;
    protected final TagAttribute onsubmit;
    protected final TagAttribute styleClass;

    public FormTagHandler(TagConfig config) {
        super(config);
        this.config = config;
        this.id = this.getAttribute("id");
        this.skip = this.getAttribute("skip");
        this.disableDoubleClickShield = this.getAttribute("disableDoubleClickShield");
        this.useAjaxForm = this.getAttribute("useAjaxForm");
        this.disableMultipartForm = this.getAttribute("disableMultipartForm");
        this.onsubmit = this.getAttribute("onsubmit");
        this.styleClass = this.getAttribute("styleClass");
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        boolean doAdd = true;
        if (this.skip != null) {
            boolean bl = doAdd = !this.skip.getBoolean(ctx);
        }
        if (doAdd) {
            ArrayList<TagAttribute> attrs = new ArrayList<TagAttribute>();
            attrs.addAll(this.copyAttributes(this.id, this.disableDoubleClickShield, this.onsubmit, this.styleClass));
            boolean useMultiPart = true;
            if (this.useAjaxForm != null && this.useAjaxForm.getBoolean(ctx)) {
                useMultiPart = false;
            }
            if (this.disableMultipartForm != null && this.disableMultipartForm.getBoolean(ctx)) {
                useMultiPart = false;
            }
            if (useMultiPart) {
                attrs.add(this.createAttribute("enctype", "multipart/form-data"));
            }
            ComponentConfig cconfig = TagConfigFactory.createComponentConfig(this.config, this.tagId, (TagAttributes)new TagAttributesImpl(attrs.toArray(new TagAttribute[0])), this.nextHandler, "javax.faces.HtmlForm", "javax.faces.Form");
            new ComponentHandler(cconfig).apply(ctx, parent);
        } else {
            this.nextHandler.apply(ctx, parent);
        }
    }

    protected TagAttribute copyAttribute(TagAttribute attribute) {
        return new TagAttributeImpl(this.config.getTag().getLocation(), "", attribute.getLocalName(), attribute.getLocalName(), attribute.getValue());
    }

    protected List<TagAttribute> copyAttributes(TagAttribute ... attributes) {
        ArrayList<TagAttribute> res = new ArrayList<TagAttribute>();
        if (attributes != null) {
            for (TagAttribute attr : attributes) {
                if (attr == null) continue;
                res.add(this.copyAttribute(attr));
            }
        }
        return res;
    }

    protected TagAttribute createAttribute(String name, String value) {
        return new TagAttributeImpl(this.config.getTag().getLocation(), "", name, name, value);
    }

    protected MetaRuleset createMetaRuleset(Class type) {
        return null;
    }
}

