/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.suggestbox.service.descriptors;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.suggestbox.service.ComponentInitializationException;
import org.nuxeo.ecm.platform.suggestbox.service.Suggester;
import org.nuxeo.runtime.model.RuntimeContext;

@XObject(value="suggester")
public class SuggesterDescriptor
implements Cloneable {
    @XNode(value="@name")
    protected String name = "default";
    @XNode(value="@class")
    protected String className;
    @XNode(value="@enabled")
    protected boolean enabled = true;
    @XNodeMap(value="parameters/parameter", key="@name", type=HashMap.class, componentType=String.class)
    protected Map<String, String> parameters = new HashMap<String, String>();
    protected Suggester suggester;
    protected RuntimeContext runtimeContext;

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setRuntimeContext(RuntimeContext context) throws ComponentInitializationException {
        this.runtimeContext = context;
        this.loadParameterizedSuggester();
    }

    protected void loadParameterizedSuggester() throws ComponentInitializationException {
        if (this.enabled && this.className != null) {
            try {
                this.suggester = (Suggester)this.runtimeContext.loadClass(this.className).newInstance();
            }
            catch (Exception e) {
                throw new ComponentInitializationException(String.format("Failed to initialize suggester '%d' with class '%s'", this.name, this.className), e);
            }
            this.suggester.initWithParameters(this);
        }
    }

    public Suggester getSuggester() {
        return this.suggester;
    }

    public void mergeFrom(SuggesterDescriptor previousDescriptor) throws ComponentInitializationException {
        if (this.name == null || !this.name.equals(previousDescriptor)) {
            throw new RuntimeException("Cannot merge descriptor with name '" + this.name + "' with another descriptor with different name " + previousDescriptor.getName() + "'");
        }
        if (this.className == null) {
            if (this.enabled && previousDescriptor.className == null) {
                throw new RuntimeException("Cannot merge descriptor with name '" + this.name + "' with source a source version that has no" + " className defined.");
            }
            this.className = previousDescriptor.className;
            this.runtimeContext = previousDescriptor.runtimeContext;
        }
        HashMap<String, String> mergedParameters = new HashMap<String, String>();
        mergedParameters.putAll(previousDescriptor.parameters);
        mergedParameters.putAll(this.parameters);
        this.parameters = mergedParameters;
        this.loadParameterizedSuggester();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

