/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.suggestbox.service.suggesters;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.suggestbox.service.GroupSuggestion;
import org.nuxeo.ecm.platform.suggestbox.service.SearchDocumentsSuggestion;
import org.nuxeo.ecm.platform.suggestbox.service.Suggester;
import org.nuxeo.ecm.platform.suggestbox.service.Suggestion;
import org.nuxeo.ecm.platform.suggestbox.service.SuggestionContext;
import org.nuxeo.ecm.platform.suggestbox.service.SuggestionException;
import org.nuxeo.ecm.platform.suggestbox.service.UserSuggestion;
import org.nuxeo.ecm.platform.suggestbox.service.descriptors.SuggesterDescriptor;
import org.nuxeo.ecm.platform.suggestbox.service.suggesters.I18nHelper;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class UserGroupLookupSuggester
implements Suggester {
    protected String userIconURL = "/icons/user.gif";
    protected String groupIconURL = "/icons/group.gif";
    protected String searchIconURL = "/img/facetedSearch.png";
    protected SuggesterDescriptor descriptor;
    protected List<String> searchFields = new ArrayList<String>();
    protected String searchLabelPrefix = "label.searchDocumentsByUser_";

    @Override
    public List<Suggestion> suggest(String userInput, SuggestionContext context) throws SuggestionException {
        I18nHelper i18n = I18nHelper.instanceFor(context.messages);
        UserManager userManager = (UserManager)Framework.getLocalService(UserManager.class);
        if (userManager == null) {
            throw new SuggestionException("UserManager is not active");
        }
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
        ArrayList<SearchDocumentsSuggestion> searchSuggestions = new ArrayList<SearchDocumentsSuggestion>();
        try {
            for (DocumentModel user : userManager.searchUsers(userInput)) {
                String userLabel = (String)user.getProperty("user:firstName").getValue(String.class);
                userLabel = userLabel + " ";
                if ((userLabel = userLabel + (String)user.getProperty("user:lastName").getValue(String.class)).trim().isEmpty()) {
                    userLabel = user.getId();
                }
                suggestions.add(new UserSuggestion(user.getId(), userLabel, this.userIconURL));
                for (String searchField : this.searchFields) {
                    String i18nLabel = i18n.translate(this.searchLabelPrefix + searchField.replaceAll(":", "_"), userLabel);
                    SearchDocumentsSuggestion suggestion = new SearchDocumentsSuggestion(i18nLabel, this.searchIconURL).withSearchCriterion(searchField, (Serializable)((Object)user.getId()));
                    searchSuggestions.add(suggestion);
                }
            }
            for (DocumentModel group : userManager.searchGroups(userInput)) {
                String label = (String)group.getProperty("group:grouplabel").getValue(String.class);
                if (label == null || label.isEmpty()) {
                    label = (String)group.getProperty("group:groupname").getValue(String.class);
                }
                suggestions.add(new GroupSuggestion(group.getId(), label, this.groupIconURL));
            }
            suggestions.addAll(searchSuggestions);
            return suggestions;
        }
        catch (ClientException e) {
            throw new SuggestionException(String.format("Suggester '%s' failed to perform query with input '%s'", this.descriptor.getName(), userInput), e);
        }
    }

    @Override
    public void initWithParameters(SuggesterDescriptor descriptor) {
        String searchFields;
        String searchIconURL;
        String groupIconURL;
        Map<String, String> params = descriptor.getParameters();
        String userIconURL = params.get("userIconURL");
        if (userIconURL != null) {
            this.userIconURL = userIconURL;
        }
        if ((groupIconURL = params.get("groupIconURL")) != null) {
            this.groupIconURL = groupIconURL;
        }
        if ((searchIconURL = params.get("searchIconURL")) != null) {
            this.searchIconURL = searchIconURL;
        }
        if ((searchFields = params.get("searchFields")) != null && !searchFields.isEmpty()) {
            this.searchFields = Arrays.asList(searchFields.split(", *"));
        }
        this.descriptor = descriptor;
    }
}

