/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.DomUtil;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.rewrite.ConcatLinkRewriterFactory;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeatureFactory;
import org.apache.shindig.gadgets.rewrite.CssRequestRewriter;
import org.apache.shindig.gadgets.rewrite.GadgetRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.ProxyingLinkRewriter;
import org.apache.shindig.gadgets.rewrite.ProxyingLinkRewriterFactory;
import org.apache.shindig.gadgets.rewrite.RequestRewriter;
import org.apache.shindig.gadgets.rewrite.RewriterUtils;
import org.apache.shindig.gadgets.spec.View;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLContentRewriter
implements GadgetRewriter,
RequestRewriter {
    private static final String JS_MIME_TYPE = "text/javascript";
    public static final Set<String> TAGS = ImmutableSet.of((Object[])new String[]{"img", "embed", "link", "script", "style"});
    private static final ImmutableMap<String, ImmutableSet<String>> LINKING_TAG_ATTRS = ImmutableMap.of((Object)"img", (Object)ImmutableSet.of((Object)"src"), (Object)"embed", (Object)ImmutableSet.of((Object)"src"));
    private final ContentRewriterFeatureFactory rewriterFeatureFactory;
    private final CssRequestRewriter cssRewriter;
    private final ConcatLinkRewriterFactory concatLinkRewriterFactory;
    private final ProxyingLinkRewriterFactory proxyingLinkRewriterFactory;

    @Inject
    public HTMLContentRewriter(ContentRewriterFeatureFactory rewriterFeatureFactory, CssRequestRewriter cssRewriter, ConcatLinkRewriterFactory concatLinkRewriterFactory, ProxyingLinkRewriterFactory proxyingLinkRewriterFactory) {
        this.rewriterFeatureFactory = rewriterFeatureFactory;
        this.cssRewriter = cssRewriter;
        this.concatLinkRewriterFactory = concatLinkRewriterFactory;
        this.proxyingLinkRewriterFactory = proxyingLinkRewriterFactory;
    }

    @Override
    public boolean rewrite(HttpRequest request, HttpResponse original, MutableContent content) {
        if (RewriterUtils.isHtml(request, original)) {
            ContentRewriterFeature feature = this.rewriterFeatureFactory.get(request);
            return this.rewriteImpl(feature, request.getGadget(), request.getUri(), content, request.getContainer(), false, request.getIgnoreCache());
        }
        return false;
    }

    @Override
    public void rewrite(Gadget gadget, MutableContent content) {
        if (gadget.getSpec().getModulePrefs().getFeatures().containsKey("caja") || "1".equals(gadget.getContext().getParameter("caja"))) {
            return;
        }
        ContentRewriterFeature feature = this.rewriterFeatureFactory.get(gadget.getSpec());
        Uri contentBase = gadget.getSpec().getUrl();
        View view = gadget.getCurrentView();
        if (view != null && view.getHref() != null) {
            contentBase = view.getHref();
        }
        this.rewriteImpl(feature, gadget.getSpec().getUrl(), contentBase, content, gadget.getContext().getContainer(), gadget.getContext().getDebug(), gadget.getContext().getIgnoreCache());
    }

    boolean rewriteImpl(ContentRewriterFeature feature, Uri gadgetUri, Uri contentBase, MutableContent content, String container, boolean debug, boolean ignoreCache) {
        if (!feature.isRewriteEnabled() || content.getDocument() == null) {
            return false;
        }
        List tagList = DomUtil.getElementsByTagNameCaseInsensitive((Document)content.getDocument(), TAGS);
        Element head = (Element)DomUtil.getFirstNamedChildNode((Node)content.getDocument().getDocumentElement(), (String)"head");
        boolean mutated = false;
        mutated = this.rewriteStyleTags(head, tagList, feature, gadgetUri, contentBase, container, debug, ignoreCache);
        mutated |= this.rewriteJsTags(tagList, feature, gadgetUri, contentBase, container, debug, ignoreCache);
        if (mutated |= this.rewriteContentReferences(tagList, feature, gadgetUri, contentBase, container, debug, ignoreCache)) {
            MutableContent.notifyEdit(content.getDocument());
        }
        return mutated;
    }

    protected boolean rewriteStyleTags(Element head, List<Element> elementList, ContentRewriterFeature feature, Uri gadgetUri, Uri contentBase, String container, boolean debug, boolean ignoreCache) {
        if (!feature.getIncludedTags().contains("style")) {
            return false;
        }
        boolean mutated = false;
        ArrayList styleTags = Lists.newArrayList((Iterable)Iterables.filter(elementList, (Predicate)new Predicate<Element>(){

            public boolean apply(Element element) {
                return element.getNodeName().equalsIgnoreCase("style");
            }
        }));
        ProxyingLinkRewriter linkRewriter = this.proxyingLinkRewriterFactory.create(gadgetUri, feature, container, debug, ignoreCache);
        for (Element styleTag : styleTags) {
            mutated |= true;
            if (styleTag.getParentNode() != head) {
                styleTag.getParentNode().removeChild(styleTag);
                head.appendChild(styleTag);
            }
            List<String> extractedUrls = this.cssRewriter.rewrite(styleTag, contentBase, linkRewriter, true);
            for (String extractedUrl : extractedUrls) {
                Element newLink = head.getOwnerDocument().createElement("link");
                newLink.setAttribute("rel", "stylesheet");
                newLink.setAttribute("type", "text/css");
                newLink.setAttribute("href", extractedUrl);
                head.appendChild(newLink);
                elementList.add(newLink);
            }
        }
        ArrayList linkTags = Lists.newArrayList((Iterable)Iterables.filter(elementList, (Predicate)new Predicate<Element>(){

            public boolean apply(Element element) {
                return element.getNodeName().equalsIgnoreCase("link") && ("stylesheet".equalsIgnoreCase(element.getAttribute("rel")) || element.getAttribute("type").toLowerCase().contains("css"));
            }
        }));
        this.concatenateTags(feature, linkTags, gadgetUri, contentBase, "text/css", "href", container, debug, ignoreCache);
        return mutated;
    }

    protected boolean rewriteJsTags(List<Element> elementList, ContentRewriterFeature feature, Uri gadgetUri, Uri contentBase, String container, boolean debug, boolean ignoreCache) {
        if (!feature.getIncludedTags().contains("script")) {
            return false;
        }
        boolean mutated = false;
        ArrayList scriptTags = Lists.newArrayList((Iterable)Iterables.filter(elementList, (Predicate)new Predicate<Element>(){

            public boolean apply(Element node) {
                if (node.getNodeName().equalsIgnoreCase("script")) {
                    String type = node.getAttribute("type");
                    return type == null || type.length() == 0 || type.equalsIgnoreCase(HTMLContentRewriter.JS_MIME_TYPE);
                }
                return false;
            }
        }));
        ArrayList concatenateable = Lists.newArrayList();
        for (int i = 0; i < scriptTags.size(); ++i) {
            Element scriptTag = (Element)scriptTags.get(i);
            Element nextSciptTag = null;
            if (i + 1 < scriptTags.size()) {
                nextSciptTag = (Element)scriptTags.get(i + 1);
            }
            if (scriptTag.hasAttribute("src") && feature.shouldRewriteURL(scriptTag.getAttribute("src"))) {
                mutated = true;
                concatenateable.add(scriptTag);
                if (nextSciptTag != null && nextSciptTag.equals(this.getNextSiblingElement(scriptTag))) continue;
                this.concatenateTags(feature, concatenateable, gadgetUri, contentBase, JS_MIME_TYPE, "src", container, debug, ignoreCache);
                concatenateable.clear();
                continue;
            }
            this.concatenateTags(feature, concatenateable, gadgetUri, contentBase, JS_MIME_TYPE, "src", container, debug, ignoreCache);
            concatenateable.clear();
        }
        this.concatenateTags(feature, concatenateable, gadgetUri, contentBase, JS_MIME_TYPE, "src", container, debug, ignoreCache);
        return mutated;
    }

    protected boolean rewriteContentReferences(List<Element> elementList, ContentRewriterFeature feature, Uri gadgetUri, Uri contentBase, String container, boolean debug, boolean ignoreCache) {
        boolean mutated = false;
        ProxyingLinkRewriter rewriter = this.proxyingLinkRewriterFactory.create(gadgetUri, feature, container, debug, ignoreCache);
        Sets.SetView tagNames = Sets.intersection((Set)LINKING_TAG_ATTRS.keySet(), feature.getIncludedTags());
        Iterable tags = Iterables.filter(elementList, (Predicate)new Predicate<Element>((Set)tagNames){
            final /* synthetic */ Set val$tagNames;
            {
                this.val$tagNames = set;
            }

            public boolean apply(Element node) {
                return this.val$tagNames.contains(node.getNodeName().toLowerCase());
            }
        });
        for (Element node : tags) {
            NamedNodeMap attributes = node.getAttributes();
            Set rewriteable = (Set)LINKING_TAG_ATTRS.get((Object)node.getNodeName().toLowerCase());
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attr = attributes.item(i);
                if (!rewriteable.contains(attr.getNodeName().toLowerCase())) continue;
                mutated = true;
                attr.setNodeValue(rewriter.rewrite(attr.getNodeValue(), contentBase));
            }
        }
        return mutated;
    }

    private void concatenateTags(final ContentRewriterFeature feature, List<Element> tags, Uri gadgetUri, Uri contentBase, String mimeType, final String attr, String container, boolean debug, boolean ignoreCache) {
        tags = Lists.newArrayList((Iterable)Iterables.filter(tags, (Predicate)new Predicate<Element>(){

            public boolean apply(Element element) {
                return element.hasAttribute(attr) && feature.shouldRewriteURL(element.getAttribute(attr));
            }
        }));
        LinkedHashSet nodeRefList = Sets.newLinkedHashSet();
        for (Element tag : tags) {
            try {
                nodeRefList.add(contentBase.resolve(Uri.parse((String)tag.getAttribute(attr))));
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
        List<Uri> concatented = this.concatLinkRewriterFactory.create(gadgetUri, feature, container, debug, ignoreCache).rewrite(mimeType, nodeRefList);
        for (int i = 0; i < tags.size(); ++i) {
            if (i < concatented.size()) {
                ((Element)tags.get(i)).setAttribute(attr, concatented.get(i).toString());
                continue;
            }
            ((Element)tags.get(i)).getParentNode().removeChild((Node)tags.get(i));
        }
    }

    private Element getNextSiblingElement(Element elem) {
        Node n = elem;
        for (n = n.getNextSibling(); n != null && n.getNodeType() != 1; n = n.getNextSibling()) {
        }
        return (Element)n;
    }
}

