/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.gadgets.service;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetContext;

class NXGadgetContext
extends GadgetContext {
    private static final Log log = LogFactory.getLog(NXGadgetContext.class);
    protected URL url;
    protected String xml;

    public NXGadgetContext(URL url) {
        this.url = url;
    }

    public NXGadgetContext(URL url, String xml) {
        this.url = url;
        this.xml = xml;
    }

    public String getParameter(String name) {
        if ("rawxml".equals(name)) {
            return this.xml;
        }
        return super.getParameter(name);
    }

    public Uri getUrl() {
        try {
            return Uri.fromJavaUri((URI)this.url.toURI());
        }
        catch (URISyntaxException e) {
            log.error((Object)"Unale to parse URL", (Throwable)e);
            return null;
        }
    }

    public boolean getIgnoreCache() {
        return false;
    }

    public String getContainer() {
        return "default";
    }
}

