/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.servlet;

import com.google.caja.ancillary.opt.EnvironmentDatum;
import com.google.caja.ancillary.opt.JsOptimizer;
import com.google.caja.ancillary.servlet.Resources;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.ParseTreeNodes;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.Literal;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Parser;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.reporting.EchoingMessageQueue;
import com.google.caja.reporting.MessageContext;
import com.google.caja.util.Lists;
import com.google.caja.util.Pair;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.regex.Pattern;

final class UserAgentDb {
    static final List<Pair<String, ObjectConstructor>> ENV_JSON = Lists.newArrayList();

    UserAgentDb() {
    }

    static ObjectConstructor lookupEnvJson(Pattern p) {
        ObjectConstructor result = null;
        for (Pair<String, ObjectConstructor> pair : ENV_JSON) {
            if (!p.matcher((CharSequence)pair.a).find()) continue;
            if (result == null) {
                result = (ObjectConstructor)((ObjectConstructor)pair.b).clone();
                continue;
            }
            result = UserAgentDb.merge(result, (ObjectConstructor)pair.b);
        }
        return result;
    }

    private static ObjectConstructor merge(ObjectConstructor a, ObjectConstructor b) {
        List<Pair<Literal, Expression>> props = Lists.newArrayList();
        List<? extends Expression> children = a.children();
        int n = children.size();
        for (int i = 0; i < n; i += 2) {
            StringLiteral key = (StringLiteral)children.get(i);
            Expression avalue = children.get(i + 1);
            Expression bvalue = b.getValue(key.getUnquotedValue());
            if (bvalue == null || !ParseTreeNodes.deepEquals(avalue, bvalue)) continue;
            props.add(Pair.pair(key, avalue));
        }
        return new ObjectConstructor(FilePosition.UNKNOWN, props);
    }

    static {
        String[] envJsonFiles = new String[]{};
        try {
            envJsonFiles = Resources.read(JsOptimizer.class, "env.json.list.txt").toString().split("[\r\n]+");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        EchoingMessageQueue mq = new EchoingMessageQueue(new PrintWriter(System.err), new MessageContext());
        for (String envJsonFile : envJsonFiles) {
            if ("".equals(envJsonFile)) continue;
            try {
                ObjectConstructor json;
                Expression userAgent;
                CharProducer cp = Resources.read(JsOptimizer.class, envJsonFile);
                FilePosition pos = cp.filePositionForOffsets(cp.getOffset(), cp.getLimit());
                JsLexer lexer = new JsLexer(cp);
                JsTokenQueue tq = new JsTokenQueue(lexer, pos.source());
                tq.setInputRange(pos);
                Expression e = new Parser(tq, mq).parseExpression(true);
                if (!(e instanceof ObjectConstructor) || (userAgent = (json = (ObjectConstructor)e).getValue(EnvironmentDatum.NAV_USER_AGENT.getCode())) == null) continue;
                ENV_JSON.add(Pair.pair(((StringLiteral)userAgent).getUnquotedValue(), json));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (ParseException ex) {
                ex.printStackTrace();
            }
        }
    }
}

