/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Criterion<T> {
    public boolean accept(T var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory {
        private static final Criterion<?> OPTIMIST_SINGLETON = new Criterion<Object>(){

            @Override
            public boolean accept(Object _) {
                return true;
            }

            public String toString() {
                return "OptimistCriterion";
            }
        };
        private static final Criterion<?> PESSIMIST_SINGLETON = new Criterion<Object>(){

            @Override
            public boolean accept(Object _) {
                return false;
            }

            public String toString() {
                return "PessimistCriterion";
            }
        };

        public static <T> Criterion<T> optimist() {
            return OPTIMIST_SINGLETON;
        }

        public static <T> Criterion<T> pessimist() {
            return PESSIMIST_SINGLETON;
        }

        public static <T> Criterion<T> or(final Criterion<T> a, final Criterion<? super T> b) {
            if (a == null || b == null) {
                throw new NullPointerException();
            }
            return new Criterion<T>(){

                @Override
                public boolean accept(T candidate) {
                    return a.accept(candidate) || b.accept(candidate);
                }
            };
        }

        public static <T> Criterion<T> and(final Criterion<T> a, final Criterion<? super T> b) {
            if (null == a || null == b) {
                throw new NullPointerException();
            }
            return new Criterion<T>(){

                @Override
                public boolean accept(T candidate) {
                    return a.accept(candidate) && b.accept(candidate);
                }
            };
        }

        public static <T> Criterion<T> not(Criterion<T> criterion) {
            return !(criterion instanceof Contrarian) ? new Contrarian<T>(criterion) : ((Contrarian)criterion).c;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class Contrarian<T>
        implements Criterion<T> {
            private Criterion<T> c;

            public Contrarian(Criterion<T> c) {
                this.c = c;
            }

            @Override
            public boolean accept(T candidate) {
                return !this.c.accept(candidate);
            }

            public String toString() {
                return "!" + this.c;
            }
        }
    }
}

