/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.suggestbox.jsf;

public class Cached<T> {
    public long cachedAt;
    public long expireMillis;
    public Object[] keys = new Object[0];
    public T value;
    public boolean expired = false;

    public Cached(long expireMillis) {
        this.expireMillis = expireMillis;
        this.expired = true;
    }

    public void cache(T value, Object ... keys) {
        this.expired = false;
        this.cachedAt = System.currentTimeMillis();
        this.keys = keys;
        this.value = value;
    }

    public void expire() {
        this.expired = true;
        this.value = null;
        this.keys = new Object[0];
    }

    public boolean hasExpired(Object ... invalidationKeys) {
        if (this.expired) {
            return true;
        }
        long now = System.currentTimeMillis();
        if (now - this.cachedAt > this.expireMillis) {
            return true;
        }
        if (invalidationKeys.length != this.keys.length) {
            return true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i].equals(invalidationKeys[i])) continue;
            return true;
        }
        return false;
    }

    public static <E> Cached<E> expired(long expireMillis) {
        return new Cached(expireMillis);
    }
}

