/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.opt;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.MutableParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.Visitor;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.Literal;
import com.google.caja.parser.js.MultiDeclaration;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.RegexpLiteral;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ConstantPooler {
    public static Block optimize(Block program) {
        program = (Block)program.clone();
        ConstantPooler.optimizeTopLevelFunctions(program);
        return program;
    }

    private static void optimizeTopLevelFunctions(ParseTreeNode node) {
        if (node instanceof FunctionConstructor) {
            ConstantPooler.optimizeWithin((FunctionConstructor)node);
        } else {
            for (ParseTreeNode parseTreeNode : node.children()) {
                ConstantPooler.optimizeTopLevelFunctions(parseTreeNode);
            }
        }
    }

    private static void optimizeWithin(FunctionConstructor fc) {
        final Map uses = Maps.newLinkedHashMap();
        Block body = fc.getBody();
        body.acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> chain) {
                if (chain.node instanceof Literal && !(chain.node instanceof RegexpLiteral)) {
                    AncestorChain<Literal> litAc = chain.cast(Literal.class);
                    LitVal key = new LitVal(litAc);
                    LitVal stored = (LitVal)uses.get(key);
                    if (stored == null) {
                        stored = key;
                        uses.put(key, stored);
                    }
                    stored.uses.add(litAc);
                } else if (chain.node instanceof ObjectConstructor) {
                    List<? extends ParseTreeNode> children = chain.node.children();
                    int n = children.size();
                    for (int i = 1; i < n; i += 2) {
                        this.visit(chain.child(children.get(i)));
                    }
                    return false;
                }
                return true;
            }
        }, null);
        List<Declaration> decls = Lists.newArrayList();
        FilePosition pos = FilePosition.startOf(body.getFilePosition());
        for (LitVal v : uses.values()) {
            int nUses;
            int requiredSavings = 30;
            int canonLen = v.canonForm().length();
            if (canonLen * (nUses = v.uses.size()) <= 8 + canonLen + 2 * nUses + requiredSavings) continue;
            String name = "$_$__litpool__" + decls.size() + "$_$";
            decls.add(new Declaration(pos, new Identifier(pos, name), (Expression)v.uses.get((int)0).node));
            for (AncestorChain<Literal> use : v.uses) {
                Reference ref = new Reference(new Identifier(((Literal)use.node).getFilePosition(), name));
                ((MutableParseTreeNode)use.parent.cast(MutableParseTreeNode.class).node).replaceChild(ref, (ParseTreeNode)use.node);
            }
        }
        if (!decls.isEmpty()) {
            MultiDeclaration md;
            Statement first = body.children().get(0);
            if (first instanceof MultiDeclaration) {
                md = (MultiDeclaration)first;
            } else if (first instanceof Declaration) {
                md = new MultiDeclaration(FilePosition.span(pos, first.getFilePosition()), Collections.singletonList((Declaration)first));
                body.replaceChild(md, first);
            } else {
                if (decls.size() == 1) {
                    body.insertBefore((ParseTreeNode)decls.get(0), first);
                    return;
                }
                md = new MultiDeclaration(pos, Collections.emptyList());
                body.insertBefore(md, first);
            }
            MutableParseTreeNode.Mutation mut = md.createMutation();
            Declaration firstDecl = md.children().get(0);
            for (Declaration decl : decls) {
                mut = mut.insertBefore(decl, firstDecl);
            }
            mut.execute();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LitVal {
        final Object canonValue;
        final List<AncestorChain<Literal>> uses = Lists.newArrayList();

        LitVal(AncestorChain<Literal> useAc) {
            Literal use = (Literal)useAc.node;
            this.canonValue = use instanceof StringLiteral ? ((StringLiteral)use).getUnquotedValue() : use.getValue();
        }

        String canonForm() {
            StringBuilder sb = new StringBuilder();
            Literal use = (Literal)this.uses.get((int)0).node;
            RenderContext rc = new RenderContext(use.makeRenderer(sb, null));
            use.render(rc);
            rc.getOut().noMoreTokens();
            return sb.toString();
        }

        public int hashCode() {
            return this.canonValue.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof LitVal)) {
                return false;
            }
            return this.canonValue.equals(((LitVal)o).canonValue);
        }
    }
}

