/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.servlet;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shindig.auth.AuthenticationServletFilter;
import org.osgi.framework.FrameworkEvent;

public class AuthenticationFilterDelayer
implements Filter {
    protected AuthenticationServletFilter delayed = new AuthenticationServletFilter();
    protected boolean ready = false;
    protected FilterConfig delayedConfig;
    private static final Log log = LogFactory.getLog(AuthenticationFilterDelayer.class);
    protected static boolean hasBeenActivated = false;
    private static ArrayList<AuthenticationFilterDelayer> created = new ArrayList();

    public void destroy() {
        this.delayed.destroy();
    }

    public AuthenticationFilterDelayer() {
        created.add(this);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.ready) {
            this.delayed.doFilter(request, response, chain);
        } else {
            log.warn((Object)"received web request prior to framework being fully initialized!");
            chain.doFilter(request, response);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.delayedConfig = filterConfig;
        if (hasBeenActivated) {
            this.delayed.init(filterConfig);
            this.ready = true;
        }
    }

    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() != 1) {
            return;
        }
        try {
            this.delayed.init(this.delayedConfig);
            this.ready = true;
        }
        catch (ServletException e) {
            log.error((Object)e);
        }
    }

    public static void activate(FrameworkEvent event) {
        for (AuthenticationFilterDelayer delayer : created) {
            delayer.frameworkEvent(event);
        }
        hasBeenActivated = true;
    }
}

