/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Executor {
    public <T> T run(Map<String, ?> var1, Class<T> var2) throws AbnormalExitException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Input {
        public final Reader input;
        public final String source;

        public Input(Reader input, String source) {
            this.input = input;
            this.source = source;
        }

        public Input(String javascript, String source) {
            this(new StringReader(javascript), source);
        }

        public Input(Class<?> base, String resource) throws IOException {
            URL url = base.getResource(resource);
            if (null == url) {
                throw new FileNotFoundException("Resource " + resource + " relative to " + base);
            }
            URLConnection conn = url.openConnection();
            conn.connect();
            InputStream instream = conn.getInputStream();
            this.source = url.toString();
            this.input = new InputStreamReader(instream, "UTF-8");
        }

        public String toString() {
            return "(Input " + this.source + ")";
        }
    }

    public static final class Factory {
        public static Executor createJsExecutor(Input ... srcs) throws MalformedSourceException {
            ReflectiveOperationException cause;
            try {
                Class<Executor> execClass = Class.forName(System.getProperty("com.google.caja.util.Executor.JS.class", "com.google.caja.util.RhinoExecutor")).asSubclass(Executor.class);
                return execClass.getConstructor(Input[].class).newInstance(new Object[]{srcs});
            }
            catch (InvocationTargetException ex) {
                throw new MalformedSourceException(ex);
            }
            catch (ClassNotFoundException ex) {
                cause = ex;
            }
            catch (IllegalAccessException ex) {
                cause = ex;
            }
            catch (InstantiationException ex) {
                cause = ex;
            }
            catch (NoSuchMethodException ex) {
                cause = ex;
            }
            throw new RuntimeException(cause);
        }

        private Factory() {
        }
    }

    public static class MalformedSourceException
    extends Exception {
        public MalformedSourceException(String message) {
            super(message);
        }

        public MalformedSourceException(Throwable cause) {
            super(cause);
        }

        public MalformedSourceException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class AbnormalExitException
    extends Exception {
        public AbnormalExitException(String message) {
            super(message);
        }

        public AbnormalExitException(Throwable cause) {
            super(cause);
        }

        public AbnormalExitException(String message, Throwable cause) {
            super(message, cause);
        }

        public String getScriptTrace() {
            Throwable th = this;
            if (th.getCause() != null) {
                th = th.getCause();
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            th.printStackTrace(pw);
            pw.flush();
            return sw.toString();
        }
    }
}

