/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.suggestbox.service;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.suggestbox.service.Suggestion;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;

public class DocumentSuggestion
extends Suggestion {
    private static final long serialVersionUID = 1L;
    protected final DocumentLocation documentLocation;

    public DocumentSuggestion(DocumentLocation documentLocation, String label, String iconURL) {
        super("document", label, iconURL);
        this.documentLocation = documentLocation;
    }

    public static Suggestion fromDocumentModel(DocumentModel doc) throws ClientException {
        TypeInfo typeInfo = (TypeInfo)doc.getAdapter(TypeInfo.class);
        String description = (String)doc.getProperty("dc:description").getValue(String.class);
        return new DocumentSuggestion((DocumentLocation)new DocumentLocationImpl(doc), doc.getTitle(), typeInfo.getIcon()).withDescription(description);
    }

    public DocumentLocation getDocumentLocation() {
        return this.documentLocation;
    }
}

