/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.gwt.client.view;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.platform.annotations.gwt.client.configuration.AnnotationDefinition;
import org.nuxeo.ecm.platform.annotations.gwt.client.configuration.AnnotationFilter;
import org.nuxeo.ecm.platform.annotations.gwt.client.configuration.WebConfiguration;
import org.nuxeo.ecm.platform.annotations.gwt.client.configuration.filter.InMenuFilter;
import org.nuxeo.ecm.platform.annotations.gwt.client.controler.AnnotationController;
import org.nuxeo.ecm.platform.annotations.gwt.client.model.Annotation;
import org.nuxeo.ecm.platform.annotations.gwt.client.model.AnnotationChangeListener;
import org.nuxeo.ecm.platform.annotations.gwt.client.model.AnnotationModel;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.AnnotationUtils;
import org.nuxeo.ecm.platform.annotations.gwt.client.view.AnnotationActionsBanner;
import org.nuxeo.ecm.platform.annotations.gwt.client.view.AnnotationListPopup;
import org.nuxeo.ecm.platform.annotations.gwt.client.view.NewAnnotationPopup;
import org.nuxeo.ecm.platform.annotations.gwt.client.view.i18n.TranslationConstants;
import org.nuxeo.ecm.platform.annotations.gwt.client.view.i18n.TranslationMessages;

public class AnnotationManagerPanel
extends VerticalPanel
implements AnnotationChangeListener {
    private static final String CLASS_NAME = "annotationManagerPanel";
    private final WebConfiguration webConfiguration;
    private AnnotationController controller;
    private AnnotationModel model;
    private VerticalPanel shownAnnotation = new VerticalPanel();
    private Map<String, Integer> selectedParams = new HashMap<String, Integer>();
    private HorizontalPanel selectedRow;

    public AnnotationManagerPanel(AnnotationController controller, WebConfiguration webConfiguration) {
        this.controller = controller;
        this.webConfiguration = webConfiguration;
        this.setStyleName(CLASS_NAME);
    }

    @Override
    public void onChange(AnnotationModel model, AnnotationChangeListener.ChangeEvent ce) {
        this.model = model;
        if (ce == AnnotationChangeListener.ChangeEvent.annotationList) {
            this.update();
        }
    }

    private void update() {
        this.clear();
        this.addAnnotationsActionList();
        this.addFiltersToolbar();
        this.addAnnotationsList();
    }

    private void addFiltersToolbar() {
        String annName;
        HorizontalPanel toolBar = new HorizontalPanel();
        List<AnnotationFilter> filters = this.webConfiguration.getFilters();
        for (final AnnotationFilter filter : filters) {
            PushButton button = new PushButton(new Image(filter.getIcon()), new ClickListener(){

                public void onClick(Widget sender) {
                    AnnotationManagerPanel.this.model.setFilter(filter);
                }
            });
            button.setTitle(filter.getName());
            toolBar.add((Widget)button);
        }
        Label spacer = new Label(" ");
        toolBar.add((Widget)spacer);
        toolBar.setCellWidth((Widget)spacer, "100%");
        List<AnnotationDefinition> inMenuAnnos = this.webConfiguration.getAnnotationDefinitions(new InMenuFilter());
        TranslationMessages translationMessages = (TranslationMessages)GWT.create(TranslationMessages.class);
        for (AnnotationDefinition annotationDef : inMenuAnnos) {
            annName = annotationDef.getName();
            PushButton button = new PushButton(new Image(annotationDef.getListIcon()), new ClickListener(){

                public void onClick(Widget sender) {
                    new AnnotationListPopup(annName, AnnotationManagerPanel.this.model.filterAnnotations(new AnnotationFilter("", "", annName, null, null)), AnnotationManagerPanel.this.webConfiguration).show();
                }
            });
            button.setTitle(translationMessages.viewAnnotations(annotationDef.getName()));
            toolBar.add((Widget)button);
        }
        for (AnnotationDefinition annotationDef : inMenuAnnos) {
            annName = annotationDef.getName();
            final String annType = annotationDef.getType();
            PushButton button = new PushButton(new Image(annotationDef.getCreateIcon()), new ClickListener(){

                public void onClick(Widget sender) {
                    AnnotationManagerPanel.this.controller.createNewAnnotation("#xpointer(null-range)");
                    NewAnnotationPopup popup = new NewAnnotationPopup(null, AnnotationManagerPanel.this.controller, false, annType, annName);
                    popup.show();
                }
            });
            button.setTitle(translationMessages.addAnnotation(annotationDef.getName()));
            toolBar.add((Widget)button);
        }
        this.add((Widget)toolBar);
        final AnnotationFilter currentFilter = this.model.getFilter();
        if (currentFilter != null && !currentFilter.getParameters().isEmpty()) {
            List<String> parameters = currentFilter.getParameters();
            Map<String, String> labels = this.webConfiguration.getFieldLabels();
            Grid filterGrid = new Grid(parameters.size(), 2);
            filterGrid.setStyleName("filterGrid");
            filterGrid.getColumnFormatter().setWidth(1, "100%");
            for (int i = 0; i < parameters.size(); ++i) {
                final String parameter = parameters.get(i);
                filterGrid.setWidget(i, 0, (Widget)new Label((labels.containsKey(parameter) ? labels.get(parameter) : parameter) + ": "));
                final ListBox filterListBox = new ListBox();
                filterListBox.setStyleName("filterListBox");
                filterListBox.addItem("All");
                HashSet<String> values = new HashSet<String>();
                for (Annotation annotation : this.model.getUnfilteredAnnotations()) {
                    if (parameter.equals("{http://www.w3.org/1999/02/22-rdf-syntax-ns#}type")) {
                        values.add(annotation.getShortType());
                        continue;
                    }
                    if (parameter.equals("{http://purl.org/dc/elements/1.1/}creator")) {
                        values.add(annotation.getAuthor());
                        continue;
                    }
                    String value = annotation.getFields().get(parameter);
                    if (value == null) continue;
                    values.add(value);
                }
                for (String value : values) {
                    filterListBox.addItem(value);
                }
                if (this.selectedParams.containsKey(parameter)) {
                    filterListBox.setSelectedIndex(this.selectedParams.get(parameter).intValue());
                }
                if (parameter.equals("{http://www.w3.org/1999/02/22-rdf-syntax-ns#}type")) {
                    filterListBox.addChangeListener(new ChangeListener(){

                        public void onChange(Widget arg0) {
                            int selectedIndex = filterListBox.getSelectedIndex();
                            if (selectedIndex == 0) {
                                currentFilter.setType(null);
                            } else {
                                currentFilter.setType(filterListBox.getItemText(selectedIndex));
                            }
                            AnnotationManagerPanel.this.selectedParams.put(parameter, selectedIndex);
                            AnnotationManagerPanel.this.model.setFilter(currentFilter);
                        }
                    });
                } else if (parameter.equals("{http://purl.org/dc/elements/1.1/}creator")) {
                    filterListBox.addChangeListener(new ChangeListener(){

                        public void onChange(Widget arg0) {
                            int selectedIndex = filterListBox.getSelectedIndex();
                            if (selectedIndex == 0) {
                                currentFilter.setAuthor(null);
                            } else {
                                currentFilter.setAuthor(filterListBox.getItemText(selectedIndex));
                            }
                            AnnotationManagerPanel.this.selectedParams.put(parameter, selectedIndex);
                            AnnotationManagerPanel.this.model.setFilter(currentFilter);
                        }
                    });
                } else {
                    filterListBox.addChangeListener(new ChangeListener(){

                        public void onChange(Widget arg0) {
                            int selectedIndex = filterListBox.getSelectedIndex();
                            if (selectedIndex == 0) {
                                currentFilter.removeField(parameter);
                            } else {
                                currentFilter.setField(parameter, filterListBox.getItemText(selectedIndex));
                            }
                            AnnotationManagerPanel.this.selectedParams.put(parameter, selectedIndex);
                            AnnotationManagerPanel.this.model.setFilter(currentFilter);
                        }
                    });
                }
                filterGrid.setWidget(i, 1, (Widget)filterListBox);
            }
            this.add((Widget)filterGrid);
        }
    }

    private void addAnnotationsActionList() {
        this.add((Widget)new AnnotationActionsBanner(this.controller));
    }

    private void addAnnotationsList() {
        HorizontalPanel hpSelected = null;
        int selectedAnnotationIndex = -1;
        VerticalPanel vp = new VerticalPanel();
        vp.setStylePrimaryName("annotation-list");
        List<Annotation> annotations = this.model.getAnnotations();
        for (int y = 0; y < annotations.size(); ++y) {
            final int row = y;
            Annotation annotation = annotations.get(y);
            final HorizontalPanel hp = new HorizontalPanel();
            AnnotationDefinition def = this.webConfiguration.getAnnotationDefinition(annotation.getShortType());
            Image icon = new Image(def.getIcon());
            icon.addClickListener(new ClickListener(){

                public void onClick(Widget sender) {
                    AnnotationManagerPanel.this.updateSelectedAnnotation(row);
                    AnnotationManagerPanel.this.selectAnnotation(hp, row);
                }
            });
            hp.add((Widget)icon);
            Label date = new Label(annotation.getFormattedDate());
            date.addClickListener(new ClickListener(){

                public void onClick(Widget sender) {
                    AnnotationManagerPanel.this.updateSelectedAnnotation(row);
                    AnnotationManagerPanel.this.selectAnnotation(hp, row);
                }
            });
            hp.add((Widget)date);
            Set<String> displayedFields = this.webConfiguration.getDisplayedFields();
            for (String displayedField : displayedFields) {
                String value = annotation.getFields().get(displayedField);
                Label l = new Label(value != null ? value : " ");
                l.addClickListener(new ClickListener(){

                    public void onClick(Widget sender) {
                        AnnotationManagerPanel.this.updateSelectedAnnotation(row);
                        AnnotationManagerPanel.this.selectAnnotation(hp, row);
                    }
                });
                hp.add((Widget)l);
            }
            hp.setCellWidth(hp.getWidget(hp.getWidgetCount() - 1), "100%");
            vp.add((Widget)hp);
            if (this.getSelectedAnnotationIndex() != row) continue;
            hpSelected = hp;
            selectedAnnotationIndex = row;
        }
        this.add((Widget)vp);
        if (hpSelected != null && selectedAnnotationIndex > -1) {
            this.selectAnnotation(hpSelected, selectedAnnotationIndex);
        }
    }

    private native void updateSelectedAnnotation(int var1);

    private void selectAnnotation(HorizontalPanel hp, int index) {
        this.setSelectedannotationIndex(index);
        this.updateShownAnnotation(index);
        this.updateSelectedRow(hp, index);
    }

    private native void setSelectedannotationIndex(int var1);

    private native int getSelectedAnnotationIndex();

    private void updateShownAnnotation(int y) {
        this.remove((Widget)this.shownAnnotation);
        this.shownAnnotation = new VerticalPanel();
        this.shownAnnotation.addStyleName("shown-annotation");
        Annotation ann = this.model.getAnnotations().get(y);
        this.add((Widget)this.shownAnnotation);
        HorizontalPanel horizontalPanel = new HorizontalPanel();
        AnnotationDefinition def = this.webConfiguration.getAnnotationDefinition(ann.getShortType());
        Image image = new Image(def.getIcon());
        horizontalPanel.add((Widget)image);
        horizontalPanel.add((Widget)new Label(ann.getFormattedDate()));
        Set<String> displayedFields = this.webConfiguration.getDisplayedFields();
        for (String displayedField : displayedFields) {
            String value = ann.getFields().get(displayedField);
            horizontalPanel.add((Widget)new Label("\u2022"));
            Label valueLabel = new Label(value != null ? value : " ");
            horizontalPanel.add((Widget)valueLabel);
        }
        Label spacer = new Label(" ");
        horizontalPanel.add((Widget)spacer);
        horizontalPanel.setCellWidth((Widget)spacer, "100%");
        this.shownAnnotation.add((Widget)horizontalPanel);
        if (ann.isBodyUrl()) {
            Frame frame = new Frame();
            frame.setUrl(ann.getBody());
            this.shownAnnotation.add((Widget)frame);
        } else {
            HTML label = new HTML(AnnotationUtils.replaceCarriageReturns(ann.getBody()));
            label.setStyleName("annotation-body");
            this.shownAnnotation.add((Widget)label);
        }
    }

    protected void updateSelectedRow(HorizontalPanel hp, final int index) {
        if (this.selectedRow != null) {
            this.selectedRow.removeStyleName("selectedAnnotationInList");
            this.selectedRow.remove(this.selectedRow.getWidgetCount() - 1);
        }
        hp.setStyleName("selectedAnnotationInList");
        Image deleteImage = new Image("icons/delete.png");
        deleteImage.addClickListener(new ClickListener(){

            public void onClick(Widget sender) {
                TranslationConstants translationConstants = (TranslationConstants)GWT.create(TranslationConstants.class);
                if (Window.confirm((String)translationConstants.menuConfirmDelete())) {
                    AnnotationManagerPanel.this.controller.deleteAnnotation(index);
                    AnnotationManagerPanel.this.setSelectedannotationIndex(-1);
                }
            }
        });
        hp.add((Widget)deleteImage);
        this.selectedRow = hp;
    }
}

