/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.StringTokenizer;

public class EXIFGenerator {
    public static void main(String[] args) {
        String s = null;
        try {
            File file = new File(args[0] + "/it/tidalwave/image/tools/TIFF.properties");
            File destFile = new File(args[1] + "/it/tidalwave/image/metadata/EXIFDirectoryGenerated.java");
            destFile.getParentFile().mkdirs();
            System.err.println("Generating " + destFile);
            BufferedReader br = new BufferedReader(new FileReader(file));
            PrintWriter pw = new PrintWriter(new FileWriter(destFile));
            StringWriter sw2 = new StringWriter();
            PrintWriter pw2 = new PrintWriter(sw2);
            StringWriter dsw = new StringWriter();
            PrintWriter dpw = new PrintWriter(dsw);
            StringWriter csw = new StringWriter();
            PrintWriter cpw = new PrintWriter(csw);
            pw.println("package it.tidalwave.image.metadata;");
            pw.println();
            pw.println("import java.util.Map;");
            pw.println("import java.util.HashMap;");
            pw.println("import java.util.NoSuchElementException;");
            pw.println("import it.tidalwave.image.Rational;");
            pw.println();
            pw.println("/* Automatically generated on " + new Date() + "*/");
            pw.println();
            pw.println("class EXIFDirectoryGenerated extends Directory");
            pw.println("  {");
            pw.println("    private final static long serialVersionUID = 2056233055989339503L;");
            pw.println("    private static Map<Integer, String> descriptionMapByTag = new HashMap<Integer, String>();");
            while ((s = br.readLine()) != null) {
                String next;
                int i = (s = s.trim()).indexOf(35);
                if (i >= 0) {
                    s = s.substring(0, i);
                }
                if ("".equals(s)) continue;
                StringTokenizer st = new StringTokenizer(s, "\t");
                int tag = Integer.parseInt(st.nextToken().trim());
                String tagName = st.nextToken().trim();
                dpw.println("        descriptionMapByTag.put(" + tag + ", \"" + tagName + "\");");
                cpw.println("        public final static int " + EXIFGenerator.strip(tagName.toUpperCase().replace(' ', '_')) + " = " + tag + ";");
                tagName = EXIFGenerator.strip(tagName);
                String type = st.nextToken().trim().toLowerCase();
                String javaType = type.toLowerCase();
                String uncapitalizedTagName = EXIFGenerator.uncapitalized(tagName);
                String capitalizedTagName = EXIFGenerator.capitalized(tagName);
                if (type.equals("ascii")) {
                    javaType = "String";
                } else if (type.equals("rational")) {
                    javaType = "Rational";
                } else if (type.equals("srational")) {
                    javaType = "Rational";
                } else if (type.equals("rational[]")) {
                    javaType = "Rational[]";
                } else if (type.equals("srational[]")) {
                    javaType = "Rational[]";
                } else if (type.equals("byte")) {
                    javaType = "int";
                } else if (type.equals("long")) {
                    javaType = "int";
                } else if (type.equals("short")) {
                    javaType = "int";
                } else if (type.equals("sshort")) {
                    javaType = "int";
                } else if (type.equals("byte[]")) {
                    javaType = "byte[]";
                } else if (type.equals("long[]")) {
                    javaType = "int[]";
                } else if (type.equals("short[]")) {
                    javaType = "int[]";
                } else if (type.equals("sshort[]")) {
                    javaType = "int[]";
                } else if (type.equals("undefined")) {
                    javaType = "int";
                } else if (type.equals("undefined[]")) {
                    javaType = "byte[]";
                }
                String javaTypeForGetter = javaType;
                if (javaTypeForGetter.equals("double")) {
                    javaTypeForGetter = "Double";
                }
                if (javaTypeForGetter.equals("byte")) {
                    javaTypeForGetter = "Byte";
                }
                if (javaTypeForGetter.equals("byte[]")) {
                    javaTypeForGetter = "ByteArray";
                }
                if (javaTypeForGetter.equals("double[]")) {
                    javaTypeForGetter = "DoubleArray";
                }
                if (javaTypeForGetter.equals("int")) {
                    javaTypeForGetter = "Integer";
                }
                if (javaTypeForGetter.equals("int[]")) {
                    javaTypeForGetter = "IntegerArray";
                }
                if (javaTypeForGetter.equals("short")) {
                    javaTypeForGetter = "Short";
                }
                if (javaTypeForGetter.equals("short[]")) {
                    javaTypeForGetter = "ShortArray";
                }
                if (javaTypeForGetter.equals("Rational[]")) {
                    javaTypeForGetter = "RationalArray";
                }
                boolean hasEnum = false;
                if (st.hasMoreElements() && (next = st.nextToken().trim()).startsWith("enum:")) {
                    st = new StringTokenizer(next, ":=,");
                    st.nextToken();
                    javaType = capitalizedTagName;
                    hasEnum = true;
                    StringBuffer buffer4 = new StringBuffer();
                    pw.println("    public static enum " + capitalizedTagName);
                    pw.println("       {");
                    do {
                        String value = st.nextToken().trim();
                        String name = st.nextToken().trim();
                        String name2 = name.replace(' ', '_').replace('-', '_').toUpperCase();
                        pw.println("         " + name2 + "(" + value + ", \"" + name + "\"),");
                        if (type.equals("undefined")) {
                            type = "byte";
                        }
                        buffer4.append("             if (value == (" + type + ")" + value + ") return " + name2 + ";\n");
                    } while (st.hasMoreTokens());
                    pw.println("         _UNKNOWN(-1, \"_unknown_\");");
                    pw.println("         private final static long serialVersionUID = 3059468666726854749L;");
                    pw.println("         private int value;");
                    pw.println("         private String name;");
                    pw.println();
                    pw.println("         private " + capitalizedTagName + " (int value, String name)");
                    pw.println("           {");
                    pw.println("             this.value = value;");
                    pw.println("             this.name = name;");
                    pw.println("           }");
                    pw.println();
                    pw.println("         public static " + capitalizedTagName + " getInstance(int value)");
                    pw.println("           {");
                    pw.println(buffer4);
                    pw.println("             return _UNKNOWN;");
                    pw.println("           }");
                    pw.println("       }");
                }
                pw.println("    public boolean is" + capitalizedTagName + "Available()");
                pw.println("      {");
                pw.println("        return strategy.containsTag(" + tag + ");");
                pw.println("      }");
                pw.println();
                pw.println("    public " + javaType + " get" + capitalizedTagName + "() throws NoSuchElementException");
                pw.println("      {");
                if (!hasEnum) {
                    pw.println("        return strategy.get" + javaTypeForGetter + "(" + tag + ");");
                } else {
                    pw.println("        return " + capitalizedTagName + ".getInstance(strategy.get" + javaTypeForGetter + "(" + tag + "));");
                }
                pw.println("      }");
                pw.println();
                pw2.println("        try {");
                pw2.println("        if (is" + capitalizedTagName + "Available())");
                pw2.println("          {");
                String toString = "get" + capitalizedTagName + "()";
                if (javaType.endsWith("[]")) {
                    toString = "toString(" + toString + ")";
                }
                pw2.println("            buffer.append(\", " + uncapitalizedTagName + ": \" + " + toString + ");");
                pw2.println("          }");
                pw2.println("        } catch (Exception e) {}");
                pw2.println();
            }
            pw2.close();
            pw.println("    public String toString()");
            pw.println("      {");
            pw.println("        StringBuffer buffer = new StringBuffer(\"EXIF[\");");
            pw.println();
            pw.println(sw2.toString());
            pw.println("        buffer.append(\"]\");");
            pw.println();
            pw.println("        return buffer.toString();");
            pw.println("      }");
            pw.println("                public String getTagName (int tag)");
            pw.println("                  {");
            pw.println("                    return (String)descriptionMapByTag.get(new Integer(tag));");
            pw.println("                  }");
            pw.println("    static");
            pw.println("      {");
            pw.println(dsw.toString());
            pw.println("      }");
            pw.println(csw.toString());
            pw.println("  }");
            br.close();
            pw.close();
        }
        catch (Exception e) {
            System.err.println("While processing " + s);
            e.printStackTrace();
        }
    }

    private static String capitalized(String tagName) {
        return tagName.substring(0, 1).toUpperCase() + tagName.substring(1);
    }

    private static String uncapitalized(String tagName) {
        return tagName.substring(0, 1).toLowerCase() + tagName.substring(1);
    }

    private static String strip(String s) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) continue;
            result.append(c);
        }
        return result.toString();
    }
}

