/*
 * (C) Copyright 2006-2010 Nuxeo SAS (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     bstefanescu
 */
package org.nuxeo.gwt.habyt.upload.client.core.impl;

import org.nuxeo.gwt.habyt.upload.client.core.InputFileWrapper;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Widget;

/**
 * Send a click event to a hidden input file when click widget is clicked.
 * Supported only on browsers that supports programmatic click on input file
 * such as ie and safari.
 * 
 * @author <a href="mailto:bs@nuxeo.com">Bogdan Stefanescu</a>
 * 
 */
public class InputFileWrapperWithClick extends InputFileWrapper implements
        ClickHandler {

    public InputFileWrapperWithClick() {
    }

    public void setVisibleWidget(Widget w) {
        super.setVisibleWidget(w);
        DOM.setStyleAttribute(fu.getElement(), "position", "absolute");
        DOM.setStyleAttribute(fu.getElement(), "left", "-10000px");
        if (w instanceof HasClickHandlers == false) {
            throw new IllegalArgumentException(
                    "File widget not supported - it must implement HasClickHandlers");
        }
        ((HasClickHandlers) w).addClickHandler(this);
    }

    public void dispose() {
    }

    @Override
    public void onClick(ClickEvent event) {
        sendOnCLick(fu.getElement());
    }

    private static native void sendOnCLick(Element target) /*-{
        target.click();
    }-*/;

}
