/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.tokens;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialStore;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.oauth2.tokens.NuxeoOAuth2Token;
import org.nuxeo.runtime.api.Framework;

public class OAuth2TokenStore
implements CredentialStore {
    protected static final Log log = LogFactory.getLog(OAuth2TokenStore.class);
    public static final String DIRECTORY_NAME = "oauth2Tokens";
    private String serviceName;

    public OAuth2TokenStore(String serviceName) {
        this.serviceName = serviceName;
    }

    public void store(String userId, Credential credential) {
        NuxeoOAuth2Token token = new NuxeoOAuth2Token(credential);
        token.setServiceName(this.serviceName);
        token.setNuxeoLogin(userId);
        try {
            this.storeTokenAsDirectoryEntry(token);
        }
        catch (Exception e) {
            log.error((Object)"Error during token storage", (Throwable)e);
        }
    }

    public void delete(String userId, Credential credential) {
    }

    public boolean load(String userName, Credential credential) {
        try {
            NuxeoOAuth2Token token = this.getToken(this.serviceName, userName);
            credential.setAccessToken(token.getAccessToken());
            credential.setRefreshToken(token.getRefreshToken());
            credential.setExpirationTimeMilliseconds(token.getExpirationTimeMilliseconds());
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Error during token loading", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NuxeoOAuth2Token getToken(String serviceName, String nuxeoLogin) throws Exception {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = null;){
            session = ds.open(DIRECTORY_NAME);
            HashMap<String, String> filter = new HashMap<String, String>();
            filter.put("serviceName", serviceName);
            filter.put("nuxeoLogin", nuxeoLogin);
            DocumentModelList entries = session.query(filter);
            if (entries.size() == 0) {
                NuxeoOAuth2Token nuxeoOAuth2Token = null;
                return nuxeoOAuth2Token;
            }
            if (entries.size() > 1) {
                log.error((Object)"Found several tokens");
            }
            NuxeoOAuth2Token nuxeoOAuth2Token = this.getTokenFromDirectoryEntry((DocumentModel)entries.get(0));
            return nuxeoOAuth2Token;
        }
    }

    protected NuxeoOAuth2Token getTokenFromDirectoryEntry(DocumentModel entry) throws ClientException {
        return new NuxeoOAuth2Token(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NuxeoOAuth2Token storeTokenAsDirectoryEntry(NuxeoOAuth2Token aToken) throws Exception {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = null;){
            session = ds.open(DIRECTORY_NAME);
            DocumentModel entry = session.createEntry(aToken.toMap());
            session.updateEntry(entry);
            NuxeoOAuth2Token nuxeoOAuth2Token = this.getToken(this.serviceName, aToken.getNuxeoLogin());
            return nuxeoOAuth2Token;
        }
    }
}

