/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lang.html;

import com.google.caja.config.AllowedFileResolver;
import com.google.caja.config.ConfigUtil;
import com.google.caja.lang.html.HTML;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.HtmlTextEscapingMode;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.ParseTreeNodeContainer;
import com.google.caja.parser.html.AttribKey;
import com.google.caja.parser.html.ElKey;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.IntegerLiteral;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.reporting.EchoingMessageQueue;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.RenderContext;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.caja.tools.BuildCommand;
import com.google.caja.util.Maps;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HtmlDefinitions {
    private static final AttribKey SCRIPT_SRC = AttribKey.forHtmlAttrib(ElKey.forHtmlElement("script"), "src");
    private static final Map<HTML.Attribute.Type, Integer> A_TYPE_MAP = new EnumMap<HTML.Attribute.Type, Integer>(HTML.Attribute.Type.class);

    public static Block generateJavascriptDefinitions(HtmlSchema schema) {
        FilePosition unk = FilePosition.UNKNOWN;
        Map<AttribKey, HTML.Attribute.Type> atypes = HtmlDefinitions.attributeTypes(schema);
        Map<ElKey, EnumSet<EFlag>> eflags = HtmlDefinitions.elementFlags(schema);
        Block definitions = new Block();
        definitions.appendChild(QuasiBuilder.substV("var html4 = {};", new Object[0]));
        EnumSet<HTML.Attribute.Type> atypesUsed = EnumSet.noneOf(HTML.Attribute.Type.class);
        atypesUsed.addAll(atypes.values());
        ArrayList<StringLiteral> keys = new ArrayList<StringLiteral>();
        ArrayList<IntegerLiteral> values = new ArrayList<IntegerLiteral>();
        for (HTML.Attribute.Type type : atypesUsed) {
            keys.add(StringLiteral.valueOf(unk, type.name()));
            values.add(new IntegerLiteral(unk, A_TYPE_MAP.get((Object)type).intValue()));
        }
        definitions.appendChild(new ExpressionStmt(unk, (Expression)QuasiBuilder.substV("html4.atype = { @k*: @v* };", "k", new ParseTreeNodeContainer(keys), "v", new ParseTreeNodeContainer(values))));
        keys = new ArrayList();
        values = new ArrayList();
        for (Map.Entry entry : atypes.entrySet()) {
            AttribKey attribKey = (AttribKey)entry.getKey();
            if (!ElKey.HTML_WILDCARD.equals(attribKey.el) && !schema.isElementAllowed(attribKey.el) && !SCRIPT_SRC.equals(attribKey)) continue;
            keys.add(StringLiteral.valueOf(unk, attribKey.toString()));
            values.add(new IntegerLiteral(unk, A_TYPE_MAP.get(entry.getValue()).intValue()));
        }
        definitions.appendChild(new ExpressionStmt(unk, (Expression)QuasiBuilder.substV("html4.ATTRIBS = { @k*: @v* };", "k", new ParseTreeNodeContainer(keys), "v", new ParseTreeNodeContainer(values))));
        EnumSet<EFlag> eflagsUsed = EnumSet.noneOf(EFlag.class);
        for (EnumSet<EFlag> flags : eflags.values()) {
            eflagsUsed.addAll(flags);
        }
        ArrayList<StringLiteral> keys2 = new ArrayList<StringLiteral>();
        ArrayList<IntegerLiteral> values2 = new ArrayList<IntegerLiteral>();
        for (EFlag eFlag : eflagsUsed) {
            keys2.add(StringLiteral.valueOf(unk, eFlag.name()));
            values2.add(new IntegerLiteral(unk, eFlag.bitMask));
        }
        definitions.appendChild(new ExpressionStmt(unk, (Expression)QuasiBuilder.substV("html4.eflags = { @k*: @v* };", "k", new ParseTreeNodeContainer(keys2), "v", new ParseTreeNodeContainer(values2))));
        ArrayList<StringLiteral> keys3 = new ArrayList<StringLiteral>();
        ArrayList<IntegerLiteral> values3 = new ArrayList<IntegerLiteral>();
        for (Map.Entry<ElKey, EnumSet<EFlag>> entry : eflags.entrySet()) {
            ElKey key = entry.getKey();
            int value = 0;
            for (EFlag f : entry.getValue()) {
                value |= f.bitMask;
            }
            keys3.add(StringLiteral.valueOf(unk, key.toString()));
            values3.add(new IntegerLiteral(unk, value));
        }
        definitions.appendChild(new ExpressionStmt(unk, (Expression)QuasiBuilder.substV("html4.ELEMENTS = { @k*: @v* };", "k", new ParseTreeNodeContainer(keys3), "v", new ParseTreeNodeContainer(values3))));
        return definitions;
    }

    public static int getJavascriptValueForAType(HTML.Attribute.Type atype) {
        return A_TYPE_MAP.get((Object)atype);
    }

    private static Map<AttribKey, HTML.Attribute.Type> attributeTypes(HtmlSchema schema) {
        SortedMap<AttribKey, HTML.Attribute.Type> attributeFlags = Maps.newTreeMap();
        for (AttribKey attribKey : schema.getAttributeNames()) {
            if (!schema.isAttributeAllowed(attribKey)) continue;
            HTML.Attribute a = schema.lookupAttribute(attribKey);
            HTML.Attribute.Type type = a.getType();
            attributeFlags.put(attribKey, type);
        }
        return attributeFlags;
    }

    private static Map<ElKey, EnumSet<EFlag>> elementFlags(HtmlSchema schema) {
        ElKey SCRIPT = ElKey.forHtmlElement("script");
        ElKey STYLE = ElKey.forHtmlElement("style");
        SortedMap<ElKey, EnumSet<EFlag>> elementFlags = Maps.newTreeMap();
        for (ElKey elementName : schema.getElementNames()) {
            HTML.Element el = schema.lookupElement(elementName);
            EnumSet<EFlag> flags = EnumSet.noneOf(EFlag.class);
            if (el.isEndTagOptional()) {
                flags.add(EFlag.OPTIONAL_ENDTAG);
            }
            if (el.isEmpty()) {
                flags.add(EFlag.EMPTY);
            }
            if (elementName.isHtml()) {
                switch (HtmlTextEscapingMode.getModeForTag(elementName.localName)) {
                    case CDATA: {
                        flags.add(EFlag.CDATA);
                        break;
                    }
                    case RCDATA: {
                        flags.add(EFlag.RCDATA);
                        break;
                    }
                }
            }
            if (!schema.isElementAllowed(elementName)) {
                flags.add(EFlag.UNSAFE);
                if (SCRIPT.equals(elementName)) {
                    flags.add(EFlag.SCRIPT);
                } else if (STYLE.equals(elementName)) {
                    flags.add(EFlag.STYLE);
                }
            }
            if (HtmlSchema.isElementFoldable(elementName)) {
                flags.add(EFlag.FOLDABLE);
            }
            elementFlags.put(elementName, flags);
        }
        return elementFlags;
    }

    public static void main(String[] args) {
        HtmlSchema schema = HtmlSchema.getDefault(new SimpleMessageQueue());
        Block node = HtmlDefinitions.generateJavascriptDefinitions(schema);
        RenderContext rc = new RenderContext(node.makeRenderer(System.out, null));
        for (Statement statement : node.children()) {
            statement.render(rc);
            if (statement.isTerminal()) continue;
            rc.getOut().consume(";");
        }
        rc.getOut().noMoreTokens();
    }

    static {
        A_TYPE_MAP.put(HTML.Attribute.Type.NONE, 0);
        A_TYPE_MAP.put(HTML.Attribute.Type.URI, 1);
        A_TYPE_MAP.put(HTML.Attribute.Type.SCRIPT, 2);
        A_TYPE_MAP.put(HTML.Attribute.Type.STYLE, 3);
        A_TYPE_MAP.put(HTML.Attribute.Type.ID, 4);
        A_TYPE_MAP.put(HTML.Attribute.Type.IDREF, 5);
        A_TYPE_MAP.put(HTML.Attribute.Type.IDREFS, 6);
        A_TYPE_MAP.put(HTML.Attribute.Type.GLOBAL_NAME, 7);
        A_TYPE_MAP.put(HTML.Attribute.Type.LOCAL_NAME, 8);
        A_TYPE_MAP.put(HTML.Attribute.Type.CLASSES, 9);
        A_TYPE_MAP.put(HTML.Attribute.Type.FRAME_TARGET, 10);
        A_TYPE_MAP.put(HTML.Attribute.Type.URI_FRAGMENT, 11);
        for (HTML.Attribute.Type t : HTML.Attribute.Type.values()) {
            if (A_TYPE_MAP.containsKey((Object)t)) continue;
            throw new IllegalStateException("Not all Attribute Types mapped");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements BuildCommand {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean build(List<File> inputs, List<File> deps, File output) throws IOException {
            HtmlSchema schema;
            File elementsFile = null;
            File attrsFile = null;
            for (File input : inputs) {
                if (!input.getName().endsWith(".json")) continue;
                if (elementsFile == null) {
                    elementsFile = input;
                    continue;
                }
                if (attrsFile == null) {
                    attrsFile = input;
                    continue;
                }
                throw new IOException("Unused input " + input);
            }
            if (elementsFile == null) {
                throw new IOException("No JSON whitelist for HTML elements");
            }
            if (attrsFile == null) {
                throw new IOException("No JSON whitelist for HTML attributes");
            }
            FilePosition elements = FilePosition.startOfFile(new InputSource(elementsFile.getAbsoluteFile().toURI()));
            FilePosition attrs = FilePosition.startOfFile(new InputSource(attrsFile.getAbsoluteFile().toURI()));
            MessageContext mc = new MessageContext();
            mc.addInputSource(elements.source());
            mc.addInputSource(attrs.source());
            EchoingMessageQueue mq = new EchoingMessageQueue(new PrintWriter((Writer)new OutputStreamWriter(System.err), true), mc, false);
            HashSet<File> inputsAndDeps = new HashSet<File>();
            for (File f : inputs) {
                inputsAndDeps.add(f.getAbsoluteFile());
            }
            for (File f : deps) {
                inputsAndDeps.add(f.getAbsoluteFile());
            }
            AllowedFileResolver resolver = new AllowedFileResolver(inputsAndDeps);
            try {
                schema = new HtmlSchema(ConfigUtil.loadWhiteListFromJson(elements.source().getUri(), resolver, mq), ConfigUtil.loadWhiteListFromJson(attrs.source().getUri(), resolver, mq));
            }
            catch (ParseException ex) {
                ex.toMessageQueue(mq);
                throw (IOException)new IOException("Failed to parse schema").initCause(ex);
            }
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(output), "UTF-8");
            String currentDate = "" + new Date();
            if (currentDate.indexOf("*/") >= 0) {
                throw new RuntimeException();
            }
            out.write("/* Copyright Google Inc.\n");
            out.write(" * Licensed under the Apache Licence Version 2.0\n");
            out.write(" * Autogenerated at " + currentDate + "\n");
            out.write(" * @provides html4\n");
            out.write(" */\n");
            try {
                Block node = HtmlDefinitions.generateJavascriptDefinitions(schema);
                RenderContext rc = new RenderContext(node.makeRenderer(out, null));
                for (Statement statement : node.children()) {
                    statement.render(rc);
                    if (statement.isTerminal()) continue;
                    rc.getOut().consume(";");
                }
                rc.getOut().noMoreTokens();
            }
            finally {
                ((Writer)out).close();
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EFlag {
        OPTIONAL_ENDTAG(1),
        EMPTY(2),
        CDATA(4),
        RCDATA(8),
        UNSAFE(16),
        FOLDABLE(32),
        SCRIPT(64),
        STYLE(128);

        public final int bitMask;

        private EFlag(int bitMask) {
            this.bitMask = bitMask;
        }
    }
}

