/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.css.CssTree;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.UncajoledModule;
import com.google.caja.plugin.Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Job {
    private final AncestorChain<?> root;
    private final JobType type;

    public Job(AncestorChain<?> root) {
        assert (root != null);
        this.root = root;
        Object rootNode = root.node;
        if (rootNode instanceof Statement || rootNode instanceof Expression || rootNode instanceof UncajoledModule || rootNode instanceof CajoledModule) {
            this.type = JobType.JAVASCRIPT;
        } else if (rootNode instanceof Dom) {
            this.type = JobType.HTML;
        } else if (rootNode instanceof CssTree.StyleSheet) {
            this.type = JobType.CSS;
        } else {
            throw new RuntimeException("Unknown input type " + rootNode);
        }
    }

    public AncestorChain<?> getRoot() {
        return this.root;
    }

    public JobType getType() {
        return this.type;
    }

    public String toString() {
        return "(Job " + this.getType().name() + " " + this.getRoot() + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JobType {
        CSS,
        JAVASCRIPT,
        HTML;

    }
}

