/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center.dashboard;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.spaces.api.AbstractSpaceProvider;
import org.nuxeo.ecm.spaces.api.Space;
import org.nuxeo.ecm.spaces.api.exceptions.SpaceException;
import org.nuxeo.ecm.user.center.dashboard.DefaultDashboardSpaceCreator;

public class DefaultDashboardSpaceProvider
extends AbstractSpaceProvider {
    private static final Log log = LogFactory.getLog(DefaultDashboardSpaceProvider.class);

    protected Space doGetSpace(CoreSession session, DocumentModel contextDocument, String spaceName, Map<String, String> parameters) throws SpaceException {
        try {
            return this.getOrCreateSpace(session, parameters);
        }
        catch (ClientException e) {
            log.error((Object)"Unable to create or get default dashboard", (Throwable)e);
            return null;
        }
    }

    protected Space getOrCreateSpace(CoreSession session, Map<String, String> parameters) throws ClientException {
        PathRef spaceRef = new PathRef("/management/dashboard-management", "defaultDashboardSpace");
        if (session.exists((DocumentRef)spaceRef)) {
            DocumentModel existingSpace = session.getDocument((DocumentRef)spaceRef);
            return (Space)existingSpace.getAdapter(Space.class);
        }
        DocumentRef defaultDashboardSpaceRef = this.getOrCreateDefaultDashboardSpace(session, parameters);
        DocumentModel defaultDashboardSpace = session.getDocument(defaultDashboardSpaceRef);
        return (Space)defaultDashboardSpace.getAdapter(Space.class);
    }

    protected DocumentRef getOrCreateDefaultDashboardSpace(CoreSession session, Map<String, String> parameters) throws ClientException {
        DefaultDashboardSpaceCreator defaultDashboardSpaceCreator = new DefaultDashboardSpaceCreator(session, parameters);
        defaultDashboardSpaceCreator.runUnrestricted();
        return defaultDashboardSpaceCreator.defaultDashboardSpaceRef;
    }

    public boolean isReadOnly(CoreSession session) {
        return true;
    }
}

