/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.LoginContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.tag.Tag;
import org.nuxeo.ecm.platform.tag.TagService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class TagServiceImpl
extends DefaultComponent
implements TagService {
    private static final Log log = LogFactory.getLog(TagServiceImpl.class);
    public static final String NXTAG = "NXTAG";
    private Boolean enabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        if (this.enabled == null) {
            this.enabled = Boolean.FALSE;
            LoginContext lc = null;
            try {
                lc = Framework.login();
                RepositoryManager rm = (RepositoryManager)Framework.getService(RepositoryManager.class);
                if (rm.getDefaultRepository().supportsTags()) {
                    log.debug((Object)"Activating TagService");
                    this.enabled = Boolean.TRUE;
                } else {
                    log.warn((Object)"Default repository does not support Tag feature: Tag service won't be available.");
                }
            }
            catch (Exception e) {
                log.error((Object)"Unable to test repository for Tag feature.", (Throwable)e);
            }
            finally {
                if (lc != null) {
                    try {
                        lc.logout();
                    }
                    catch (Exception e) {
                        log.error((Object)e, (Throwable)e);
                    }
                }
            }
        }
        return this.enabled;
    }

    protected static String getUsername(CoreSession session) throws ClientException {
        if (session == null) {
            throw new ClientException("No session available");
        }
        return session.getPrincipal().getName().replace("'", "");
    }

    protected static String cleanLabel(String label, boolean allowPercent) throws ClientException {
        if (label == null) {
            throw new ClientException("Invalid empty tag");
        }
        label = label.toLowerCase();
        label = label.replace(" ", "");
        label = label.replace("\\", "");
        label = label.replace("'", "");
        if (!allowPercent) {
            label = label.replace("%", "");
        }
        if (label.length() == 0) {
            throw new ClientException("Invalid empty tag");
        }
        return label;
    }

    public void tag(CoreSession session, String docId, String label, String username) throws ClientException {
        UnrestrictedAddTagging r = new UnrestrictedAddTagging(session, docId, label, username);
        r.runUnrestricted();
    }

    public void untag(CoreSession session, String docId, String label, String username) throws ClientException {
        UnrestrictedRemoveTagging r = new UnrestrictedRemoveTagging(session, docId, label, username);
        r.runUnrestricted();
    }

    public List<Tag> getDocumentTags(CoreSession session, String docId, String username) throws ClientException {
        UnrestrictedGetDocumentTags r = new UnrestrictedGetDocumentTags(session, docId, username);
        r.runUnrestricted();
        return r.tags;
    }

    public void removeTags(CoreSession session, String docId) throws ClientException {
        this.untag(session, docId, null, null);
    }

    public void copyTags(CoreSession session, String srcDocId, String dstDocId) throws ClientException {
        this.copyTags(session, srcDocId, dstDocId, false);
    }

    protected void copyTags(CoreSession session, String srcDocId, String dstDocId, boolean removeExistingTags) throws ClientException {
        if (removeExistingTags) {
            this.removeTags(session, dstDocId);
        }
        UnrestrictedCopyTags r = new UnrestrictedCopyTags(session, srcDocId, dstDocId);
        r.runUnrestricted();
    }

    public void replaceTags(CoreSession session, String srcDocId, String dstDocId) throws ClientException {
        this.copyTags(session, srcDocId, dstDocId, true);
    }

    public List<String> getTagDocumentIds(CoreSession session, String label, String username) throws ClientException {
        UnrestrictedGetTagDocumentIds r = new UnrestrictedGetTagDocumentIds(session, label, username);
        r.runUnrestricted();
        return r.docIds;
    }

    public List<Tag> getTagCloud(CoreSession session, String docId, String username, Boolean normalize) throws ClientException {
        UnrestrictedGetDocumentCloud r = new UnrestrictedGetDocumentCloud(session, docId, username, normalize);
        r.runUnrestricted();
        return r.cloud;
    }

    public static void normalizeCloud(List<Tag> cloud, int min, int max, boolean linear) {
        double diff;
        double nmin;
        if (min == max) {
            for (Tag tag : cloud) {
                tag.setWeight(100L);
            }
            return;
        }
        if (linear) {
            nmin = min;
            diff = max - min;
        } else {
            nmin = Math.log(min);
            diff = Math.log(max) - nmin;
        }
        for (Tag tag : cloud) {
            long weight = tag.getWeight();
            double norm = linear ? ((double)weight - nmin) / diff : (Math.log(weight) - nmin) / diff;
            tag.setWeight(Math.round(100.0 * norm));
        }
    }

    public List<Tag> getSuggestions(CoreSession session, String label, String username) throws ClientException {
        UnrestrictedGetTagSuggestions r = new UnrestrictedGetTagSuggestions(session, label, username);
        r.runUnrestricted();
        return r.tags;
    }

    protected static class UnrestrictedGetTagSuggestions
    extends UnrestrictedSessionRunner {
        protected final String label;
        protected final String username;
        protected final List<Tag> tags;

        protected UnrestrictedGetTagSuggestions(CoreSession session, String label, String username) throws ClientException {
            super(session);
            label = TagServiceImpl.cleanLabel(label, true);
            if (!label.contains("%")) {
                label = label + "%";
            }
            this.label = label;
            this.username = username == null ? null : username.replace("'", "");
            this.tags = new ArrayList<Tag>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws ClientException {
            String query = String.format("SELECT DISTINCT tag:label FROM Tag WHERE tag:label LIKE '%s' AND ecm:isProxy = 0", this.label);
            if (this.username != null) {
                query = query + String.format(" AND dc:creator = '%s'", this.username);
            }
            try (IterableQueryResult res = this.session.queryAndFetch(query, "NXQL", new Object[0]);){
                for (Map map : res) {
                    String label = (String)map.get("tag:label");
                    this.tags.add(new Tag(label, 0));
                }
            }
            Collections.sort(this.tags, Tag.LABEL_COMPARATOR);
        }
    }

    protected static class UnrestrictedGetDocumentCloud
    extends UnrestrictedSessionRunner {
        protected final String docId;
        protected final String username;
        protected final List<Tag> cloud;
        protected final Boolean normalize;

        protected UnrestrictedGetDocumentCloud(CoreSession session, String docId, String username, Boolean normalize) throws ClientException {
            super(session);
            this.docId = docId;
            this.username = username == null ? null : username.replace("'", "");
            this.normalize = normalize;
            this.cloud = new ArrayList<Tag>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws ClientException {
            String query = "COUNTSOURCE: SELECT tag:label, relation:source FROM Tagging";
            if (this.docId != null) {
                String path = this.session.getDocument((DocumentRef)new IdRef(this.docId)).getPathAsString();
                path = path.replace("'", "");
                String q = String.format("SELECT ecm:uuid FROM Document WHERE ecm:path STARTSWITH '%s'", path);
                ArrayList<String> docIds = new ArrayList<String>();
                docIds.add(this.docId);
                try (IterableQueryResult r = this.session.queryAndFetch(q, "NXQL", new Object[0]);){
                    for (Map map : r) {
                        docIds.add((String)map.get("ecm:uuid"));
                    }
                }
                query = query + String.format(" WHERE relation:source IN ('%s')", StringUtils.join(docIds, (String)"', '"));
            }
            if (this.username != null) {
                query = this.docId == null ? query + " WHERE " : query + " AND ";
                query = query + String.format("dc:creator = '%s'", this.username);
            }
            int min = 999999;
            int max = 0;
            try (IterableQueryResult res = this.session.queryAndFetch(query, TagServiceImpl.NXTAG, new Object[0]);){
                for (Map map : res) {
                    String label = (String)map.get("tag:label");
                    int weight = ((Long)map.get("relation:source")).intValue();
                    if (weight == 0) continue;
                    if (weight > max) {
                        max = weight;
                    }
                    if (weight < min) {
                        min = weight;
                    }
                    Tag weightedTag = new Tag(label, weight);
                    this.cloud.add(weightedTag);
                }
            }
            if (this.normalize != null) {
                TagServiceImpl.normalizeCloud(this.cloud, min, max, this.normalize == false);
            }
        }
    }

    protected static class UnrestrictedGetTagDocumentIds
    extends UnrestrictedSessionRunner {
        protected final String label;
        protected final String username;
        protected final List<String> docIds;

        protected UnrestrictedGetTagDocumentIds(CoreSession session, String label, String username) throws ClientException {
            super(session);
            this.label = TagServiceImpl.cleanLabel(label, false);
            this.username = username == null ? null : username.replace("'", "");
            this.docIds = new ArrayList<String>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws ClientException {
            String query = String.format("TAGISTARGET: SELECT DISTINCT relation:source FROM Tagging WHERE tag:label = '%s'", this.label);
            if (this.username != null) {
                query = query + String.format(" AND dc:creator = '%s'", this.username);
            }
            try (IterableQueryResult res = this.session.queryAndFetch(query, TagServiceImpl.NXTAG, new Object[0]);){
                for (Map map : res) {
                    this.docIds.add((String)map.get("relation:source"));
                }
            }
        }
    }

    protected static class UnrestrictedCopyTags
    extends UnrestrictedSessionRunner {
        protected final String srcDocId;
        protected final String dstDocId;

        protected UnrestrictedCopyTags(CoreSession session, String srcDocId, String dstDocId) throws ClientException {
            super(session);
            this.srcDocId = srcDocId;
            this.dstDocId = dstDocId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws ClientException {
            HashSet<String> existingTags = new HashSet<String>();
            String dstTagsQuery = String.format("TAGISTARGET: SELECT tag:label, dc:created, dc:creator, relation:target FROM Tagging WHERE relation:source = '%s'", this.dstDocId);
            try (IterableQueryResult dstTagsRes = this.session.queryAndFetch(dstTagsQuery, TagServiceImpl.NXTAG, new Object[0]);){
                for (Map map : dstTagsRes) {
                    existingTags.add(String.format("%s/%s", map.get("tag:label"), map.get("dc:creator")));
                }
            }
            String srcTagsQuery = String.format("TAGISTARGET: SELECT tag:label, dc:created, dc:creator, relation:target FROM Tagging WHERE relation:source = '%s'", this.srcDocId);
            try (IterableQueryResult srcTagsRes = this.session.queryAndFetch(srcTagsQuery, TagServiceImpl.NXTAG, new Object[0]);){
                for (Map map : srcTagsRes) {
                    String key = String.format("%s/%s", map.get("tag:label"), map.get("dc:creator"));
                    if (existingTags.contains(key)) continue;
                    DocumentModel tagging = this.session.createDocumentModel(null, (String)map.get("tag:label"), "Tagging");
                    tagging.setPropertyValue("dc:created", (Serializable)map.get("dc:created"));
                    tagging.setPropertyValue("dc:creator", (Serializable)map.get("dc:creator"));
                    tagging.setPropertyValue("relation:source", (Serializable)((Object)this.dstDocId));
                    tagging.setPropertyValue("relation:target", (Serializable)map.get("relation:target"));
                    this.session.createDocument(tagging);
                }
            }
        }
    }

    protected static class UnrestrictedGetDocumentTags
    extends UnrestrictedSessionRunner {
        protected final String docId;
        protected final String username;
        protected final List<Tag> tags;

        protected UnrestrictedGetDocumentTags(CoreSession session, String docId, String username) throws ClientException {
            super(session);
            this.docId = docId;
            this.username = username == null ? null : username.replace("'", "");
            this.tags = new ArrayList<Tag>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws ClientException {
            String query = String.format("TAGISTARGET: SELECT DISTINCT tag:label FROM Tagging WHERE relation:source = '%s'", this.docId);
            if (this.username != null) {
                query = query + String.format(" AND dc:creator = '%s'", this.username);
            }
            try (IterableQueryResult res = this.session.queryAndFetch(query, TagServiceImpl.NXTAG, new Object[0]);){
                for (Map map : res) {
                    String label = (String)map.get("tag:label");
                    this.tags.add(new Tag(label, 0));
                }
            }
        }
    }

    protected static class UnrestrictedRemoveTagging
    extends UnrestrictedSessionRunner {
        private final String docId;
        private final String label;
        private final String username;

        protected UnrestrictedRemoveTagging(CoreSession session, String docId, String label, String username) throws ClientException {
            super(session);
            this.docId = docId;
            this.label = label == null ? null : TagServiceImpl.cleanLabel(label, false);
            this.username = username == null ? null : username.replace("'", "");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws ClientException {
            String tagId = null;
            if (this.label != null) {
                String query = String.format("SELECT ecm:uuid FROM Tag WHERE tag:label = '%s' AND ecm:isProxy = 0", this.label);
                try (IterableQueryResult res = this.session.queryAndFetch(query, "NXQL", new Object[0]);){
                    Iterator i$ = res.iterator();
                    if (i$.hasNext()) {
                        Map map = (Map)i$.next();
                        tagId = (String)map.get("ecm:uuid");
                    }
                }
                if (tagId == null) {
                    return;
                }
            }
            HashSet<String> taggingIds = new HashSet<String>();
            String query = String.format("SELECT ecm:uuid FROM Tagging WHERE relation:source = '%s'", this.docId);
            if (tagId != null) {
                query = query + String.format(" AND relation:target = '%s'", tagId);
            }
            if (this.username != null) {
                query = query + String.format(" AND dc:creator = '%s'", this.username);
            }
            try (IterableQueryResult res = this.session.queryAndFetch(query, "NXQL", new Object[0]);){
                for (Map map : res) {
                    taggingIds.add((String)map.get("ecm:uuid"));
                }
            }
            for (String taggingId : taggingIds) {
                this.session.removeDocument((DocumentRef)new IdRef(taggingId));
            }
            if (!taggingIds.isEmpty()) {
                this.session.save();
            }
        }
    }

    protected static class UnrestrictedAddTagging
    extends UnrestrictedSessionRunner {
        private final String docId;
        private final String label;
        private final String username;

        protected UnrestrictedAddTagging(CoreSession session, String docId, String label, String username) throws ClientException {
            super(session);
            this.docId = docId;
            this.label = TagServiceImpl.cleanLabel(label, false);
            this.username = username == null ? null : username.replace("'", "");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws ClientException {
            String tagId = null;
            String query = String.format("SELECT ecm:uuid FROM Tag WHERE tag:label = '%s' AND ecm:isProxy = 0", this.label);
            try (IterableQueryResult res = this.session.queryAndFetch(query, "NXQL", new Object[0]);){
                Iterator i$ = res.iterator();
                if (i$.hasNext()) {
                    Map map = (Map)i$.next();
                    tagId = (String)map.get("ecm:uuid");
                }
            }
            Calendar date = Calendar.getInstance();
            if (tagId == null) {
                DocumentModel tag = this.session.createDocumentModel(null, this.label, "Tag");
                tag.setPropertyValue("dc:created", (Serializable)date);
                tag.setPropertyValue("tag:label", (Serializable)((Object)this.label));
                tag = this.session.createDocument(tag);
                tagId = tag.getId();
            }
            query = String.format("SELECT ecm:uuid FROM Tagging WHERE relation:source = '%s'  AND relation:target = '%s'", this.docId, tagId);
            if (this.username != null) {
                query = query + String.format(" AND dc:creator = '%s'", this.username);
            }
            res = this.session.queryAndFetch(query, "NXQL", new Object[0]);
            try {
                if (res.iterator().hasNext()) {
                    return;
                }
            }
            finally {
                res.close();
            }
            DocumentModel tagging = this.session.createDocumentModel(null, this.label, "Tagging");
            tagging.setPropertyValue("dc:created", (Serializable)date);
            if (this.username != null) {
                tagging.setPropertyValue("dc:creator", (Serializable)((Object)this.username));
            }
            tagging.setPropertyValue("relation:source", (Serializable)((Object)this.docId));
            tagging.setPropertyValue("relation:target", (Serializable)((Object)tagId));
            this.session.createDocument(tagging);
            this.session.save();
        }
    }
}

