/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitFilteringEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.tag.TagService;
import org.nuxeo.runtime.api.Framework;

public class TaggedVersionListener
implements PostCommitFilteringEventListener {
    public void handleEvent(EventBundle events) throws ClientException {
        for (Event event : events) {
            if (!this.acceptEvent(event)) continue;
            this.handleEvent(event);
        }
    }

    protected void handleEvent(Event event) throws ClientException {
        EventContext ctx = event.getContext();
        if (ctx instanceof DocumentEventContext) {
            String name = event.getName();
            DocumentEventContext docCtx = (DocumentEventContext)ctx;
            CoreSession session = docCtx.getCoreSession();
            DocumentModel doc = docCtx.getSourceDocument();
            if (doc == null) {
                return;
            }
            String docId = doc.getId();
            TagService tagService = (TagService)Framework.getLocalService(TagService.class);
            switch (name) {
                case "documentCheckedIn": {
                    DocumentRef versionRef = (DocumentRef)ctx.getProperty("checkedInVersionRef");
                    if (!(versionRef instanceof IdRef)) break;
                    tagService.copyTags(session, docId, versionRef.toString());
                    session.save();
                    break;
                }
                case "documentProxyPublished": {
                    if (!doc.isProxy()) break;
                    DocumentModel version = session.getSourceDocument(doc.getRef());
                    tagService.copyTags(session, version.getId(), docId);
                    session.save();
                    break;
                }
                case "documentRestored": {
                    String versionUUID = (String)((Object)ctx.getProperty("RESTORED_VERSION_UUID"));
                    tagService.replaceTags(session, versionUUID, docId);
                    session.save();
                    break;
                }
            }
        }
    }

    public boolean acceptEvent(Event event) {
        String name = event.getName();
        return "documentCheckedIn".equals(name) || "documentProxyPublished".equals(name) || "documentRestored".equals(name);
    }
}

