/*
 * (C) Copyright 2006-2010 Nuxeo SAS (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     bstefanescu
 */
package org.nuxeo.gwt.habyt.upload.client.core.impl;

import org.nuxeo.gwt.habyt.upload.client.core.InputFileWrapper;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style.Cursor;
import com.google.gwt.dom.client.Style.Position;
import com.google.gwt.dom.client.Style.Unit;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Event.NativePreviewEvent;
import com.google.gwt.user.client.Event.NativePreviewHandler;
import com.google.gwt.user.client.ui.Widget;

/**
 * Use a transparent input control which is hidden and which is displayed on top
 * of the click widget when mouse cursor enter the widget. Should work on most
 * javascript enabled browsers - both there are styling issues on some (e.g. on
 * ff you cannot change the cursor style)
 * 
 * @author <a href="mailto:bs@nuxeo.com">Bogdan Stefanescu</a>
 * 
 */
public class DefaultInputFileWrapper extends InputFileWrapper implements
        NativePreviewHandler {

    protected HandlerRegistration hr;

    public void setVisibleWidget(Widget w) {
        super.setVisibleWidget(w);
        fu.getElement().getStyle().setPosition(Position.ABSOLUTE);
        fu.getElement().getStyle().setCursor(Cursor.POINTER);
        fu.getElement().getStyle().setOpacity(0);
        fu.setVisible(false);
    }

    public void dispose() {
        if (hr != null) {
            hr.removeHandler();
            hr = null;
        }
    }

    @Override
    protected void onLoad() {
        fu.getElement().getStyle().setLeft(widget.getAbsoluteLeft(), Unit.PX);
        fu.getElement().getStyle().setTop(widget.getAbsoluteTop(), Unit.PX);
        fu.getElement().getStyle().setWidth(widget.getOffsetWidth(), Unit.PX);
        fu.getElement().getStyle().setHeight(widget.getOffsetHeight(), Unit.PX);
        hr = Event.addNativePreviewHandler(this);
    }

    @Override
    protected void onUnload() {
        dispose();
    }

    @Override
    public void onPreviewNativeEvent(NativePreviewEvent event) {
        if (event.getTypeInt() == Event.ONMOUSEMOVE) {
            int x = getRelativeX(event.getNativeEvent().getClientX(),
                    widget.getElement());
            int y = getRelativeY(event.getNativeEvent().getClientY(),
                    widget.getElement());
            if (x < 0 || y < 0 || x > widget.getOffsetWidth()
                    || y > widget.getOffsetHeight()) {
                // System.out.println("OUTSIDE");
                fu.setVisible(false);
            } else {
                // System.out.println("INSIDE");
                fu.getElement().getStyle().setLeft(widget.getAbsoluteLeft(),
                        Unit.PX);
                fu.getElement().getStyle().setTop(widget.getAbsoluteTop(),
                        Unit.PX);
                fu.setVisible(true);
            }

        }
    }

    public int getRelativeX(int x, Element target) {
        return x - target.getAbsoluteLeft() + target.getScrollLeft()
                + target.getOwnerDocument().getScrollLeft();
    }

    public int getRelativeY(int y, Element target) {
        return y - target.getAbsoluteTop() + target.getScrollTop()
                + target.getOwnerDocument().getScrollTop();
    }

}
