/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PunctuationTrie<T> {
    private final char[] childMap;
    private final PunctuationTrie<T>[] children;
    private final boolean terminal;
    private final T value;
    private static final char[] ZERO_CHARS = new char[0];
    private static final PunctuationTrie<?>[] ZERO_TRIES = new PunctuationTrie[0];

    public PunctuationTrie(Map<String, T> elements) {
        this(PunctuationTrie.sortedUniqEntries(elements), 0);
    }

    private PunctuationTrie(List<Map.Entry<String, T>> elements, int depth) {
        this(elements, depth, 0, elements.size());
    }

    private PunctuationTrie(List<Map.Entry<String, T>> elements, int depth, int start, int end) {
        int n;
        boolean bl = this.terminal = depth == elements.get(start).getKey().length();
        if (this.terminal) {
            this.value = elements.get(start).getValue();
            if (start + 1 == end) {
                this.childMap = ZERO_CHARS;
                this.children = this.ownedChildArray(ZERO_TRIES);
                return;
            }
            ++start;
        } else {
            this.value = null;
        }
        int childCount = 0;
        int n2 = -1;
        for (int i = start; i < end; ++i) {
            char c;
            char ch = elements.get(i).getKey().charAt(depth);
            if (ch == c) continue;
            ++childCount;
            c = ch;
        }
        this.childMap = new char[childCount];
        this.children = this.ownedChildArray(new PunctuationTrie[childCount]);
        int n3 = start;
        int childIndex = 0;
        char lastCh = elements.get(start).getKey().charAt(depth);
        for (int i = start + 1; i < end; ++i) {
            char ch = elements.get(i).getKey().charAt(depth);
            if (ch == lastCh) continue;
            this.childMap[childIndex] = lastCh;
            this.children[childIndex++] = new PunctuationTrie<T>(elements, depth + 1, n, i);
            n = i;
            lastCh = ch;
        }
        this.childMap[childIndex] = lastCh;
        this.children[childIndex++] = new PunctuationTrie<T>(elements, depth + 1, n, end);
    }

    public boolean isTerminal() {
        return this.terminal;
    }

    public T getValue() {
        return this.value;
    }

    private PunctuationTrie<T>[] ownedChildArray(PunctuationTrie<?>[] unfilledArray) {
        return unfilledArray;
    }

    public PunctuationTrie<T> lookup(char ch) {
        int i = Arrays.binarySearch(this.childMap, ch);
        return i >= 0 ? this.children[i] : null;
    }

    public PunctuationTrie<T> lookup(CharSequence s) {
        PunctuationTrie<T> t = this;
        int n = s.length();
        for (int i = 0; i < n && null != (t = t.lookup(s.charAt(i))); ++i) {
        }
        return t;
    }

    public boolean contains(char ch) {
        return Arrays.binarySearch(this.childMap, ch) >= 0;
    }

    private static <T> List<Map.Entry<String, T>> sortedUniqEntries(Map<String, T> m) {
        return new ArrayList<Map.Entry<String, T>>(new TreeMap<String, T>(m).entrySet());
    }

    public void toStringList(List<String> strings) {
        this.toStringList("", strings);
    }

    private void toStringList(String prefix, List<String> strings) {
        if (this.terminal) {
            strings.add(prefix);
        }
        int n = this.childMap.length;
        for (int i = 0; i < n; ++i) {
            super.toStringList(prefix + this.childMap[i], strings);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toStringBuilder(0, sb);
        return sb.toString();
    }

    private void toStringBuilder(int depth, StringBuilder sb) {
        sb.append(this.terminal ? "terminal" : "nonterminal");
        ++depth;
        for (int i = 0; i < this.childMap.length; ++i) {
            sb.append('\n');
            for (int d = 0; d < depth; ++d) {
                sb.append('\t');
            }
            sb.append('\'').append(this.childMap[i]).append("' ");
            super.toStringBuilder(depth, sb);
        }
    }
}

